/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.globes.Earth;
import gov.nasa.worldwind.terrain.HighResolutionTerrain;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;

public class HighResolutionTerrainTest {
    protected static ArrayList<Position> generateReferenceLocations(Sector sector, int n, int n2) {
        ArrayList<Position> arrayList = new ArrayList<Position>();
        double d = (sector.getMaxLatitude().degrees - sector.getMinLatitude().degrees) / (double)(n - 1);
        double d2 = (sector.getMaxLongitude().degrees - sector.getMinLongitude().degrees) / (double)(n2 - 1);
        for (int i = 0; i < n; ++i) {
            double d3 = sector.getMinLatitude().degrees + (double)i * d;
            for (int j = 0; j < n2; ++j) {
                double d4 = sector.getMinLongitude().degrees + (double)j * d2;
                arrayList.add(Position.fromDegrees((double)Math.round(d3 * 100000.0) / 100000.0, (double)Math.round(d4 * 100000.0) / 100000.0, 0.0));
            }
        }
        return arrayList;
    }

    protected static void writeReferencePositions(String string, ArrayList<Position> arrayList) throws FileNotFoundException {
        PrintStream printStream = new PrintStream(new File(string));
        for (Position position : arrayList) {
            printStream.format("%.5f %.5f %.4f\n", position.getLatitude().degrees, position.getLongitude().degrees, position.getElevation());
        }
        printStream.flush();
    }

    protected static ArrayList<Position> readReferencePositions(String string) throws FileNotFoundException {
        ArrayList<Position> arrayList = new ArrayList<Position>();
        Scanner scanner = new Scanner(new File(string));
        while (scanner.hasNextDouble()) {
            double d = scanner.nextDouble();
            double d2 = scanner.nextDouble();
            double d3 = scanner.nextDouble();
            arrayList.add(Position.fromDegrees(d, d2, d3));
        }
        return arrayList;
    }

    protected static ArrayList<Position> computeElevations(ArrayList<Position> arrayList) {
        Sector sector = Sector.boundingSector(arrayList);
        HighResolutionTerrain highResolutionTerrain = new HighResolutionTerrain(new Earth(), sector, null, 1.0);
        ArrayList<Position> arrayList2 = new ArrayList<Position>();
        for (Position position : arrayList) {
            Double d = highResolutionTerrain.getElevation(position);
            arrayList2.add(new Position(position, (double)Math.round(d * 10000.0) / 10000.0));
        }
        return arrayList2;
    }

    protected static void testPositions(String string, ArrayList<Position> arrayList, ArrayList<Position> arrayList2) {
        int n = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!arrayList2.get(i).equals(arrayList.get(i))) {
                System.out.println("MISMATCH: reference = " + arrayList.get(i) + ", test = " + arrayList2.get(i));
                continue;
            }
            ++n;
        }
        System.out.println(n + " Matches for " + string);
    }

    protected static void generateReferenceValues(String string, Sector sector) throws FileNotFoundException {
        HighResolutionTerrain highResolutionTerrain = new HighResolutionTerrain(new Earth(), sector, null, 1.0);
        ArrayList<Position> arrayList = HighResolutionTerrainTest.generateReferenceLocations(highResolutionTerrain.getSector(), 5, 5);
        ArrayList<Position> arrayList2 = HighResolutionTerrainTest.computeElevations(arrayList);
        HighResolutionTerrainTest.writeReferencePositions(string, arrayList2);
    }

    public static void main(String[] stringArray) {
        String string = "testData/HighResolutionTerrain/";
        HashMap<String, Sector> hashMap = new HashMap<String, Sector>();
        hashMap.put(string + "HRTOutputTest01.txt", Sector.fromDegrees(37.8, 38.3, -120.0, -119.3));
        hashMap.put(string + "HRTOutputTest02.txt", Sector.fromDegrees(32.34767, 32.77991, 70.88239, 71.47658));
        hashMap.put(string + "HRTOutputTest03.txt", Sector.fromDegrees(32.37825, 71.2113, 32.5005, 71.37926));
        try {
            String string2;
            if (stringArray.length > 0 && stringArray[0].equals("-generateTestData")) {
                for (Map.Entry entry : hashMap.entrySet()) {
                    string2 = (String)entry.getKey();
                    HighResolutionTerrainTest.generateReferenceValues(string2, (Sector)entry.getValue());
                }
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                string2 = (String)entry.getKey();
                ArrayList<Position> arrayList = HighResolutionTerrainTest.readReferencePositions(string2);
                ArrayList<Position> arrayList2 = HighResolutionTerrainTest.computeElevations(arrayList);
                HighResolutionTerrainTest.testPositions(string2, arrayList, arrayList2);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
    }
}

