/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.globes.ElevationModel;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.TiledImageLayer;
import gov.nasa.worldwind.terrain.BasicElevationModel;
import gov.nasa.worldwind.terrain.CompoundElevationModel;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DetailHints
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Detail Hints", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() {
            this.makeDetailHintControls();
        }

        protected void setElevationModelDetailHint(double d) {
            this.setElevationModelDetailHint(this.getWwd().getModel().getGlobe().getElevationModel(), d);
            System.out.println("Terrain detail hint set to " + d);
        }

        protected void setElevationModelDetailHint(ElevationModel elevationModel, double d) {
            if (elevationModel instanceof BasicElevationModel) {
                ((BasicElevationModel)elevationModel).setDetailHint(d);
            } else if (elevationModel instanceof CompoundElevationModel) {
                for (ElevationModel elevationModel2 : ((CompoundElevationModel)elevationModel).getElevationModels()) {
                    this.setElevationModelDetailHint(elevationModel2, d);
                }
            }
        }

        protected void setTiledImageLayerDetailHint(double d) {
            for (Layer layer : this.getWwd().getModel().getLayers()) {
                if (!(layer instanceof TiledImageLayer)) continue;
                ((TiledImageLayer)layer).setDetailHint(d);
            }
            System.out.println("Image detail hint set to " + d);
        }

        protected void makeDetailHintControls() {
            Box box = Box.createVerticalBox();
            box.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
            hashtable.put(-10, new JLabel("-1.0"));
            hashtable.put(0, new JLabel("0.0"));
            hashtable.put(10, new JLabel("1.0"));
            JSlider jSlider = new JSlider(-10, 10, (int)(this.getWwd().getModel().getGlobe().getElevationModel().getDetailHint(Sector.FULL_SPHERE) * 10.0));
            jSlider.setMajorTickSpacing(5);
            jSlider.setMinorTickSpacing(1);
            jSlider.setPaintTicks(true);
            jSlider.setPaintLabels(true);
            jSlider.setLabelTable(hashtable);
            jSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    double d = (double)((JSlider)changeEvent.getSource()).getValue() / 10.0;
                    AppFrame.this.setElevationModelDetailHint(d);
                    AppFrame.this.getWwd().redraw();
                }
            });
            JLabel jLabel = new JLabel("Terrain Detail");
            jLabel.setAlignmentX(0.5f);
            jSlider.setAlignmentX(0.5f);
            box.add(jLabel);
            box.add(jSlider);
            JSlider jSlider2 = new JSlider(-10, 10, 0);
            jSlider2.setMajorTickSpacing(5);
            jSlider2.setMinorTickSpacing(1);
            jSlider2.setPaintTicks(true);
            jSlider2.setPaintLabels(true);
            jSlider2.setLabelTable(hashtable);
            jSlider2.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    double d = (double)((JSlider)changeEvent.getSource()).getValue() / 10.0;
                    AppFrame.this.setTiledImageLayerDetailHint(d);
                    AppFrame.this.getWwd().redraw();
                }
            });
            jLabel = new JLabel("Image Detail");
            jLabel.setAlignmentX(0.5f);
            jSlider2.setAlignmentX(0.5f);
            box.add(Box.createVerticalStrut(10));
            box.add(jLabel);
            box.add(jSlider2);
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9), new TitledBorder("Scene Detail")));
            jPanel.add((Component)box, "Center");
            this.getLayerPanel().add((Component)jPanel, "South");
        }
    }
}

