/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.worldwindow.features.swinglayermanager;

import gov.nasa.worldwindx.applications.worldwindow.core.Controller;
import gov.nasa.worldwindx.applications.worldwindow.core.Registry;
import gov.nasa.worldwindx.applications.worldwindow.features.AbstractFeature;
import gov.nasa.worldwindx.applications.worldwindow.features.swinglayermanager.ControlsPanel;
import gov.nasa.worldwindx.applications.worldwindow.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JDialog;

public class LayerManagerDialog
extends AbstractFeature {
    private static final String ICON_PATH = "gov/nasa/worldwindx/applications/worldwindow/images/layer-manager-64x64.png";
    protected JDialog dialog;
    protected boolean positionInitialized = false;

    public LayerManagerDialog(Registry registry) {
        super("Layer Manager", "gov.nasa.worldwindx.applications.worldwindow.feature.LayerManagerDialog", ICON_PATH, registry);
        this.setEnabled(true);
    }

    @Override
    public void initialize(Controller controller) {
        super.initialize(controller);
        this.dialog = new JDialog(this.controller.getFrame());
        this.dialog.setPreferredSize(new Dimension(350, 700));
        this.dialog.getContentPane().setLayout(new BorderLayout());
        this.dialog.setResizable(true);
        this.dialog.setModal(false);
        this.dialog.setTitle("Layer Manager");
        ControlsPanel controlsPanel = (ControlsPanel)controller.getRegisteredObject("gov.nasa.worldwindx.applications.worldwindow.ControlsPanel");
        if (controlsPanel != null) {
            this.dialog.getContentPane().add((Component)controlsPanel.getJPanel(), "Center");
        } else {
            Util.getLogger().severe("Control panel is not registered.");
        }
        this.dialog.pack();
        this.addToToolBar();
    }

    @Override
    public boolean isTwoState() {
        return true;
    }

    @Override
    public boolean isOn() {
        return this.dialog.isVisible();
    }

    @Override
    public void turnOn(boolean bl) {
        if (bl && !this.positionInitialized) {
            Util.positionDialogInContainer(this.dialog, this.controller.getAppPanel().getJPanel(), 7, 1);
            this.positionInitialized = true;
            this.controller.getLayerManager().scrollToLayer(null);
        }
        this.setVisible(bl);
    }

    protected void setVisible(boolean bl) {
        this.dialog.setVisible(bl);
    }
}

