/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.sar;

import gov.nasa.worldwind.Restorable;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.ScalebarLayer;
import gov.nasa.worldwind.layers.TerrainProfileLayer;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerListModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TerrainProfilePanel
extends JPanel
implements Restorable {
    public static final String TERRAIN_PROFILE_OPEN = "TerrainProfilePanel.Open";
    public static final String TERRAIN_PROFILE_CHANGE = "TerrainProfilePanel.Change";
    private final TerrainProfileController controller;
    private static final String GRAPH_SIZE_SMALL_TEXT = "Small Graph";
    private static final String GRAPH_SIZE_MEDIUM_TEXT = "Medium Graph";
    private static final String GRAPH_SIZE_LARGE_TEXT = "Large Graph";
    private static final String FOLLOW_VIEW_TEXT = "Profile At Screen Center";
    private static final String FOLLOW_CURSOR_TEXT = "Profile Under Cursor";
    private static final String FOLLOW_OBJECT_TEXT = "Profile Under Aircraft";
    private static final String FOLLOW_NONE_TEXT = "No Profile";
    private JPanel panel1;
    private JPanel panel2;
    private JPanel panel6;
    private JPanel panel5;
    private JComboBox sizeComboBox;
    private JPanel panel7;
    private JComboBox followComboBox;
    private JPanel panel3;
    private JCheckBox proportionalCheckBox;
    private JCheckBox showEyeCheckBox;
    private JCheckBox zeroBaseCheckBox;
    private JPanel panel4;
    private JSpinner profileWidthSpinner;
    private JLabel profileWidthLabel;
    private JPanel panel8;
    private JPanel panel4b;
    private JSpinner profileLengthSpinner;
    private JLabel profileLengthLabel;
    private JPanel panel4c;
    private JCheckBox profilesSameSize;
    private JPanel panel4d;
    private JCheckBox profileFollowPath;

    public TerrainProfilePanel() {
        this.initComponents();
        this.controller = new TerrainProfileController();
    }

    public WorldWindow getWwd() {
        return this.controller.getWwd();
    }

    public void setWwd(WorldWindow worldWindow) {
        this.controller.setWwd(worldWindow);
        this.matchProfileToPanel();
    }

    private void matchProfileToPanel() {
        this.setFollow();
        this.controller.setProfileSize((String)this.sizeComboBox.getSelectedItem());
        this.controller.setKeepProportions(this.proportionalCheckBox.isSelected());
        this.controller.setShowEyePosition(this.showEyeCheckBox.isSelected());
        this.controller.setZeroBased(this.zeroBaseCheckBox.isSelected());
        this.controller.setProfileWidthFactor(Double.parseDouble(((String)this.profileWidthSpinner.getValue()).replace("x", "")));
        this.controller.setProfileLengthFactor(Double.parseDouble(((String)this.profileLengthSpinner.getValue()).replace("x", "")));
    }

    private void sizeComboBoxActionPerformed(ActionEvent actionEvent) {
        this.controller.setProfileSize((String)this.sizeComboBox.getSelectedItem());
    }

    private void followComboBoxActionPerformed(ActionEvent actionEvent) {
        this.setFollow();
    }

    public void setFollowObject() {
        this.followComboBox.getModel().setSelectedItem(FOLLOW_OBJECT_TEXT);
    }

    private void setFollow() {
        this.controller.setFollow((String)this.followComboBox.getSelectedItem());
        String string = this.controller.getFollow();
        if (string == "gov.nasa.worldwind.TerrainProfileLayer.FollowView") {
            if (this.showEyeCheckBox.isEnabled()) {
                this.showEyeCheckBox.setEnabled(false);
            }
            if (!this.profileWidthSpinner.isEnabled()) {
                this.profileWidthSpinner.setEnabled(true);
            }
            if (this.profileLengthSpinner.isEnabled()) {
                this.profileLengthSpinner.setEnabled(false);
            }
        } else if (string == "gov.nasa.worldwind.TerrainProfileLayer.FollowCursor") {
            if (this.showEyeCheckBox.isEnabled()) {
                this.showEyeCheckBox.setEnabled(false);
            }
            if (!this.profileWidthSpinner.isEnabled()) {
                this.profileWidthSpinner.setEnabled(true);
            }
            if (this.profileLengthSpinner.isEnabled()) {
                this.profileLengthSpinner.setEnabled(false);
            }
        } else if (string == "gov.nasa.worldwind.TerrainProfileLayer.FollowObject") {
            if (!this.showEyeCheckBox.isEnabled()) {
                this.showEyeCheckBox.setEnabled(true);
            }
            if (!this.profileWidthSpinner.isEnabled()) {
                this.profileWidthSpinner.setEnabled(true);
            }
            if (!this.profileLengthSpinner.isEnabled()) {
                this.profileLengthSpinner.setEnabled(true);
            }
        } else if (string == "gov.nasa.worldwind.TerrainProfileLayer.FollowNone") {
            if (this.showEyeCheckBox.isEnabled()) {
                this.showEyeCheckBox.setEnabled(false);
            }
            if (this.profileWidthSpinner.isEnabled()) {
                this.profileWidthSpinner.setEnabled(false);
            }
            if (this.profileLengthSpinner.isEnabled()) {
                this.profileLengthSpinner.setEnabled(false);
            }
        }
    }

    private void proportionalCheckBoxItemStateChanged(ItemEvent itemEvent) {
        this.controller.setKeepProportions(((JCheckBox)itemEvent.getSource()).isSelected());
    }

    private void showEyeCheckBoxItemStateChanged(ItemEvent itemEvent) {
        this.controller.setShowEyePosition(((JCheckBox)itemEvent.getSource()).isSelected());
    }

    private void zeroBaseCheckBoxItemStateChanged(ItemEvent itemEvent) {
        this.controller.setZeroBased(((JCheckBox)itemEvent.getSource()).isSelected());
    }

    private void profileWidthSpinnerStateChanged(ChangeEvent changeEvent) {
        String string = (String)((JSpinner)changeEvent.getSource()).getValue();
        string = string.replace("x", "");
        this.controller.setProfileWidthFactor(Double.parseDouble(string));
        if (this.profilesSameSize.isSelected()) {
            this.profileLengthSpinner.setValue(this.profileWidthSpinner.getValue());
        }
    }

    private void profileLengthSpinnerStateChanged(ChangeEvent changeEvent) {
        String string = (String)((JSpinner)changeEvent.getSource()).getValue();
        string = string.replace("x", "");
        this.controller.setProfileLengthFactor(Double.parseDouble(string));
        if (this.profilesSameSize.isSelected()) {
            this.profileWidthSpinner.setValue(this.profileLengthSpinner.getValue());
        }
    }

    public void profilesSameSizeStateChanged(ChangeEvent changeEvent) {
        if (((JCheckBox)changeEvent.getSource()).isSelected()) {
            this.profileLengthSpinner.setValue(this.profileWidthSpinner.getValue());
        }
    }

    public void profileFollowPathStateChanged(ChangeEvent changeEvent) {
        this.controller.setWholeTrackLength(((JCheckBox)changeEvent.getSource()).isSelected());
    }

    public void updatePosition(Position position, Angle angle) {
        this.controller.updatePosition(position, angle);
    }

    public void updatePath(ArrayList<? extends LatLon> arrayList) {
        this.controller.updatePath(arrayList);
    }

    public String getFollow() {
        return this.controller.getFollow();
    }

    private void initComponents() {
        this.panel1 = new JPanel();
        this.panel2 = new JPanel();
        this.panel6 = new JPanel();
        this.panel5 = new JPanel();
        this.sizeComboBox = new JComboBox();
        this.panel7 = new JPanel();
        this.followComboBox = new JComboBox();
        this.panel3 = new JPanel();
        this.proportionalCheckBox = new JCheckBox();
        this.showEyeCheckBox = new JCheckBox();
        this.zeroBaseCheckBox = new JCheckBox();
        this.panel4 = new JPanel();
        this.profileWidthSpinner = new JSpinner();
        this.profileWidthLabel = new JLabel();
        this.panel8 = new JPanel();
        this.panel4b = new JPanel();
        this.profileLengthSpinner = new JSpinner();
        this.profileLengthLabel = new JLabel();
        this.panel4c = new JPanel();
        this.profilesSameSize = new JCheckBox();
        this.panel4d = new JPanel();
        this.profileFollowPath = new JCheckBox();
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setLayout(new BorderLayout(20, 20));
        this.panel1.setLayout(new BorderLayout(20, 20));
        this.panel2.setLayout(new GridLayout(1, 2, 20, 10));
        this.panel6.setLayout(new GridLayout(1, 2, 20, 10));
        this.panel5.setLayout(new BorderLayout(5, 5));
        this.sizeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{GRAPH_SIZE_SMALL_TEXT, GRAPH_SIZE_MEDIUM_TEXT, GRAPH_SIZE_LARGE_TEXT}));
        this.sizeComboBox.setToolTipText("Size of profile graph");
        this.sizeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TerrainProfilePanel.this.sizeComboBoxActionPerformed(actionEvent);
            }
        });
        this.panel5.add((Component)this.sizeComboBox, "Center");
        this.panel6.add(this.panel5);
        this.panel7.setLayout(new BorderLayout(5, 5));
        this.followComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{FOLLOW_VIEW_TEXT, FOLLOW_CURSOR_TEXT, FOLLOW_OBJECT_TEXT, FOLLOW_NONE_TEXT}));
        this.followComboBox.setToolTipText("Set profile behavior");
        this.followComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TerrainProfilePanel.this.followComboBoxActionPerformed(actionEvent);
            }
        });
        this.panel7.add((Component)this.followComboBox, "Center");
        this.panel6.add(this.panel7);
        this.panel2.add(this.panel6);
        this.panel1.add((Component)this.panel2, "North");
        this.panel3.setLayout(new GridLayout(1, 3, 10, 10));
        this.proportionalCheckBox.setText("Proportional");
        this.proportionalCheckBox.setToolTipText("Maintain 1:1 profile dimensions");
        this.proportionalCheckBox.setAlignmentX(0.5f);
        this.proportionalCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                TerrainProfilePanel.this.proportionalCheckBoxItemStateChanged(itemEvent);
            }
        });
        this.panel3.add(this.proportionalCheckBox);
        this.showEyeCheckBox.setText("Show A/C Position");
        this.showEyeCheckBox.setToolTipText("Show aircraft position in profile graph");
        this.showEyeCheckBox.setAlignmentX(0.5f);
        this.showEyeCheckBox.setHorizontalAlignment(0);
        this.showEyeCheckBox.setSelected(true);
        this.showEyeCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                TerrainProfilePanel.this.showEyeCheckBoxItemStateChanged(itemEvent);
            }
        });
        this.panel3.add(this.showEyeCheckBox);
        this.zeroBaseCheckBox.setText("MSL Base");
        this.zeroBaseCheckBox.setToolTipText("Show mean sea level in profile graph");
        this.zeroBaseCheckBox.setAlignmentX(0.5f);
        this.zeroBaseCheckBox.setHorizontalAlignment(11);
        this.zeroBaseCheckBox.setSelected(true);
        this.zeroBaseCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                TerrainProfilePanel.this.zeroBaseCheckBoxItemStateChanged(itemEvent);
            }
        });
        this.panel3.add(this.zeroBaseCheckBox);
        this.panel1.add((Component)this.panel3, "Center");
        this.panel8.setLayout(new GridLayout(2, 2, 20, 10));
        Object[] objectArray = new String[]{"x1", "x2", "x3", "x4", "x5", "x7", "x10"};
        this.panel4.setBorder(BorderFactory.createEmptyBorder());
        this.panel4.setLayout(new BorderLayout(5, 0));
        this.profileWidthSpinner.setToolTipText("Profile width");
        this.profileWidthSpinner.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.profileWidthSpinner.setAlignmentX(1.5f);
        this.profileWidthSpinner.setModel(new SpinnerListModel(objectArray));
        this.profileWidthSpinner.setValue("x1");
        this.profileWidthSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                TerrainProfilePanel.this.profileWidthSpinnerStateChanged(changeEvent);
            }
        });
        this.panel4.add((Component)this.profileWidthSpinner, "Center");
        this.profileWidthLabel.setText("Profile Width:");
        this.panel4.add((Component)this.profileWidthLabel, "West");
        this.panel8.add(this.panel4);
        this.panel4b.setBorder(BorderFactory.createEmptyBorder());
        this.panel4b.setLayout(new BorderLayout(5, 0));
        this.profileLengthSpinner.setToolTipText("Profile Length along track");
        this.profileLengthSpinner.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.profileLengthSpinner.setAlignmentX(1.5f);
        this.profileLengthSpinner.setModel(new SpinnerListModel(objectArray));
        this.profileLengthSpinner.setValue("x1");
        this.profileLengthSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                TerrainProfilePanel.this.profileLengthSpinnerStateChanged(changeEvent);
            }
        });
        this.panel4b.add((Component)this.profileLengthSpinner, "Center");
        this.profileLengthLabel.setText("Profile Length:");
        this.panel4b.add((Component)this.profileLengthLabel, "West");
        this.panel8.add(this.panel4b);
        this.panel4c.setBorder(BorderFactory.createEmptyBorder());
        this.panel4c.setLayout(new BorderLayout(5, 0));
        this.profilesSameSize.setText("Same size");
        this.profilesSameSize.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                TerrainProfilePanel.this.profilesSameSizeStateChanged(changeEvent);
            }
        });
        this.panel4c.add((Component)this.profilesSameSize, "Center");
        this.panel8.add(this.panel4c);
        this.panel4d.setBorder(BorderFactory.createEmptyBorder());
        this.panel4d.setLayout(new BorderLayout(5, 0));
        this.profileFollowPath.setText("Whole track length");
        this.profileFollowPath.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                TerrainProfilePanel.this.profileFollowPathStateChanged(changeEvent);
            }
        });
        this.panel4d.add((Component)this.profileFollowPath, "Center");
        this.panel8.add(this.panel4d);
        this.panel1.add((Component)this.panel8, "South");
        this.add((Component)this.panel1, "Center");
    }

    @Override
    public String getRestorableState() {
        RestorableSupport restorableSupport = RestorableSupport.newRestorableSupport();
        this.doGetRestorableState(restorableSupport, null);
        return restorableSupport.getStateAsXml();
    }

    @Override
    public void restoreState(String string) {
        RestorableSupport restorableSupport;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        try {
            restorableSupport = RestorableSupport.parse(string);
        }
        catch (Exception exception) {
            String string3 = Logging.getMessage("generic.ExceptionAttemptingToParseStateXml", string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3, exception);
        }
        this.doRestoreState(restorableSupport, null);
    }

    protected void doGetRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        restorableSupport.addStateValueAsString(stateObject, "size", (String)this.sizeComboBox.getSelectedItem());
        restorableSupport.addStateValueAsString(stateObject, "follow", (String)this.followComboBox.getSelectedItem());
        restorableSupport.addStateValueAsBoolean(stateObject, "proportional", this.proportionalCheckBox.isSelected());
        restorableSupport.addStateValueAsBoolean(stateObject, "zeroBase", this.zeroBaseCheckBox.isSelected());
        restorableSupport.addStateValueAsBoolean(stateObject, "showEye", this.showEyeCheckBox.isSelected());
        restorableSupport.addStateValueAsString(stateObject, "width", (String)this.profileWidthSpinner.getValue());
        restorableSupport.addStateValueAsString(stateObject, "length", (String)this.profileLengthSpinner.getValue());
        restorableSupport.addStateValueAsBoolean(stateObject, "sameSize", this.profilesSameSize.isSelected());
        restorableSupport.addStateValueAsBoolean(stateObject, "followPath", this.profileFollowPath.isSelected());
    }

    protected void doRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        Boolean bl;
        Boolean bl2;
        String string;
        String string2;
        Boolean bl3;
        Boolean bl4;
        Boolean bl5;
        String string3;
        String string4 = restorableSupport.getStateValueAsString(stateObject, "size");
        if (string4 != null) {
            this.sizeComboBox.setSelectedItem(string4);
        }
        if ((string3 = restorableSupport.getStateValueAsString(stateObject, "follow")) != null) {
            this.followComboBox.setSelectedItem(string3);
        }
        if ((bl5 = restorableSupport.getStateValueAsBoolean(stateObject, "proportional")) != null) {
            this.proportionalCheckBox.setSelected(bl5);
        }
        if ((bl4 = restorableSupport.getStateValueAsBoolean(stateObject, "zeroBase")) != null) {
            this.zeroBaseCheckBox.setSelected(bl4);
        }
        if ((bl3 = restorableSupport.getStateValueAsBoolean(stateObject, "showEye")) != null) {
            this.showEyeCheckBox.setSelected(bl3);
        }
        if ((string2 = restorableSupport.getStateValueAsString(stateObject, "width")) != null) {
            this.profileWidthSpinner.setValue(string2);
        }
        if ((string = restorableSupport.getStateValueAsString(stateObject, "length")) != null) {
            this.profileLengthSpinner.setValue(string);
        }
        if ((bl2 = restorableSupport.getStateValueAsBoolean(stateObject, "sameSize")) != null) {
            this.profilesSameSize.setSelected(bl2);
        }
        if ((bl = restorableSupport.getStateValueAsBoolean(stateObject, "followPath")) != null) {
            this.profileFollowPath.setSelected(bl);
        }
    }

    private static class TerrainProfileController {
        private static final HashMap<String, Dimension> sizes = new HashMap();
        private static final HashMap<String, String> follows;
        private WorldWindow wwd;
        private TerrainProfileLayer tpl = new TerrainProfileLayer();
        private TerrainProfileLayer tpl2;
        private boolean wholeTrackLength = false;

        public static String[] getSizeKeys() {
            return sizes.keySet().toArray(new String[1]);
        }

        public static String[] getFollowKeys() {
            return follows.keySet().toArray(new String[1]);
        }

        public TerrainProfileController() {
            this.tpl.setZeroBased(true);
            this.tpl2 = new TerrainProfileLayer();
            this.tpl2.setZeroBased(true);
            this.tpl2.setPosition("gov.nasa.worldwind.layers.ViewControlsLayer.SouthEast");
        }

        public WorldWindow getWwd() {
            return this.wwd;
        }

        public void setWwd(WorldWindow worldWindow) {
            this.wwd = worldWindow;
            if (this.wwd != null) {
                ApplicationTemplate.insertBeforeCompass(worldWindow, this.tpl);
                this.tpl.setEventSource(worldWindow);
                ApplicationTemplate.insertBeforeCompass(worldWindow, this.tpl2);
                this.tpl2.setEventSource(worldWindow);
                this.tpl2.setPathType(2);
                for (Layer layer : worldWindow.getModel().getLayers()) {
                    if (!(layer instanceof ScalebarLayer)) continue;
                    ((ScalebarLayer)layer).setPosition("gov.nasa.worldwind.layers.ViewControlsLayer.NorthWest");
                }
                this.update();
            }
        }

        private void update() {
            if (this.wwd != null) {
                this.wwd.redraw();
            }
        }

        public void setShowEyePosition(boolean bl) {
            this.tpl.setShowEyePosition(bl);
            this.tpl2.setShowEyePosition(bl);
            this.update();
        }

        public boolean getShowEyePosition() {
            return this.tpl.getShowEyePosition();
        }

        public void setZeroBased(boolean bl) {
            this.tpl.setZeroBased(bl);
            this.tpl2.setZeroBased(bl);
            this.update();
        }

        public boolean getShowZeroBased() {
            return this.tpl.getZeroBased();
        }

        public void setKeepProportions(boolean bl) {
            this.tpl.setKeepProportions(bl);
            this.tpl2.setKeepProportions(bl);
            this.update();
        }

        public boolean getKeepProportions() {
            return this.tpl.getKeepProportions();
        }

        public void setProfileSize(String string) {
            Dimension dimension = sizes.get(string);
            if (dimension != null) {
                this.tpl.setSize(dimension);
                this.tpl2.setSize(dimension);
                this.update();
            }
        }

        public Dimension getProfileSize() {
            return this.tpl.getSize();
        }

        public void setFollow(String string) {
            String string2 = follows.get(string);
            if (string2 != null) {
                this.tpl.setFollow(string2);
                if (string2.equals("gov.nasa.worldwind.TerrainProfileLayer.FollowObject") || string2.equals("gov.nasa.worldwind.TerrainProfileLayer.FollowEye")) {
                    this.tpl2.setFollow(this.wholeTrackLength ? "gov.nasa.worldwind.TerrainProfileLayer.FollowPath" : "gov.nasa.worldwind.TerrainProfileLayer.FollowObject");
                } else {
                    this.tpl2.setFollow("gov.nasa.worldwind.TerrainProfileLayer.FollowNone");
                }
                this.update();
            }
        }

        public String getFollow() {
            return this.tpl.getFollow();
        }

        public void setWholeTrackLength(boolean bl) {
            if (this.wholeTrackLength != bl) {
                this.wholeTrackLength = bl;
                if (!this.tpl2.getFollow().equals("gov.nasa.worldwind.TerrainProfileLayer.FollowNone")) {
                    this.tpl2.setFollow(this.wholeTrackLength ? "gov.nasa.worldwind.TerrainProfileLayer.FollowPath" : "gov.nasa.worldwind.TerrainProfileLayer.FollowObject");
                }
                this.update();
            }
        }

        public void setProfileWidthFactor(double d) {
            this.tpl.setProfileLengthFactor(d);
            this.update();
        }

        public void setProfileLengthFactor(double d) {
            this.tpl2.setProfileLengthFactor(d);
            this.update();
        }

        public double getProfileWidthFactor() {
            return this.tpl.getProfileLenghtFactor();
        }

        public double getProfileLengthFactor() {
            return this.tpl2.getProfileLenghtFactor();
        }

        public void updatePosition(Position position, Angle angle) {
            this.tpl.setObjectPosition(position);
            this.tpl.setObjectHeading(angle);
            this.tpl2.setObjectPosition(position);
            this.tpl2.setObjectHeading(angle.addDegrees(-90.0));
            this.update();
        }

        public void updatePath(ArrayList<? extends LatLon> arrayList) {
            this.tpl2.setPathPositions(arrayList);
            this.update();
        }

        static {
            sizes.put(TerrainProfilePanel.GRAPH_SIZE_SMALL_TEXT, new Dimension(250, 100));
            sizes.put(TerrainProfilePanel.GRAPH_SIZE_MEDIUM_TEXT, new Dimension(450, 140));
            sizes.put(TerrainProfilePanel.GRAPH_SIZE_LARGE_TEXT, new Dimension(655, 240));
            follows = new HashMap();
            follows.put(TerrainProfilePanel.FOLLOW_VIEW_TEXT, "gov.nasa.worldwind.TerrainProfileLayer.FollowView");
            follows.put(TerrainProfilePanel.FOLLOW_CURSOR_TEXT, "gov.nasa.worldwind.TerrainProfileLayer.FollowCursor");
            follows.put(TerrainProfilePanel.FOLLOW_OBJECT_TEXT, "gov.nasa.worldwind.TerrainProfileLayer.FollowObject");
            follows.put(TerrainProfilePanel.FOLLOW_NONE_TEXT, "gov.nasa.worldwind.TerrainProfileLayer.FollowNone");
        }
    }
}

