/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.snow;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import org.unijena.j2k.physicalCalculations.DailySolarRadiationCalculationMethods;

@JAMSComponentDescription(title="WASIMProcessSnow", author="Joerg Schulla, implementation and minor adaptations Peter Krause", description="Adaptation of the WASIM module for snow calculation")
public class WASIMProcessSnow
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="time")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Entity area", unit="m\u00b2")
    public Attribute.Double area;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Entity slope aspect correction factor")
    public Attribute.Double sloAspCorrFactor;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Entity latitude")
    public Attribute.Double latitude;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Entity landuse albedo")
    public Attribute.Double landAlbedo;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Snow water equivalent", unit="mm")
    public Attribute.Double snowWaterEquivalent;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="liquid water in snowpack", unit="mm")
    public Attribute.Double freeWater;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="frozen water in snowpack", unit="mm")
    public Attribute.Double iceContent;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="radiation melt factor", unit="mm / C*day")
    public Attribute.Double radiationMeltFactor;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="the snow melt")
    public Attribute.Double snowMelt;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="the albedo of the entity")
    public Attribute.Double snowAlbedo;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="actual evapotranspiration")
    public Attribute.Double aET;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="factor for calculating max. radiation melt factor")
    public Attribute.Double rmf_max;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="min. radiation melt factor")
    public Attribute.Double rmf_min;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="melt temperature: temperature atwhich snow melt will start", unit="C")
    public Attribute.Double meltTemp;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="refreezing coefficient")
    public Attribute.Double refCoeff;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="flag for selection of melt method1 = temperature index approach2 = tempWindAproach")
    public Attribute.Integer meltMethod;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="factor c0 for potential melt rate")
    public Attribute.Double c0Factor;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="factor c1 for potential melt rate")
    public Attribute.Double c1Factor;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="factor c2 for potential melt rate")
    public Attribute.Double c2Factor;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Free-water holding capacity (decimal percent) of snowpack expressed as decimal fraction of total snowpack water equivalent")
    public Attribute.Double freeWaterCapacity;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="constant albedo of snow")
    public Attribute.Double snowConstAlbedo;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="rain amount")
    public Attribute.Double rain;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="snow amount")
    public Attribute.Double snow;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="precip amount")
    public Attribute.Double precip;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="wind speed", unit="m/s")
    public Attribute.Double wind;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="minum temperature", unit="C")
    public Attribute.Double tmin;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="mean temperature", unit="C")
    public Attribute.Double tmean;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="max temperature", unit="C")
    public Attribute.Double tmax;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="potential evapotranspiration")
    public Attribute.Double pET;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="module active")
    public Attribute.Boolean active;
    double runRain;
    double runSnow;
    double runIceContent;
    double runFreeWater;
    double runSnowWaterEquivalent;
    double runMeltTemperature;
    double runRadiationMeltFactor;
    double runWind;
    double runPrecip;
    double runSnowMelt;
    double runSnowAlbedo;
    double runAET;

    public void init() {
    }

    public void run() {
        if (this.active == null || this.active.getValue()) {
            this.runRain = this.rain.getValue();
            this.runSnow = this.snow.getValue();
            this.runWind = this.wind.getValue();
            this.runPrecip = this.precip.getValue();
            this.runIceContent = this.iceContent.getValue();
            this.runFreeWater = this.freeWater.getValue();
            this.runSnowWaterEquivalent = this.snowWaterEquivalent.getValue();
            this.runSnowMelt = 0.0;
            this.runSnowAlbedo = this.snowAlbedo.getValue();
            this.runAET = this.aET.getValue();
            this.runMeltTemperature = this.meltTemp.getValue();
            int runMeltMethod = this.meltMethod.getValue();
            double tempDay = (this.tmax.getValue() + this.tmean.getValue()) / 2.0;
            double tempNight = (this.tmin.getValue() + this.tmean.getValue()) / 2.0;
            if (this.runSnow > 0.0 || this.runSnowWaterEquivalent > 0.0) {
                double deltaET = this.pET.getValue() - this.runAET;
                if (this.runIceContent <= deltaET) {
                    this.runAET += this.runIceContent;
                    this.runIceContent = 0.0;
                } else {
                    this.runIceContent -= deltaET;
                    this.runAET = this.pET.getValue();
                }
                int julDay = this.time.get(6);
                double dayFrac = DailySolarRadiationCalculationMethods.calcDayFraction(this.latitude.getValue(), julDay);
                this.runRadiationMeltFactor = this.calcRadiationMeltFactor2(julDay);
                double potMeltRate = this.calcAccumulationAndMelt(tempDay, dayFrac, runMeltMethod);
                potMeltRate += this.calcAccumulationAndMelt(tempNight, 1.0 - dayFrac, runMeltMethod);
                potMeltRate *= this.area.getValue();
                this.runRain = 0.0;
                this.runSnow = 0.0;
                if (potMeltRate > this.runIceContent) {
                    potMeltRate = this.runIceContent;
                }
                this.runIceContent -= potMeltRate;
                this.runFreeWater += potMeltRate;
                double maxFreeWater = this.runIceContent * this.freeWaterCapacity.getValue();
                if (maxFreeWater < this.runFreeWater) {
                    this.runSnowMelt = this.runFreeWater - maxFreeWater;
                    this.runFreeWater = maxFreeWater;
                }
                this.runSnowAlbedo = this.runIceContent + this.runFreeWater > 5.0 * this.area.getValue() ? this.snowConstAlbedo.getValue() : this.landAlbedo.getValue();
            }
            this.iceContent.setValue(this.runIceContent);
            this.freeWater.setValue(this.runFreeWater);
            this.snowWaterEquivalent.setValue(this.runIceContent + this.runFreeWater);
            this.snowMelt.setValue(this.runSnowMelt);
            this.snowAlbedo.setValue(this.runSnowAlbedo);
            this.aET.setValue(this.runAET);
            this.rain.setValue(this.runRain);
            this.snow.setValue(this.runSnow);
        }
    }

    public void cleanup() {
    }

    private double calcRadiationMeltFactor1(int julDay) {
        double rmf = 0.0;
        double rmfMax = this.rmf_min.getValue() * this.rmf_max.getValue();
        double r_b = (rmfMax - this.rmf_min.getValue()) / 2.0;
        double r_a = this.rmf_min.getValue() + r_b;
        double r_c = 0.01721420632103996;
        double r_d = -80.0;
        rmf = r_a + r_b * Math.sin(r_c * (r_d + (double)julDay));
        return rmf;
    }

    private double calcRadiationMeltFactor2(int julDay) {
        double rmf = 0.0;
        double rmfMax = this.rmf_min.getValue() * this.rmf_max.getValue();
        double r_b = (rmfMax - this.rmf_min.getValue()) / 2.0;
        double r_a = this.rmf_min.getValue() + r_b;
        double r_c = 0.01721420632103996;
        double r_d = -80.0;
        rmf = r_a + r_b * Math.sin(r_c * (r_d + (double)julDay));
        return rmf;
    }

    private double calcIceSaturationVapourPressure(double temperature) {
        double est = 0.0;
        est = 6.1078 * Math.exp(21.874 * temperature / (265.5 + temperature));
        return est;
    }

    private double calcAccumulationAndMelt(double temperature, double dayFraction, int runMeltMethod) {
        this.runIceContent += this.runSnow * dayFraction;
        this.runFreeWater += this.runRain * dayFraction;
        double potMeltRate = 0.0;
        if (temperature <= this.runMeltTemperature) {
            if (runMeltMethod == 3) {
                double negMelt = Math.abs(this.refCoeff.getValue() * this.runRadiationMeltFactor * (temperature - this.runMeltTemperature));
                negMelt *= dayFraction;
                if ((negMelt *= this.area.getValue()) <= this.runFreeWater) {
                    this.runFreeWater -= negMelt;
                    this.runIceContent += negMelt;
                } else {
                    this.runIceContent += this.runFreeWater;
                    this.runFreeWater = 0.0;
                }
            }
        } else if (this.runIceContent > 0.0) {
            if (runMeltMethod == 1) {
                potMeltRate = this.c0Factor.getValue() * (temperature - this.runMeltTemperature);
            } else if (runMeltMethod == 2) {
                potMeltRate = (this.c1Factor.getValue() + this.c2Factor.getValue() * this.runWind) * (temperature - this.runMeltTemperature);
            } else if (runMeltMethod == 3) {
                if (this.runPrecip >= 2.0) {
                    double ms = 1.2 * temperature;
                    double mh = (this.c1Factor.getValue() + this.c2Factor.getValue() * this.runWind) * temperature;
                    double ml = (this.c1Factor.getValue() + this.c2Factor.getValue() * this.runWind) * (this.calcIceSaturationVapourPressure(temperature) - 6.11) / 0.662;
                    double mp = 0.0125 * this.runPrecip * temperature;
                    potMeltRate = ms + mh + ml + mp;
                } else {
                    double factor = 0.5 * (1.0 + this.sloAspCorrFactor.getValue());
                    double rmfCorr = this.runRadiationMeltFactor * factor;
                    potMeltRate = rmfCorr * (temperature - this.runMeltTemperature);
                }
            }
        }
        return potMeltRate * dayFraction;
    }
}

