/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.regionalisation;

import jams.JAMS;
import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;

@JAMSComponentDescription(title="LapseRateRegionalization", author="Santosh Nepal, Peter Krause, Sven Kralisch", description="Regionalisation through station proximity and elevationdifference based on yearly/monthly lapse rates.\n1. Find the closest station with valid measurement\n2. Cacluate the elevation difference between modelling unitand station\n3. Adjust the station measurement according to the lapse rate and elevation difference", date="2019-10-15", version="1.0_1")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version"), @VersionComments.Entry(version="1.0_1", comment="Fixed bug in fixedMinimum/fixedMaximum evaluation")})
public class LapseRateRegionalization
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Measured station inputs")
    public Attribute.DoubleArray inputValues;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Station elevations")
    public Attribute.DoubleArray statElev;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Station IDs ordered by their distance")
    public Attribute.IntegerArray statOrder;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Entity elevation")
    public Attribute.Double entityElev;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Lapse rates for 100m elevation difference, given either as a single values or as 12 (monthly) values")
    public Attribute.Double[] lapseRates;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The current model time")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Calculated output for the modelling entity")
    public Attribute.Double outputValue;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Absolute possible minimum value for data set", defaultValue="-Infinity")
    public Attribute.Double fixedMinimum;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Absolute possible maximum value for data set", defaultValue="Infinity")
    public Attribute.Double fixedMaximum;

    public void init() {
        if (this.lapseRates.length != 1 && this.lapseRates.length != 12) {
            this.getModel().getRuntime().sendHalt("Number of laps rate values must be either 1 or 12!");
        }
    }

    public void run() {
        for (int i = 0; i < this.statOrder.getValue().length; ++i) {
            double lapseRate;
            int closestStation = this.statOrder.getValue()[i];
            double input = this.inputValues.getValue()[closestStation];
            if (input == JAMS.getMissingDataValue()) continue;
            if (this.lapseRates.length > 1) {
                int nowmonth = this.time.get(2);
                lapseRate = this.lapseRates[nowmonth].getValue();
            } else {
                lapseRate = this.lapseRates[0].getValue();
            }
            double elevationdiff = this.statElev.getValue()[closestStation] - this.entityElev.getValue();
            double result = elevationdiff * (lapseRate / 100.0) + input;
            result = Math.min(this.fixedMaximum.getValue(), result);
            result = Math.max(this.fixedMinimum.getValue(), result);
            this.outputValue.setValue(result);
            return;
        }
        this.getModel().getRuntime().sendHalt("No station with valid value found. Please check your inputs!");
    }
}

