/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.radiation;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import java.io.IOException;
import org.unijena.j2k.mathematicalCalculations.MathematicalCalculations;
import org.unijena.j2k.physicalCalculations.DailySolarRadiationCalculationMethods;
import org.unijena.j2k.physicalCalculations.SolarRadiationCalculationMethods;

@JAMSComponentDescription(title="CalcDailySolarRadiation", author="Peter Krause", description="Calculates solar radiation for daily or monthly timesteps", version="1.0_0", date="2011-05-30")
public class CalcDailySolarRadiation
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="time")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable sunshine hours", unit="h/d")
    public Attribute.Double sunh;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Maximum sunshine duration in h", unit="h/d", defaultValue="0")
    public Attribute.Double sunhmax;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable slope aspect correction factor")
    public Attribute.Double actSlAsCf;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="attribute latitude", unit="deg")
    public Attribute.Double latitude;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="daily extraterrestic radiation", unit="MJ / m\u00b2 d")
    public Attribute.Double actExtRad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="daily solar radiation", unit="MJ / m\u00b2 d")
    public Attribute.Double solRad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Angstrom factor a", lowerBound=0.0, upperBound=1.0, defaultValue="0.25")
    public Attribute.Double angstrom_a;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Angstrom factor b", lowerBound=0.0, upperBound=1.0, defaultValue="0.5")
    public Attribute.Double angstrom_b;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="temporal resolution [d | m]")
    public Attribute.String tempRes;
    int[] monthMean = new int[]{15, 45, 74, 105, 135, 166, 196, 227, 258, 288, 319, 349};
    double lastLati = Double.NEGATIVE_INFINITY;
    double lastJulDay = Double.NEGATIVE_INFINITY;
    double lastMaximumSunshine;

    public void run() throws Attribute.Entity.NoSuchAttributeException, IOException {
        int julDay = this.time.get(6);
        int month = this.time.get(2);
        double SAC = this.actSlAsCf.getValue();
        double lati = this.latitude.getValue();
        double sunsh = this.sunh.getValue();
        double extraterrRadiation = this.actExtRad.getValue();
        double declination = 0.0;
        double maximumSunshine = 0.0;
        if (lati == this.lastLati && this.lastJulDay == (double)julDay) {
            maximumSunshine = this.lastMaximumSunshine;
        } else {
            if (this.tempRes == null) {
                declination = SolarRadiationCalculationMethods.calc_SunDeclination(julDay);
            } else if (this.tempRes.getValue().equals("d")) {
                declination = SolarRadiationCalculationMethods.calc_SunDeclination(julDay);
            } else if (this.tempRes.getValue().equals("m")) {
                declination = SolarRadiationCalculationMethods.calc_SunDeclination(this.monthMean[month]);
            }
            double latRad = MathematicalCalculations.deg2rad(lati);
            double sunsetHourAngle = DailySolarRadiationCalculationMethods.calc_SunsetHourAngle(latRad, declination);
            maximumSunshine = DailySolarRadiationCalculationMethods.calc_maximumSunshineHours(sunsetHourAngle);
            this.lastLati = lati;
            this.lastJulDay = julDay;
            this.lastMaximumSunshine = maximumSunshine;
        }
        this.sunhmax.setValue(maximumSunshine);
        double solarRadiation = SolarRadiationCalculationMethods.calc_SolarRadiation(sunsh, maximumSunshine, extraterrRadiation, this.angstrom_a.getValue(), this.angstrom_b.getValue());
        this.solRad.setValue(solarRadiation *= SAC);
    }
}

