/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.radiation;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import java.io.IOException;
import org.unijena.j2k.physicalCalculations.ClimatologicalVariables;
import org.unijena.j2k.physicalCalculations.DailySolarRadiationCalculationMethods;
import org.unijena.j2k.physicalCalculations.SolarRadiationCalculationMethods;

@JAMSComponentDescription(title="CalcDailyNetRadiation", author="Peter Krause", description="Calculates daily net radiation", version="1.0_0", date="2011-05-30")
public class CalcDailyNetRadiation
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable mean temperature", unit="\u00b0C")
    public Attribute.Double tmean;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable relative humidity", unit="%")
    public Attribute.Double rhum;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable solar radiation", unit="MJ m^-2 d^-1")
    public Attribute.Double extRad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable solar radiation", unit="MJ m^-2 d^-1")
    public Attribute.Double solRad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable albedo")
    public Attribute.Double albedo;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="attribute elevation", unit="m")
    public Attribute.Double elevation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="daily net radiation", unit="MJ m^-2 d^-1")
    public Attribute.Double netRad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="daily shortwave radiation", unit="MJ m^-2 d^-1")
    public Attribute.Double swRad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="daily longwave radiation", unit="MJ m^-2 d^-1")
    public Attribute.Double lwRad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="daily net radiation for refET", defaultValue="0", unit="MJ m^-2 d^-1")
    public Attribute.Double refETNetRad;

    public void run() throws Attribute.Entity.NoSuchAttributeException, IOException {
        double elev = this.elevation.getValue();
        double temp = this.tmean.getValue();
        double rh = this.rhum.getValue();
        double sR = this.solRad.getValue();
        double alb = this.albedo.getValue();
        double extraTerrestialRad = this.extRad.getValue();
        double sat_vapour_pressure = ClimatologicalVariables.calc_saturationVapourPressure(temp);
        double act_vapour_pressure = ClimatologicalVariables.calc_vapourPressure(rh, sat_vapour_pressure);
        double clearSkyRad = SolarRadiationCalculationMethods.calc_ClearSkySolarRadiation(elev, extraTerrestialRad);
        double netSWRadiation = SolarRadiationCalculationMethods.calc_NetShortwaveRadiation(alb, sR);
        double netRefETSWRadiation = SolarRadiationCalculationMethods.calc_NetShortwaveRadiation(0.23, sR);
        double netLWRadiation = DailySolarRadiationCalculationMethods.calc_DailyNetLongwaveRadiation(temp, act_vapour_pressure, sR, clearSkyRad, false);
        double nR_norm = SolarRadiationCalculationMethods.calc_NetRadiation(netSWRadiation, netLWRadiation);
        double nR_refET = SolarRadiationCalculationMethods.calc_NetRadiation(netRefETSWRadiation, netLWRadiation);
        this.netRad.setValue(nR_norm);
        this.refETNetRad.setValue(nR_refET);
        this.swRad.setValue(netSWRadiation);
        this.lwRad.setValue(netLWRadiation);
    }
}

