/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.io;

import jams.JAMS;
import jams.data.Attribute;
import jams.io.GenericDataReader;
import jams.io.JAMSTableDataArray;
import jams.io.JAMSTableDataConverter;
import jams.io.JAMSTableDataStore;
import jams.model.JAMSComponent;
import jams.model.JAMSVarDescription;
import jams.tools.JAMSTools;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import org.unijena.j2k.statistics.Regression;

public class TSDataReader
extends JAMSComponent {
    public static final String SEPARATOR = "\t";
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Data file name")
    public Attribute.String dataFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Column of first data value")
    public Attribute.Integer startColumn;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Time interval of current temporal context")
    public Attribute.TimeInterval timeInterval;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Array of data values for current time step")
    public Attribute.DoubleArray dataArray;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="data set descriptor")
    public Attribute.String dataSetName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Array of station elevations")
    public Attribute.DoubleArray elevation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Array of station's x coordinate")
    public Attribute.DoubleArray xCoord;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Array of station's y coordinate")
    public Attribute.DoubleArray yCoord;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Regression coefficients")
    public Attribute.DoubleArray regCoeff;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Calculate regression coefficients? If not, regCoeff array stays empty!")
    public Attribute.Boolean skipRegression;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Array of numerical station ids", defaultValue="")
    public Attribute.DoubleArray statId;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="names of the stations", defaultValue="")
    public Attribute.StringArray statNames;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="temporal resolution", defaultValue="")
    public Attribute.String tempRes;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="missing data value")
    public Attribute.Double missDataValue;
    private JAMSTableDataStore store;
    private JAMSTableDataArray da;

    public void init() {
        this.getModel().getRuntime().println(" start init " + this.dataFileName.getValue() + ".. ", 2);
        int headerLineCount = 0;
        String dataName = null;
        String tres = null;
        String start = null;
        String end = null;
        double missData = 0.0;
        String[] name = null;
        double[] id = null;
        double[] statx = null;
        double[] staty = null;
        double[] statelev = null;
        String line = "#";
        try {
            BufferedReader reader = new BufferedReader(new FileReader(JAMSTools.CreateAbsoluteFileName((String)this.getModel().getWorkspaceDirectory().getPath(), (String)this.dataFileName.getValue())));
            while (line.charAt(0) == '#') {
                line = reader.readLine();
                ++headerLineCount;
            }
            StringTokenizer strTok = new StringTokenizer(line, SEPARATOR);
            String token = strTok.nextToken();
            while (!token.equalsIgnoreCase("@dataVal")) {
                String desc;
                int i;
                if (token.equalsIgnoreCase("@dataValueAttribs")) {
                    line = reader.readLine();
                    ++headerLineCount;
                    strTok = new StringTokenizer(line, SEPARATOR);
                    dataName = strTok.nextToken();
                    double lowBound = Double.parseDouble(strTok.nextToken());
                    double uppBound = Double.parseDouble(strTok.nextToken());
                    line = reader.readLine();
                    strTok = new StringTokenizer(line, SEPARATOR);
                    token = strTok.nextToken();
                    ++headerLineCount;
                    continue;
                }
                if (token.equalsIgnoreCase("@dataSetAttribs")) {
                    line = reader.readLine();
                    for (i = 0; i < 4; ++i) {
                        ++headerLineCount;
                        strTok = new StringTokenizer(line, "\t ");
                        desc = strTok.nextToken();
                        if (desc.equalsIgnoreCase("missingDataVal")) {
                            missData = Double.parseDouble(strTok.nextToken());
                        } else if (desc.equalsIgnoreCase("dataStart")) {
                            start = strTok.nextToken();
                            if (strTok.hasMoreTokens()) {
                                start = start + " " + strTok.nextToken();
                            }
                        } else if (desc.equalsIgnoreCase("dataEnd")) {
                            end = strTok.nextToken();
                            if (strTok.hasMoreTokens()) {
                                end = end + " " + strTok.nextToken();
                            }
                        } else if (desc.equalsIgnoreCase("tres")) {
                            tres = strTok.nextToken();
                        }
                        line = reader.readLine();
                        strTok = new StringTokenizer(line, SEPARATOR);
                        token = strTok.nextToken();
                    }
                    continue;
                }
                if (!token.equalsIgnoreCase("@statAttribVal")) continue;
                line = reader.readLine();
                for (i = 0; i < 6; ++i) {
                    int j;
                    ++headerLineCount;
                    strTok = new StringTokenizer(line, SEPARATOR);
                    desc = strTok.nextToken();
                    int nstat = strTok.countTokens();
                    if (desc.equalsIgnoreCase("name")) {
                        name = new String[nstat];
                        for (j = 0; j < nstat; ++j) {
                            name[j] = strTok.nextToken();
                        }
                    } else if (desc.equalsIgnoreCase("id")) {
                        id = new double[nstat];
                        for (j = 0; j < nstat; ++j) {
                            id[j] = Double.parseDouble(strTok.nextToken());
                        }
                    } else if (desc.equalsIgnoreCase("elevation")) {
                        statelev = new double[nstat];
                        for (j = 0; j < nstat; ++j) {
                            statelev[j] = Double.parseDouble(strTok.nextToken());
                        }
                    } else if (desc.equalsIgnoreCase("x")) {
                        statx = new double[nstat];
                        for (j = 0; j < nstat; ++j) {
                            statx[j] = Double.parseDouble(strTok.nextToken());
                        }
                    } else if (desc.equalsIgnoreCase("y")) {
                        staty = new double[nstat];
                        for (j = 0; j < nstat; ++j) {
                            staty[j] = Double.parseDouble(strTok.nextToken());
                        }
                    } else if (desc.equalsIgnoreCase("datacolumn")) {
                        ++headerLineCount;
                        ++headerLineCount;
                    }
                    line = reader.readLine();
                    strTok = new StringTokenizer(line, SEPARATOR);
                    token = strTok.nextToken();
                }
            }
        }
        catch (IOException ioe) {
            this.getModel().getRuntime().handle((Throwable)ioe);
        }
        this.store = new GenericDataReader(JAMSTools.CreateAbsoluteFileName((String)this.getModel().getWorkspaceDirectory().getPath(), (String)this.dataFileName.getValue()), false, headerLineCount + 1);
        Attribute.Calendar startTime = this.parseJ2KTime(start);
        Attribute.Calendar endTime = this.parseJ2KTime(end);
        if (this.timeInterval != null && (this.timeInterval.getStart().before(startTime) || this.timeInterval.getEnd().after(endTime))) {
            this.getModel().getRuntime().sendHalt("TSData start and end time of " + this.dataFileName.getValue() + " do not match current temporal context!\n(" + this.timeInterval.getStart() + "<->" + this.timeInterval.getEnd() + " vs. " + startTime + "<->" + endTime + ")");
        }
        this.dataSetName.setValue(dataName);
        this.elevation.setValue(statelev);
        this.xCoord.setValue(statx);
        this.yCoord.setValue(staty);
        this.statId.setValue(id);
        this.statNames.setValue(name);
        this.tempRes.setValue(tres);
        this.missDataValue.setValue(missData);
        if (this.timeInterval != null) {
            int timeUnit = this.timeInterval.getTimeUnit();
            Attribute.Calendar tiStart = this.timeInterval.getStart();
            Attribute.Calendar date = this.getModel().getRuntime().getDataFactory().createCalendar();
            if (timeUnit == 6) {
                date.set(tiStart.get(1), tiStart.get(2), tiStart.get(5), 0, 0, 0);
            } else if (timeUnit == 11) {
                date.set(tiStart.get(1), tiStart.get(2), tiStart.get(5), tiStart.get(11), tiStart.get(12), 0);
            } else if (timeUnit == 2) {
                date.set(tiStart.get(1), tiStart.get(2), 1, 0, 0, 0);
            }
            while (startTime.before(date) && this.store.hasNext()) {
                this.da = this.store.getNext();
                if (timeUnit == 6) {
                    startTime.add(5, 1);
                    continue;
                }
                if (timeUnit == 11) {
                    startTime.add(11, 1);
                    continue;
                }
                if (timeUnit != 2) continue;
                startTime.add(2, 1);
            }
        }
        this.getModel().getRuntime().println(this.dataSetName.getValue() + " data file initalised ... ", 2);
    }

    public void run() {
        double[] value = JAMSTableDataConverter.toDouble((JAMSTableDataArray)this.store.getNext(), (int)this.startColumn.getValue());
        for (int i = 0; i < value.length; ++i) {
            if (value[i] != this.missDataValue.getValue()) continue;
            value[i] = JAMS.getMissingDataValue();
        }
        this.dataArray.setValue(value);
        if (!this.skipRegression.getValue()) {
            this.regCoeff.setValue(Regression.calcLinReg(this.elevation.getValue(), this.dataArray.getValue()));
        }
    }

    private Attribute.Calendar parseJ2KTime(String timeString) {
        String[] timeArray = new String[]{"1", "1", "0", "0", "0"};
        StringTokenizer st = new StringTokenizer(timeString, ".-/ :");
        int n = st.countTokens();
        for (int i = 0; i < n; ++i) {
            timeArray[i] = st.nextToken();
        }
        Attribute.Calendar cal = this.getModel().getRuntime().getDataFactory().createCalendar();
        cal.setValue(timeArray[2] + "-" + timeArray[1] + "-" + timeArray[0] + " " + timeArray[3] + ":" + timeArray[4]);
        return cal;
    }

    public void cleanup() {
        this.store.close();
    }
}

