/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.io;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;
import jams.tools.FileTools;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.unijena.j2k.J2KFunctions;

@JAMSComponentDescription(title="StandardEntityReader", author="Sven Kralisch & Christian Fischer", description="This component reads two ASCII files containing data of hru and reach entities and creates two collections of entities accordingly. 1:n topologies between different entities are created based on provided attribute names. Additionally, the topologies are checked for cycles.", date="2010-01-29", version="1.3")
@VersionComments(entries={@VersionComments.Entry(version="1.2", comment="Added function to use only a subset of all entities. This is defined by a reach ID (subcatchmentReachID) which represents the outlet of the catchment."), @VersionComments.Entry(version="1.3", comment="Added checks for validity of hru/reach parameter files.")})
public class StandardEntityReader
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="HRU parameter file name")
    public Attribute.String hruFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Reach parameter file name")
    public Attribute.String reachFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Collection of hru objects")
    public Attribute.EntityCollection hrus;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Collection of reach objects")
    public Attribute.EntityCollection reaches;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of the attribute containing the HRU identifiers", defaultValue="ID")
    public Attribute.String hruIDAttribute;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of the attribute containing the reach identifiers", defaultValue="ID")
    public Attribute.String reachIDAttribute;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of the attribute describing the HRU to HRU relation in the input file", defaultValue="to_poly")
    public Attribute.String hru2hruAttribute;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of the attribute describing the HRU to reach relation in the input file", defaultValue="to_reach")
    public Attribute.String hru2reachAttribute;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of the attribute describing the reach to reach relation in the input file", defaultValue="to_reach")
    public Attribute.String reach2reachAttribute;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="ID of a reach defining a sub-catchment. Only hrus/reaches draining to this reach will be used on the resulting entity collections", defaultValue="-1")
    public Attribute.Double subcatchmentReachID;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="If false, topoology information is not considered", defaultValue="true")
    public Attribute.Boolean doTopo;
    ArrayList<Attribute.Entity> hruList;
    ArrayList<Attribute.Entity> reachList;
    HashMap<Double, Attribute.Entity> hruMap;
    HashMap<Double, Attribute.Entity> reachMap;
    Attribute.Entity nullEntity;
    Attribute.Entity defaultRootReach;
    HashMap<Attribute.Entity, List<Attribute.Entity>> children;

    public void init() {
        this.defaultRootReach = null;
        this.getModel().getRuntime().println("Reading spatial model entities...", 2);
        String fileName = this.hruFileName.getValue();
        if (new File(fileName).exists()) {
            fileName = this.hruFileName.getValue();
        } else if (this.getModel().getWorkspaceDirectory() != null) {
            fileName = FileTools.createAbsoluteFileName((String)this.getModel().getWorkspaceDirectory().getPath(), (String)this.hruFileName.getValue());
        }
        if (!new File(fileName).exists()) {
            this.getModel().getRuntime().sendErrorMsg("Couldn't load HRU file name " + fileName + "!\nIf you are not using an absolute path, please ensure you have defined a workspace directory!");
        }
        this.hruList = J2KFunctions.readParas(fileName, this.getModel());
        for (Attribute.Entity e : this.hruList) {
            try {
                e.setId((long)e.getDouble(this.hruIDAttribute.getValue()));
            }
            catch (Attribute.Entity.NoSuchAttributeException nsae) {
                this.getModel().getRuntime().sendErrorMsg("Couldn't find attribute \"ID\" while reading J2K HRU parameter file (" + this.hruFileName.getValue() + ")!");
            }
        }
        fileName = this.reachFileName.getValue();
        if (new File(fileName).exists()) {
            fileName = this.reachFileName.getValue();
        } else if (this.getModel().getWorkspaceDirectory() != null) {
            fileName = FileTools.createAbsoluteFileName((String)this.getModel().getWorkspaceDirectory().getPath(), (String)this.reachFileName.getValue());
        }
        if (!new File(fileName).exists()) {
            this.getModel().getRuntime().sendErrorMsg("Couldn't load reach file name " + fileName + "!\nIf you are not using an absolute path, please ensure you have defined a workspace directory!");
        }
        this.reachList = J2KFunctions.readParas(fileName, this.getModel());
        for (Attribute.Entity e : this.reachList) {
            try {
                e.setId((long)e.getDouble(this.reachIDAttribute.getValue()));
            }
            catch (Attribute.Entity.NoSuchAttributeException nsae) {
                this.getModel().getRuntime().sendErrorMsg("Couldn't find attribute \"ID\" while reading J2K reach parameter file (" + this.reachFileName.getValue() + ")!");
            }
        }
        this.createEntityMaps();
        if (this.doTopo.getValue()) {
            this.createTopology();
            this.createChildrenMap();
        }
        this.getModel().getRuntime().println("Model entities read successfully. This resulted in " + this.hruList.size() + " HRUs / " + this.reachList.size() + " reaches overall.", 1);
        this.createEntityCollections();
        this.getModel().getRuntime().println("Model entities ordered and subsetted successfully. This resulted in " + this.hrus.getEntities().size() + " HRUs / " + this.reaches.getEntities().size() + " reaches.", 1);
    }

    protected boolean cycleCheck(Attribute.Entity node, Stack<Attribute.Entity> searchStack, HashSet<Long> closedList, HashSet<Long> visitedList) {
        if (searchStack.contains(node)) {
            int index = searchStack.indexOf(node);
            String cyc_output = new String();
            for (int i = index; i < searchStack.size(); ++i) {
                cyc_output = cyc_output + ((Attribute.Entity)searchStack.get(i)).getId() + " ";
            }
            this.getModel().getRuntime().println("Found circle with ids:" + cyc_output);
            return true;
        }
        if (closedList.contains(node.getId())) {
            return false;
        }
        visitedList.add(node.getId());
        Attribute.Entity child_node = (Attribute.Entity)node.getObject(this.hru2hruAttribute.getValue());
        if (child_node != null && child_node.isEmpty()) {
            child_node = null;
        }
        if (child_node != null) {
            searchStack.push(node);
            boolean result = this.cycleCheck(child_node, searchStack, closedList, visitedList);
            searchStack.pop();
            return result;
        }
        return false;
    }

    protected boolean cycleCheck() {
        HashSet<Long> closedList = new HashSet<Long>();
        HashSet<Long> visitedList = new HashSet<Long>();
        this.getModel().getRuntime().println("Cycle checking...");
        Iterator<Attribute.Entity> hruIterator = this.hruList.iterator();
        boolean result = false;
        while (hruIterator.hasNext()) {
            Attribute.Entity start_node = hruIterator.next();
            if (closedList.contains(start_node.getId())) continue;
            if (this.cycleCheck(start_node, new Stack<Attribute.Entity>(), closedList, visitedList)) {
                result = true;
            }
            closedList.addAll(visitedList);
            visitedList.clear();
        }
        return result;
    }

    private void createChildrenMap() {
        List<Attribute.Entity> l;
        Attribute.Entity parentNode;
        this.children = new HashMap();
        for (Attribute.Entity node : this.hruList) {
            parentNode = (Attribute.Entity)node.getObject(this.hru2hruAttribute.getValue());
            if (parentNode != this.nullEntity) {
                l = this.children.get(parentNode);
                if (l == null) {
                    l = new ArrayList<Attribute.Entity>();
                    this.children.put(parentNode, l);
                }
                l.add(node);
            }
            if ((parentNode = (Attribute.Entity)node.getObject(this.hru2reachAttribute.getValue())) == this.nullEntity) continue;
            l = this.children.get(parentNode);
            if (l == null) {
                l = new ArrayList<Attribute.Entity>();
                this.children.put(parentNode, l);
            }
            l.add(node);
        }
        for (Attribute.Entity node : this.reachList) {
            parentNode = (Attribute.Entity)node.getObject(this.reach2reachAttribute.getValue());
            if (parentNode == this.nullEntity) continue;
            l = this.children.get(parentNode);
            if (l == null) {
                l = new ArrayList<Attribute.Entity>();
                this.children.put(parentNode, l);
            }
            l.add(node);
        }
    }

    private void createEntityCollections() {
        Attribute.Entity root;
        if (this.subcatchmentReachID.getValue() != -1.0) {
            root = this.reachMap.get(this.subcatchmentReachID.getValue());
            if (root != null) {
                root.setObject(this.reach2reachAttribute.getValue(), (Object)this.nullEntity);
            } else {
                root = this.defaultRootReach;
                this.getModel().getRuntime().println("Subbasin with id " + this.subcatchmentReachID.getValue() + " does not exist! Using default outlet.");
            }
        } else {
            root = this.defaultRootReach;
        }
        List catchmentList = this.getSubtreeList(root, this.children);
        ArrayList<Attribute.Entity> hl = new ArrayList<Attribute.Entity>();
        ArrayList<Attribute.Entity> rl = new ArrayList<Attribute.Entity>();
        HashSet<Attribute.Entity> reachSet = new HashSet<Attribute.Entity>();
        for (Attribute.Entity e : this.reachMap.values()) {
            reachSet.add(e);
        }
        for (int i = catchmentList.size() - 1; i >= 0; --i) {
            Attribute.Entity e;
            e = (Attribute.Entity)catchmentList.get(i);
            if (reachSet.contains(e)) {
                rl.add(e);
                continue;
            }
            hl.add(e);
        }
        this.hrus.setEntities(hl);
        this.reaches.setEntities(rl);
    }

    private List getSubtreeList(Attribute.Entity node, HashMap<Attribute.Entity, List<Attribute.Entity>> children) {
        ArrayList<Attribute.Entity> treeList = new ArrayList<Attribute.Entity>();
        treeList.add(node);
        List<Attribute.Entity> l = children.get(node);
        if (l != null) {
            for (Attribute.Entity e : l) {
                treeList.addAll(this.getSubtreeList(e, children));
            }
        }
        return treeList;
    }

    private void createEntityMaps() {
        this.hruMap = new HashMap();
        this.reachMap = new HashMap();
        for (Attribute.Entity e : this.hruList) {
            double id = e.getId();
            if (!this.hruMap.containsKey(id)) {
                this.hruMap.put(id, e);
                continue;
            }
            this.getModel().getRuntime().sendErrorMsg("Found duplicate HRU-ID (" + e.getId() + "). This may cause errors!");
        }
        for (Attribute.Entity e : this.reachList) {
            double id = e.getId();
            if (!this.reachMap.containsKey(id)) {
                this.reachMap.put(id, e);
                continue;
            }
            this.getModel().getRuntime().sendErrorMsg("Found duplicate reach-ID (" + e.getId() + "). This may cause errors!");
        }
        this.nullEntity = this.getModel().getRuntime().getDataFactory().createEntity();
        this.hruMap.put(0.0, this.nullEntity);
        this.reachMap.put(0.0, this.nullEntity);
    }

    protected void createTopology() {
        Attribute.Entity toReach;
        for (Attribute.Entity e : this.hruList) {
            Attribute.Entity toPoly = this.hruMap.get(e.getDouble(this.hru2hruAttribute.getValue()));
            toReach = this.reachMap.get(e.getDouble(this.hru2reachAttribute.getValue()));
            if (toPoly == null || toReach == null) {
                this.getModel().getRuntime().sendErrorMsg("Topological neighbour for HRU with ID " + e.getId() + " could not be found. This may cause errors!");
            } else if (toPoly == this.nullEntity && toReach == this.nullEntity) {
                this.getModel().getRuntime().sendInfoMsg("The HRU with ID " + e.getId() + " drains nowhere. This may cause errors!");
            }
            e.setObject(this.hru2hruAttribute.getValue(), (Object)toPoly);
            e.setObject(this.hru2reachAttribute.getValue(), (Object)toReach);
        }
        for (Attribute.Entity e : this.reachList) {
            toReach = this.reachMap.get(e.getDouble(this.reach2reachAttribute.getValue()));
            if (toReach == null) {
                this.getModel().getRuntime().sendErrorMsg("Topological neighbour for reach with ID " + e.getId() + " could not be found. This may cause errors!");
            } else if (toReach == this.nullEntity) {
                if (this.defaultRootReach != null) {
                    this.getModel().getRuntime().sendInfoMsg("The river network has more than one outlet! This may cause errors! ID of first outlet is: " + this.defaultRootReach.getId() + " and the second outlet is: " + toReach.getId());
                }
                this.defaultRootReach = e;
            }
            e.setObject(this.reach2reachAttribute.getValue(), (Object)toReach);
        }
        if (this.getModel().getRuntime().getDebugLevel() >= 3) {
            if (this.cycleCheck()) {
                this.getModel().getRuntime().sendHalt("HRUs --> cycle found ... :( ");
            } else {
                this.getModel().getRuntime().println("HRUs --> no cycle found");
            }
        }
    }

    protected void createOrderedList(Attribute.EntityCollection col, String asso) {
        int i;
        ArrayList<Attribute.Entity> newList = new ArrayList<Attribute.Entity>();
        HashMap<Attribute.Entity, Integer> depthMap = new HashMap<Attribute.Entity, Integer>();
        boolean mapChanged = true;
        Iterator hruIterator = col.getEntities().iterator();
        while (hruIterator.hasNext()) {
            depthMap.put((Attribute.Entity)hruIterator.next(), 0);
        }
        int maxDepth = 0;
        while (mapChanged) {
            mapChanged = false;
            for (Attribute.Entity e : col.getEntities()) {
                Attribute.Entity f = (Attribute.Entity)e.getObject(asso);
                if (f == null) {
                    this.getModel().getRuntime().println("warning hru with id:" + e.getId() + " has no receiver");
                }
                if (f != null && f.isEmpty()) {
                    f = null;
                }
                if (f == null) continue;
                Integer eDepth = (Integer)depthMap.get(e);
                Integer fDepth = (Integer)depthMap.get(f);
                if (fDepth > eDepth) continue;
                depthMap.put(f, eDepth + 1);
                mapChanged = true;
            }
        }
        maxDepth = 0;
        for (Attribute.Entity e : col.getEntities()) {
            maxDepth = Math.max(maxDepth, (Integer)depthMap.get(e));
        }
        ArrayList alList = new ArrayList();
        for (i = 0; i <= maxDepth; ++i) {
            alList.add(new ArrayList());
        }
        for (Attribute.Entity e : col.getEntities()) {
            int depth = (Integer)depthMap.get(e);
            ((ArrayList)alList.get(depth)).add(e);
        }
        for (i = 0; i <= maxDepth; ++i) {
            for (Attribute.Entity e : (ArrayList)alList.get(i)) {
                newList.add(e);
            }
        }
        col.setEntities(newList);
    }
}

