/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;

@JAMSComponentDescription(title="ArrayToScalar", author="Sven Kralisch", description="Extracts single scalar doubles from an array of double values", date="2013-09-13", version="1.0_1")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version"), @VersionComments.Entry(version="1.0_1", comment="Extended to handle multiple values")})
public class FindInList
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="array of values to extract from")
    public Attribute.DoubleArray dataArray;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="optional correction factor", defaultValue="1")
    public Attribute.Double value;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="extracted value")
    public Attribute.Boolean isInList;

    public void run() {
        this.isInList.setValue(false);
        for (int i = 0; i < this.dataArray.getValue().length; ++i) {
            if (!(Math.abs(this.dataArray.getValue()[i] - this.value.getValue()) < 1.0E-10)) continue;
            this.isInList.setValue(true);
            break;
        }
    }
}

