/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.opencl;

import java.util.ArrayList;
import java.util.List;
import org.encog.engine.EncogEngineError;
import org.encog.engine.opencl.EncogCLDevice;
import org.encog.engine.opencl.EncogCLPlatform;
import org.encog.engine.opencl.exceptions.MissingOpenCLAdapterError;
import org.jocl.CL;
import org.jocl.cl_platform_id;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncogCL {
    private final List<EncogCLPlatform> platforms = new ArrayList<EncogCLPlatform>();
    private final List<EncogCLDevice> devices = new ArrayList<EncogCLDevice>();

    public EncogCL() {
        try {
            int[] nArray = new int[1];
            cl_platform_id[] cl_platform_idArray = new cl_platform_id[5];
            CL.clGetPlatformIDs((int)cl_platform_idArray.length, (cl_platform_id[])cl_platform_idArray, (int[])nArray);
            if (nArray[0] == 0) {
                throw new EncogEngineError("Can't find any OpenCL platforms");
            }
            for (int i = 0; i < nArray[0]; ++i) {
                cl_platform_id cl_platform_id2 = cl_platform_idArray[i];
                EncogCLPlatform encogCLPlatform = new EncogCLPlatform(cl_platform_id2);
                this.platforms.add(encogCLPlatform);
                for (EncogCLDevice encogCLDevice : encogCLPlatform.getDevices()) {
                    this.devices.add(encogCLDevice);
                }
            }
            CL.setExceptionsEnabled((boolean)true);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new MissingOpenCLAdapterError(unsatisfiedLinkError);
        }
    }

    public boolean areCPUsPresent() {
        for (EncogCLDevice encogCLDevice : this.devices) {
            if (!encogCLDevice.isCPU()) continue;
            return true;
        }
        return false;
    }

    public EncogCLDevice chooseDevice() {
        EncogCLDevice encogCLDevice = this.chooseDevice(true);
        if (encogCLDevice == null) {
            encogCLDevice = this.chooseDevice(false);
        }
        return encogCLDevice;
    }

    public EncogCLDevice chooseDevice(boolean bl) {
        for (EncogCLDevice encogCLDevice : this.devices) {
            if (bl && !encogCLDevice.isCPU()) {
                return encogCLDevice;
            }
            if (bl || !encogCLDevice.isCPU()) continue;
            return encogCLDevice;
        }
        return null;
    }

    public void disableAllCPUs() {
        for (EncogCLDevice encogCLDevice : this.devices) {
            if (!encogCLDevice.isCPU()) continue;
            encogCLDevice.setEnabled(false);
        }
    }

    public void enableAllCPUs() {
        for (EncogCLDevice encogCLDevice : this.devices) {
            if (!encogCLDevice.isCPU()) continue;
            encogCLDevice.setEnabled(true);
        }
    }

    public List<EncogCLDevice> getDevices() {
        return this.devices;
    }

    public List<EncogCLDevice> getEnabledDevices() {
        ArrayList<EncogCLDevice> arrayList = new ArrayList<EncogCLDevice>();
        for (EncogCLDevice encogCLDevice : this.devices) {
            if (!encogCLDevice.isEnabled() || !encogCLDevice.getPlatform().isEnabled()) continue;
            arrayList.add(encogCLDevice);
        }
        return arrayList;
    }

    public List<EncogCLPlatform> getPlatforms() {
        return this.platforms;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (EncogCLDevice encogCLDevice : this.devices) {
            stringBuilder.append(encogCLDevice.toString());
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }
}

