/*
 * Decompiled with CFR 0.152.
 */
package jams.math.distributions;

public class Derf {
    public static double derf(double x) {
        double[] erfcs = new double[]{0.0, -0.049046121234691806, -0.14226120510371365, 0.010035582187599796, -5.768764699767485E-4, 2.741993125219606E-5, -1.1043175507344507E-6, 3.8488755420345036E-8, -1.1808582533875466E-9, 3.2334215826050907E-11, -7.991015947004549E-13, 1.7990725113961456E-14, -3.718635487818693E-16, 7.103599003714253E-18, -1.2612455119155226E-19, 2.0916406941769294E-21, -3.2539731029314073E-23, 4.766867209797675E-25, -6.598012078285134E-27, 8.655011469963763E-29, -1.0788925177498064E-30, 1.2811883993017003E-32};
        double sqrtpi = 1.772453850905516;
        double d1mach3 = 1.11E-16;
        double eta0 = 1.11E-17;
        int nterf = Derf.initds(erfcs, 21, 1.11E-17);
        double xbig = Math.sqrt(-Math.log(1.967423774505123E-16));
        double sqeps = Math.sqrt(2.22E-16);
        double y = Math.abs(x);
        if (y <= 1.0) {
            double ans = y <= sqeps ? 2.0 * x * x / 1.772453850905516 : x * (1.0 + Derf.dcsevl(2.0 * x * x - 1.0, erfcs, nterf));
            return ans;
        }
        double ans = y <= xbig ? Derf.sign(1.0 - Derf.derfc(y), x) : Derf.sign(1.0, x);
        return ans;
    }

    public static double derfc(double x) {
        double[] erfcs = new double[]{0.0, -0.049046121234691806, -0.14226120510371365, 0.010035582187599796, -5.768764699767485E-4, 2.741993125219606E-5, -1.1043175507344507E-6, 3.8488755420345036E-8, -1.1808582533875466E-9, 3.2334215826050907E-11, -7.991015947004549E-13, 1.7990725113961456E-14, -3.718635487818693E-16, 7.103599003714253E-18, -1.2612455119155226E-19, 2.0916406941769294E-21, -3.2539731029314073E-23, 4.766867209797675E-25, -6.598012078285134E-27, 8.655011469963763E-29, -1.0788925177498064E-30, 1.2811883993017003E-32};
        double[] erc2cs = new double[]{0.0, -0.0696013466023095, -0.04110133936262089, 0.003914495866689627, -4.906395650548979E-4, 7.157479001377036E-5, -1.1530716341312328E-5, 1.9946705902019974E-6, -3.642666471599223E-7, 6.944372610005012E-8, -1.371220902104366E-8, 2.7883896610071373E-9, -5.814164724331161E-10, 1.2389204917527532E-10, -2.6906391453067435E-11, 5.942614350847911E-12, -1.3323867357581197E-12, 3.0280468061771323E-13, -6.966648814941033E-14, 1.620854541053923E-14, -3.809934465250492E-15, 9.040487815978831E-16, -2.1640061950896072E-16, 5.222102233995855E-17, -1.2697296023645554E-17, 3.1091455042761977E-18, -7.663762920320386E-19, 1.9008192513627452E-19, -4.7422072790690393E-20, 1.1896492000765284E-20, -3.0000355903257804E-21, 7.602993453043246E-22, -1.9359094476068728E-22, 4.951399124773338E-23, -1.2718074813363719E-23, 3.2800496004695132E-24, -8.492320176822897E-25, 2.2069178928075603E-25, -5.755617245696529E-26, 1.5061915336392342E-26, -3.954502959018797E-27, 1.0415297041515009E-27, -2.751487795278765E-28, 7.290058205497557E-29, -1.936939645915948E-29, 5.1603571120514875E-30, -1.3784193221930942E-30, 3.691326793107069E-31, -9.909389590624365E-32, 2.666491705195388E-32};
        double[] erfccs = new double[]{0.0, 0.07151793102029248, -0.026532434337606717, 0.0017111539779208558, -1.6375166345851787E-4, 1.9871293500552038E-5, -2.843712412766555E-6, 4.6061613089631305E-7, -8.227753025879209E-8, 1.5921418727709012E-8, -3.295071362252843E-9, 7.223439760400556E-10, -1.6648558133987297E-10, 4.010392588237665E-11, -1.004816214425731E-11, 2.608275913300334E-12, -6.991110560404025E-13, 1.9294923332617072E-13, -5.470131188754331E-14, 1.5896633097626975E-14, -4.726893980197555E-15, 1.4358733767849847E-15, -4.449510561817358E-16, 1.4048108847682335E-16, -4.5138183877642106E-17, 1.474521541045133E-17, -4.8926214069457765E-18, 1.6476121414106467E-18, -5.626817176329408E-19, 1.9474433822320786E-19, -6.82630564294842E-20, 2.4219888872986492E-20, -8.693414133503071E-21, 3.1551803462280855E-21, -1.1573723240496087E-21, 4.288947161605654E-22, -1.6050307420576167E-22, 6.063298757453803E-23, -2.3114042516979585E-23, 8.888778540661885E-24, -3.447260576651376E-24, 1.347865460206965E-24, -5.311794071125021E-25, 2.109341058619783E-25, -8.438365587923789E-26, 3.399982524945209E-26, -1.3794523880732422E-26, 5.6344903118332525E-27, -2.3164904344770655E-27, 9.58446284460181E-28, -3.9907228803301096E-28, 1.6721292259444773E-28, -7.045991522766014E-29, 2.9797684028642063E-29, -1.2625224664606192E-29, 5.395438704542488E-30, -2.380992882531459E-30, 1.0990528301027615E-30, -4.867713741644966E-31, 1.5258772641103575E-31};
        double sqrtpi = 1.772453850905516;
        double d1mach3 = 1.11E-16;
        double eta0 = 1.11E-17;
        int nterf = Derf.initds(erfcs, 21, 1.11E-17);
        int nterfc = Derf.initds(erfccs, 59, 1.11E-17);
        int nterc2 = Derf.initds(erc2cs, 49, 1.11E-17);
        double sqeps = Math.sqrt(2.22E-16);
        double xsml = -Math.sqrt(-Math.log(1.967423774505123E-16));
        double txmax = Math.sqrt(-(Math.log(1.772453850905516) - 1022.0));
        double xmax = txmax - 0.5 * Math.log(txmax) / txmax - 0.01;
        if (x <= xsml) {
            double ans = 2.0;
            return ans;
        }
        if (x > xmax) {
            System.out.print("\n\nx is so big that derfc underflows\n\n");
            double ans = 0.0;
            return ans;
        }
        double y = Math.abs(x);
        if (y <= 1.0) {
            double ans = y < sqeps ? 1.0 - 2.0 * x / 1.772453850905516 : 1.0 - x * (1.0 + Derf.dcsevl(2.0 * x * x - 1.0, erfcs, nterf));
            return ans;
        }
        double ans = (y *= y) <= 4.0 ? Math.exp(-y) / Math.abs(x) * (0.5 + Derf.dcsevl((8.0 / y - 5.0) / 3.0, erc2cs, nterc2)) : Math.exp(-y) / Math.abs(x) * (0.5 + Derf.dcsevl(8.0 / y - 1.0, erfccs, nterfc));
        if (x < 0.0) {
            ans = 2.0 - ans;
        }
        return ans;
    }

    public static double dcsevl(double x, double[] cs, int n) {
        double d1mach4 = 2.22E-16;
        double onepl = 1.0000000000000002;
        if (n < 1) {
            System.out.print("\n\nERROR: The number of terms for dcsevl was less than 1.\n\n");
            System.exit(0);
        }
        if (n > 1000) {
            System.out.print("\n\nERROR: The number of terms for dcsevl was greater than 1000.\n\n");
            System.exit(0);
        }
        if (Math.abs(x) > onepl) {
            System.out.print("\n\nERROR: The x for dcsevl was outside the interval (-1,1).\n\n");
            System.exit(0);
        }
        double b2 = 0.0;
        double b1 = 0.0;
        double b0 = 0.0;
        double twox = 2.0 * x;
        for (int i = 1; i <= n; ++i) {
            b2 = b1;
            b1 = b0;
            int ni = n + 1 - i;
            b0 = twox * b1 - b2 + cs[ni];
        }
        double ans = 0.5 * (b0 - b2);
        return ans;
    }

    public static int initds(double[] os, int nos, double eta) {
        if (nos < 1) {
            System.out.print("\n\nERROR: The number of coefficients for initds was less than 1.\n\n");
            System.exit(0);
        }
        int i = nos;
        double err = 0.0;
        for (int ii = 1; ii <= nos && !((err += Math.abs(os[i = nos + 1 - ii])) > eta); ++ii) {
        }
        if (i == nos) {
            System.out.print("\n\nThe Chebyshev series is too short for the specified accuracy.\n\n");
        }
        return i;
    }

    public static double sign(double a, double b) {
        if (b < 0.0) {
            return -Math.abs(a);
        }
        return Math.abs(a);
    }
}

