/*
 * Decompiled with CFR 0.152.
 */
package jams.io.dbf;

import jams.io.dbf.DBFBase;
import jams.io.dbf.DBFException;
import jams.io.dbf.DBFField;
import jams.io.dbf.DBFHeader;
import jams.io.dbf.DBFReader;
import jams.io.dbf.Utils;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;

public class DBFWriter
extends DBFBase {
    DBFHeader header;
    Vector v_records = new Vector();
    int recordCount = 0;
    RandomAccessFile raf = null;
    boolean appendMode = false;
    Buffer buffer = new Buffer();

    public DBFWriter() {
        this.header = new DBFHeader();
    }

    public DBFWriter(File dbfFile) throws DBFException {
        try {
            this.raf = new RandomAccessFile(dbfFile, "rw");
            if (!dbfFile.exists() || dbfFile.length() == 0L) {
                this.header = new DBFHeader();
                return;
            }
            this.header = new DBFHeader();
            this.header.read(this.raf);
            this.raf.seek(this.raf.length() - 1L);
        }
        catch (FileNotFoundException e) {
            throw new DBFException("Specified file is not found. " + e.getMessage());
        }
        catch (IOException e) {
            throw new DBFException(e.getMessage() + " while reading header");
        }
        this.recordCount = this.header.numberOfRecords;
    }

    public void setFields(DBFField[] fields) throws DBFException {
        if (this.header.fieldArray != null) {
            throw new DBFException("Fields has already been set");
        }
        if (fields == null || fields.length == 0) {
            throw new DBFException("Should have at least one field");
        }
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i] != null) continue;
            throw new DBFException("Field " + (i + 1) + " is null");
        }
        this.header.fieldArray = fields;
        try {
            if (this.raf != null && this.raf.length() == 0L) {
                this.header.write(this.raf);
            }
        }
        catch (IOException e) {
            throw new DBFException("Error accesing file");
        }
    }

    public void addRecord(Object[] values) throws DBFException {
        if (this.header.fieldArray == null) {
            throw new DBFException("Fields should be set before adding records");
        }
        if (values == null) {
            throw new DBFException("Null cannot be added as row");
        }
        if (values.length != this.header.fieldArray.length) {
            throw new DBFException("Invalid record. Invalid number of fields in row");
        }
        block9: for (int i = 0; i < this.header.fieldArray.length; ++i) {
            if (values[i] == null) continue;
            switch (this.header.fieldArray[i].getDataType()) {
                case 67: {
                    if (values[i] instanceof String) continue block9;
                    throw new DBFException("Invalid value for field " + i);
                }
                case 76: {
                    if (values[i] instanceof Boolean) continue block9;
                    throw new DBFException("Invalid value for field " + i);
                }
                case 78: {
                    if (values[i] instanceof Double) continue block9;
                    throw new DBFException("Invalid value for field " + i);
                }
                case 68: {
                    if (values[i] instanceof Date) continue block9;
                    throw new DBFException("Invalid value for field " + i);
                }
                case 70: {
                    if (values[i] instanceof Double || values[i] instanceof Float) continue block9;
                    throw new DBFException("Invalid value for field " + i);
                }
            }
        }
        if (this.raf == null) {
            this.v_records.addElement(values);
        } else {
            try {
                this.writeRecord(this.raf, values);
                ++this.recordCount;
            }
            catch (IOException e) {
                throw new DBFException("Error occured while writing record. " + e.getMessage());
            }
        }
    }

    public void write(OutputStream out) throws DBFException {
        try {
            if (this.raf == null) {
                DataOutputStream outStream = new DataOutputStream(out);
                this.header.numberOfRecords = this.v_records.size();
                this.header.write(outStream);
                int t_recCount = this.v_records.size();
                for (int i = 0; i < t_recCount; ++i) {
                    Object[] t_values = (Object[])this.v_records.elementAt(i);
                    this.writeRecord(outStream, t_values);
                }
                outStream.write(26);
                outStream.flush();
            } else {
                this.header.numberOfRecords = this.recordCount;
                this.raf.seek(0L);
                this.header.write(this.raf);
                this.raf.seek(this.raf.length());
                this.raf.writeByte(26);
                this.raf.close();
            }
        }
        catch (IOException e) {
            throw new DBFException(e.getMessage());
        }
    }

    public void write() throws DBFException {
        this.write(null);
    }

    public void close() {
        try {
            if (this.raf != null) {
                this.raf.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeRecord(DataOutput dataOutput, Object[] objectArray) throws IOException {
        this.buffer.reset();
        this.buffer.add((byte)32);
        block8: for (int j = 0; j < this.header.fieldArray.length; ++j) {
            switch (this.header.fieldArray[j].getDataType()) {
                case 67: {
                    if (objectArray[j] != null) {
                        String str_value = objectArray[j].toString();
                        this.buffer.add(Utils.textPadding(str_value, this.characterSetName, this.header.fieldArray[j].getFieldLength()));
                        continue block8;
                    }
                    this.buffer.add(Utils.textPadding("", this.characterSetName, this.header.fieldArray[j].getFieldLength()));
                    continue block8;
                }
                case 68: {
                    if (objectArray[j] != null) {
                        GregorianCalendar calendar = new GregorianCalendar();
                        calendar.setTime((Date)objectArray[j]);
                        this.buffer.add(String.valueOf(calendar.get(1)).getBytes());
                        this.buffer.add(Utils.textPadding(String.valueOf(calendar.get(2) + 1), this.characterSetName, 2, 12, (byte)48));
                        this.buffer.add(Utils.textPadding(String.valueOf(calendar.get(5)), this.characterSetName, 2, 12, (byte)48));
                        continue block8;
                    }
                    this.buffer.add("        ".getBytes());
                    continue block8;
                }
                case 70: {
                    this.buffer.add(Utils.doubleFormating((Double)objectArray[j], this.characterSetName, this.header.fieldArray[j].getFieldLength(), this.header.fieldArray[j].getDecimalCount()));
                    continue block8;
                }
                case 78: {
                    this.buffer.add(Utils.doubleFormating((Double)objectArray[j], this.characterSetName, this.header.fieldArray[j].getFieldLength(), this.header.fieldArray[j].getDecimalCount()));
                    continue block8;
                }
                case 76: {
                    if (objectArray[j] != null) {
                        if ((Boolean)objectArray[j] == Boolean.TRUE) {
                            this.buffer.add((byte)84);
                            continue block8;
                        }
                        this.buffer.add((byte)70);
                        continue block8;
                    }
                    this.buffer.add((byte)63);
                    continue block8;
                }
                case 77: {
                    continue block8;
                }
                default: {
                    throw new DBFException("Unknown field type " + this.header.fieldArray[j].getDataType());
                }
            }
        }
        dataOutput.write(this.buffer.get());
        this.buffer.reset();
    }

    public static void main(String[] args) throws Exception {
        DBFReader reader = new DBFReader(new FileInputStream(new File("C:\\Arbeit\\Projekte\\J2000Klima\\JAMS\\data\\J2000Klima Th\\input\\local\\gis\\hrus_th.dbf")));
        DBFWriter writer = new DBFWriter(new File("C:\\Arbeit\\Projekte\\J2000Klima\\JAMS\\data\\J2000Klima Th\\input\\local\\gis\\hrus_neu.dbf"));
        DBFField[] fields = new DBFField[reader.getFieldCount()];
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = reader.getField(i);
        }
        writer.setFields(fields);
        for (int j = 0; j < reader.getRecordCount(); ++j) {
            System.out.println("Writing record " + j + " of " + reader.getRecordCount());
            Object[] o = reader.nextRecord();
            for (int i = 0; i < 2000; ++i) {
                writer.addRecord(o);
            }
        }
        writer.write();
        writer.close();
    }

    class Buffer {
        final int BUFFERSIZE = 65536;
        byte[] buffer = new byte[65536];
        int p = 0;

        Buffer() {
        }

        void reset() {
            this.p = 0;
        }

        void add(byte[] x) {
            System.arraycopy(x, 0, this.buffer, this.p, x.length);
            this.p += x.length;
        }

        void add(byte x) {
            this.buffer[this.p++] = x;
        }

        byte[] get() {
            return Arrays.copyOf(this.buffer, this.p);
        }
    }
}

