/*
 * Decompiled with CFR 0.152.
 */
package jams.io;

import gnu.trove.map.hash.THashMap;
import jams.JAMS;
import jams.data.DataSupplier;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import java.util.TreeMap;

public class SimpleOutputDataStore {
    File file = null;
    BufferedWriter writer = null;
    RandomAccessFile raf = null;
    TreeMap<String, Long> entryMap = new TreeMap();
    THashMap<Double, Integer> entityMap = new THashMap();
    static StringBuffer strGlobalBuffer;
    StringBuffer strBuffer = null;
    DecimalFormat df2EPos = new DecimalFormat("+0.00000E0000;-0.00000E0000", new DecimalFormatSymbols(Locale.ENGLISH));
    DecimalFormat df2ENeg = new DecimalFormat("+0.00000E000;-0.00000E000", new DecimalFormatSymbols(Locale.ENGLISH));
    byte[] buffer = new byte[13];

    public SimpleOutputDataStore(File file) throws IOException {
        this(file, true);
    }

    public SimpleOutputDataStore(File file, boolean threadSafe) throws IOException {
        this.file = file;
        this.raf = new RandomAccessFile(file, "rw");
        this.raf.setLength(0L);
        if (threadSafe) {
            this.strBuffer = new StringBuffer();
        } else {
            if (strGlobalBuffer == null) {
                strGlobalBuffer = new StringBuffer(5120000);
            }
            this.strBuffer = strGlobalBuffer;
        }
    }

    public void setHeader(Collection<Double> ids) throws IOException {
        this.raf.writeBytes("date\t");
        int position = 0;
        this.entityMap.clear();
        for (double id : ids) {
            this.raf.writeBytes((int)id + "\t");
            this.entityMap.put(id, position++);
        }
        this.raf.writeBytes("\n");
    }

    public void setHeader(int maxID) throws IOException {
        this.raf.writeBytes("date\t");
        int position = 0;
        this.entityMap.clear();
        for (int id = 0; id < maxID; ++id) {
            this.raf.writeBytes(id + "\t");
            this.entityMap.put(Double.valueOf(id), position++);
        }
        this.raf.writeBytes("\n");
    }

    public int getPositionOfEntity(double id) {
        Integer i = this.entityMap.get(id);
        if (i == null) {
            return -1;
        }
        return i;
    }

    public String[] getEntries() {
        return this.entryMap.keySet().toArray(new String[0]);
    }

    public void setHeader(Set<Double> ids) throws IOException {
        this.raf.writeBytes("date\t");
        int position = 0;
        this.entityMap.clear();
        for (double id : ids) {
            this.raf.writeBytes((int)id + "\t");
            this.entityMap.put(id, position++);
        }
        this.raf.writeBytes("\n");
    }

    public File getFile() {
        return this.file;
    }

    public void writeData(String entry, DataSupplier<Double> values) throws IOException {
        this.raf.seek(this.raf.length());
        this.entryMap.put(entry, this.raf.getFilePointer());
        this.strBuffer.delete(0, this.strBuffer.length());
        this.strBuffer.append(entry);
        for (Double x : values) {
            String result;
            if (Double.isInfinite(x) || Double.isNaN(x)) {
                x = -9999.0;
            }
            if ((result = this.df2EPos.format(x)).contains("E-")) {
                result = this.df2ENeg.format(x);
            }
            this.strBuffer.append("\t").append(result);
        }
        this.strBuffer.append("\n");
        this.raf.writeBytes(this.strBuffer.toString());
    }

    public double getData(String entry, int position) throws IOException {
        if (position == -1) {
            return JAMS.getMissingDataValue();
        }
        this.raf.seek(this.entryMap.get(entry) + 17L + (long)(14 * position));
        this.raf.readFully(this.buffer);
        String s = new String(this.buffer);
        return Double.parseDouble(s);
    }

    public void close() throws IOException {
        this.raf.close();
    }
}

