/*
 * Decompiled with CFR 0.152.
 */
package jams.aggregators;

import jams.aggregators.Aggregator;
import jams.aggregators.TemporalAggregator;
import jams.data.Attribute;
import java.util.Collection;

public class CompoundTemporalAggregator<T>
extends TemporalAggregator<T> {
    Aggregator<T> aggregator;
    TemporalAggregator<T> innerAggregator;

    public CompoundTemporalAggregator(Aggregator<T> aggregator, TemporalAggregator<T> innerAggregator, TemporalAggregator.AggregationTimePeriod timePeriod) {
        this(aggregator, innerAggregator, timePeriod, null);
    }

    public CompoundTemporalAggregator(Aggregator<T> aggregator, TemporalAggregator<T> innerAggregator, TemporalAggregator.AggregationTimePeriod timePeriod, Collection<Attribute.TimeInterval> timePeriods) {
        super(timePeriod, timePeriods);
        this.aggregator = aggregator;
        this.innerAggregator = innerAggregator;
        innerAggregator.addConsumer(new TemporalAggregator.Consumer<T>(){

            @Override
            public void consume(Attribute.Calendar c, T v) {
                CompoundTemporalAggregator.this.aggregator.consider(v);
            }
        });
    }

    protected CompoundTemporalAggregator(CompoundTemporalAggregator<T> original) {
        super(original);
        this.aggregator = original.aggregator.copy();
        this.innerAggregator = original.innerAggregator.copy();
    }

    @Override
    public void init() {
        this.aggregator.init();
        this.innerAggregator.init();
    }

    @Override
    public TemporalAggregator<T> copy() {
        return new CompoundTemporalAggregator<T>(this);
    }

    @Override
    public void aggregate(Attribute.Calendar timeStep, T next) {
        if (this.isNextTimeStep(timeStep)) {
            this.innerAggregator.finish();
            this.aggregator.finish();
            this.consume(this.currentTimeStep(), this.aggregator.get());
            this.innerAggregator.init();
            this.aggregator.init();
            this.setTimeStep(timeStep);
        }
        this.innerAggregator.aggregate(timeStep, next);
    }

    @Override
    public void finish() {
        this.innerAggregator.finish();
        this.aggregator.finish();
        this.consume(this.currentTimeStep(), this.aggregator.get());
        super.finish();
    }
}

