/*
 * Decompiled with CFR 0.152.
 */
package jams;

import jams.JAMSLogging;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ErrorCatchingRunnable
implements Runnable {
    static final Logger log = Logger.getLogger(ErrorCatchingRunnable.class.getName());

    public ErrorCatchingRunnable() {
        JAMSLogging.registerLogger(JAMSLogging.LogOption.Show, log);
    }

    public abstract void safeRun() throws Exception;

    @Override
    public void run() {
        try {
            this.safeRun();
        }
        catch (Throwable t) {
            if (t.toString().contains("Interrupted")) {
                log.log(Level.SEVERE, "Action Canceled by User", t);
            }
            log.log(Level.SEVERE, t.getMessage(), t);
        }
    }
}

