/*
 * Decompiled with CFR 0.152.
 */
package jams.workspace.stores;

import jams.JAMS;
import jams.JAMSProperties;
import jams.data.Attribute;
import jams.data.DefaultDataFactory;
import jams.io.SerializableBufferedReader;
import jams.runtime.StandardRuntime;
import jams.workspace.DataReader;
import jams.workspace.DataSet;
import jams.workspace.DataSetDefinition;
import jams.workspace.DataValue;
import jams.workspace.DefaultDataSet;
import jams.workspace.DefaultDataSetDefinition;
import jams.workspace.InvalidWorkspaceException;
import jams.workspace.JAMSWorkspace;
import jams.workspace.TSDumpProcessor;
import jams.workspace.Workspace;
import jams.workspace.datatypes.CalendarValue;
import jams.workspace.datatypes.DoubleValue;
import jams.workspace.datatypes.LongValue;
import jams.workspace.datatypes.ObjectValue;
import jams.workspace.datatypes.StringValue;
import jams.workspace.stores.InputDataStore;
import jams.workspace.stores.TableDataStore;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TSDataStore
extends TableDataStore {
    public static final String NEWLINE = "\n";
    public static final String SEPARATOR = "\t";
    protected CalendarValue calendar;
    protected Attribute.Calendar currentDate;
    protected Attribute.Calendar startDate;
    protected Attribute.Calendar endDate;
    protected Attribute.Calendar stopDate;
    protected int timeUnit;
    protected int timeUnitCount;
    protected String timeFormat;
    File file = null;
    private SerializableBufferedReader dumpFileReader;
    private static final int DOUBLE = 0;
    private static final int LONG = 1;
    private static final int STRING = 2;
    private static final int TIMESTAMP = 3;
    private static final int OBJECT = 4;
    private int[] type;
    private RingBuffer<Long>[] latestTimesteps = null;
    protected Attribute.Calendar[] startDates;
    protected boolean[] endReached;
    protected double missingDateValueAsDouble;

    public TSDataStore(JAMSWorkspace ws) {
        super(ws);
        this.startDate = DefaultDataFactory.getDataFactory().createCalendar();
        this.endDate = DefaultDataFactory.getDataFactory().createCalendar();
        this.currentDate = DefaultDataFactory.getDataFactory().createCalendar();
        this.calendar = new CalendarValue(this.currentDate);
    }

    public TSDataStore(JAMSWorkspace ws, String id, Document doc) throws IOException, ClassNotFoundException {
        super(ws, id, doc);
        Element tiNode = (Element)doc.getElementsByTagName("timeinterval").item(0);
        Element startElement = (Element)tiNode.getElementsByTagName("start").item(0);
        Element endElement = (Element)tiNode.getElementsByTagName("end").item(0);
        Element stepsizeElement = (Element)tiNode.getElementsByTagName("stepsize").item(0);
        Element timeFormatElement = (Element)tiNode.getElementsByTagName("dumptimeformat").item(0);
        this.timeFormat = "yyyy-MM-dd HH:mm";
        if (timeFormatElement != null) {
            this.timeFormat = timeFormatElement.getAttribute("value");
        }
        this.startDate = DefaultDataFactory.getDataFactory().createCalendar();
        this.startDate.setValue(startElement.getAttribute("value"));
        this.timeUnit = Integer.parseInt(stepsizeElement.getAttribute("unit"));
        this.timeUnitCount = Integer.parseInt(stepsizeElement.getAttribute("count"));
        this.endDate = DefaultDataFactory.getDataFactory().createCalendar();
        this.endDate.setValue(endElement.getAttribute("value"));
        this.stopDate = this.endDate.clone();
        this.stopDate.add(this.timeUnit, -1 * this.timeUnitCount);
        this.currentDate = DefaultDataFactory.getDataFactory().createCalendar();
        this.currentDate.setDateFormat(this.timeFormat);
        this.currentDate.setValue(this.startDate);
        int oldBufferSize = this.bufferSize;
        if (this.bufferSize == 1) {
            this.bufferSize = 2;
        }
        if (!this.readCache()) {
            this.latestTimesteps = new RingBuffer[this.dataIOArray.length];
            this.startDates = new Attribute.Calendar[this.dataIOArray.length];
            this.endReached = new boolean[this.dataIOArray.length];
            for (int i = 0; i < this.dataIOArray.length; ++i) {
                this.latestTimesteps[i] = new RingBuffer(2);
                this.fillBuffer(i);
                this.startDates[i] = DefaultDataFactory.getDataFactory().createCalendar();
                DataSet[] ds = this.dataIOArray[i].getData();
                if (ds.length == 0) {
                    this.startDates[i].setTimeInMillis(Long.MAX_VALUE);
                    this.endReached[i] = true;
                    continue;
                }
                long timeStamp = ds[0].getData()[0].getLong();
                this.startDates[i].setTimeInMillis(timeStamp * 1000L);
                this.endReached[i] = false;
            }
        }
        this.currentDate.add(this.timeUnit, -1 * this.timeUnitCount);
        this.calendar = new CalendarValue(this.currentDate);
        if (this.writeCache) {
            TSDumpProcessor asciiConverter = new TSDumpProcessor();
            File file = new File(ws.getLocalDumpDirectory(), this.getID() + ".dump");
            asciiConverter.toASCIIFile(this, file);
            ws.getRuntime().sendInfoMsg(JAMS.i18n("Dumped_input_datastore_1") + this.getID() + JAMS.i18n("Dumped_input_datastore_2") + file + JAMS.i18n("Dumped_input_datastore_3"));
            this.writeCache = false;
        }
        if (this.readCache()) {
            File file = new File(ws.getLocalDumpDirectory(), this.getID() + ".dump");
            this.dumpFileReader = new SerializableBufferedReader(file);
            this.dsd = this.getDSDFromDumpFile();
        }
        this.bufferSize = oldBufferSize;
        this.missingDateValueAsDouble = Double.parseDouble(this.getMissingDataValue());
    }

    private DataSetDefinition getDSDFromDumpFile() throws IOException {
        String str;
        while ((str = this.dumpFileReader.readLine()) != null && !str.startsWith("#_TYPE_")) {
        }
        if (str == null) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(str, SEPARATOR);
        ArrayList<Class> dataTypes = new ArrayList<Class>();
        tok.nextToken();
        while (tok.hasMoreTokens()) {
            String className = tok.nextToken();
            try {
                dataTypes.add(Class.forName(className));
            }
            catch (ClassNotFoundException ex) {
                this.ws.getRuntime().sendErrorMsg("Referenced type in datastore " + this.id + " could not be found: " + className);
            }
        }
        DefaultDataSetDefinition def = new DefaultDataSetDefinition(dataTypes);
        this.type = new int[dataTypes.size()];
        int i = 0;
        for (Class clazz : dataTypes) {
            this.type[i] = clazz.equals(Long.class) ? 1 : (clazz.equals(Double.class) ? 0 : (clazz.equals(String.class) ? 2 : (clazz.equals(Timestamp.class) ? 3 : 4)));
            ++i;
        }
        while ((str = this.dumpFileReader.readLine()) != null && !str.startsWith("@data")) {
            tok = new StringTokenizer(str, SEPARATOR);
            String attributeName = tok.nextToken().substring(1);
            String className = tok.nextToken();
            ArrayList<Object> values = new ArrayList<Object>();
            Class<?> clazz = null;
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException ex) {
                this.ws.getRuntime().sendErrorMsg("Referenced type in datastore " + this.id + " could not be found: " + className);
                return null;
            }
            def.addAttribute(attributeName, clazz);
            while (tok.hasMoreTokens()) {
                String valueString = tok.nextToken();
                values.add(this.getDataValue(clazz, valueString));
            }
            def.setAttributeValues(attributeName, values);
        }
        return def;
    }

    private Object getDataValue(Class clazz, String valueString) {
        Object o = null;
        if (clazz.equals(Double.class)) {
            o = Double.valueOf(valueString);
        } else if (clazz.equals(Long.class)) {
            o = Long.valueOf(valueString);
        } else if (clazz.equals(Attribute.Calendar.class)) {
            Attribute.Calendar cal = DefaultDataFactory.getDataFactory().createCalendar();
            cal.setValue(valueString);
            o = cal;
        } else if (clazz.equals(Timestamp.class)) {
            Attribute.Calendar cal = DefaultDataFactory.getDataFactory().createCalendar();
            cal.setTimeInMillis(Long.parseLong(valueString) * 1000L);
            o = cal;
        } else {
            o = clazz.equals(String.class) ? valueString : new Object();
        }
        return o;
    }

    public void skip(int count) {
        if (this.accessMode != 1) {
            for (int i = 0; i < count; ++i) {
                this.getNext();
            }
        } else {
            try {
                for (int i = 0; i < count; ++i) {
                    this.dumpFileReader.readLine();
                }
                this.currentDate.add(this.timeUnit, this.timeUnitCount * count);
                if (this.currentDate.after(this.stopDate)) {
                    return;
                }
            }
            catch (IOException ex) {
                this.ws.getRuntime().sendErrorMsg("Premature end of dump file for datastore" + this.id);
                return;
            }
        }
    }

    private boolean checkStepSize(int i) {
        this.latestTimesteps[i].push(this.dataIOArray[i].getData()[this.currentPosition[i]].getData()[0].getLong());
        if (this.latestTimesteps[i].fillsize < 2) {
            return true;
        }
        long timeStamp1 = this.latestTimesteps[i].get(-1);
        long timeStamp2 = this.latestTimesteps[i].get(0);
        Attribute.Calendar cal1 = DefaultDataFactory.getDataFactory().createCalendar();
        cal1.setTimeInMillis(timeStamp1 * 1000L);
        Attribute.Calendar cal2 = DefaultDataFactory.getDataFactory().createCalendar();
        cal2.setTimeInMillis(timeStamp2 * 1000L);
        cal1.add(this.timeUnit, this.timeUnitCount);
        if (cal1.compareTo(cal2, this.timeUnit) != 0) {
            Attribute.Calendar cal = cal1.clone();
            cal.add(this.timeUnit, -1 * this.timeUnitCount);
            long demandedSeconds = Math.abs(cal1.getTimeInMillis() - cal.getTimeInMillis()) / 1000L;
            long currentSeconds = Math.abs(cal2.getTimeInMillis() - cal.getTimeInMillis()) / 1000L;
            this.ws.getRuntime().sendErrorMsg(JAMS.i18n("Error_in_") + this.getClass().getName() + JAMS.i18n(":_wrong_time_interval_in_column_") + i + JAMS.i18n("_(demanded_interval_=_") + demandedSeconds + JAMS.i18n("_sec,_provided_interval_=_") + currentSeconds + JAMS.i18n("_sec)!"));
            this.dataIOSet.clear();
            this.currentPosition[i] = this.maxPosition[i];
            return false;
        }
        return true;
    }

    @Override
    public boolean hasNext() {
        if (this.currentDate.after(this.stopDate)) {
            return false;
        }
        if (!this.readCache()) {
            for (int i = 0; i < this.dataIOArray.length; ++i) {
                if (this.startDates[i].after(this.currentDate) || this.currentPosition[i] < this.maxPosition[i]) continue;
                this.fillBuffer(i);
                if (this.currentPosition[i] < this.maxPosition[i]) continue;
                this.endReached[i] = true;
            }
        }
        return true;
    }

    @Override
    public DefaultDataSet getNext() {
        DefaultDataSet result;
        if (!this.hasNext()) {
            return null;
        }
        this.currentDate.add(this.timeUnit, this.timeUnitCount);
        if (!this.readCache()) {
            result = new DefaultDataSet(this.positionArray.length + 1);
            result.setData(0, this.calendar);
            for (int i = 0; i < this.dataIOArray.length; ++i) {
                boolean outOfInterval;
                boolean bl = outOfInterval = this.startDates[i].after(this.currentDate) || this.endReached[i];
                if (outOfInterval) {
                    result.setData(i + 1, new DoubleValue(JAMS.getMissingDataValue()));
                    continue;
                }
                DataSet ds = this.dataIOArray[i].getData()[this.currentPosition[i]];
                DataValue[] values = ds.getData();
                result.setData(i + 1, values[this.positionArray[i]]);
                this.checkStepSize(i);
                int n = i;
                this.currentPosition[n] = this.currentPosition[n] + 1;
            }
        } else {
            try {
                String str = this.dumpFileReader.readLine();
                while (str.endsWith(SEPARATOR)) {
                    str = str.substring(0, str.length() - 1);
                }
                String[] a = str.split(SEPARATOR, -1);
                result = new DefaultDataSet(a.length);
                result.setData(0, this.calendar);
                if (a.length > this.type.length + 1) {
                    this.ws.getRuntime().sendErrorMsg("dump file:" + this.id + "\nnumber of values in line " + str + "\ndoes not match header information");
                }
                for (int i = 1; i < a.length; ++i) {
                    Object value;
                    String valueString = a[i];
                    switch (this.type[i - 1]) {
                        case 0: {
                            value = new DoubleValue(valueString);
                            if (value.getDouble() != this.missingDateValueAsDouble) break;
                            value.setDouble(JAMS.getMissingDataValue(Double.class));
                            break;
                        }
                        case 1: {
                            value = new LongValue(valueString);
                            if ((double)value.getLong() != this.missingDateValueAsDouble) break;
                            value.setLong(JAMS.getMissingDataValue(Long.class));
                            break;
                        }
                        case 2: {
                            value = new StringValue(valueString);
                            if (!valueString.equals(this.getMissingDataValue())) break;
                            value.setString(JAMS.getMissingDataValue(String.class));
                            break;
                        }
                        case 3: {
                            Attribute.Calendar cal = DefaultDataFactory.getDataFactory().createCalendar();
                            cal.setTimeInMillis(Long.parseLong(valueString));
                            value = new CalendarValue(cal);
                        }
                        default: {
                            value = new ObjectValue(valueString);
                        }
                    }
                    result.setData(i, (DataValue)value);
                }
            }
            catch (IOException ex) {
                this.ws.getRuntime().sendErrorMsg("Premature end of dump file for datastore" + this.id);
                return null;
            }
        }
        return result;
    }

    public Attribute.Calendar getStartDate() {
        return this.startDate;
    }

    public Attribute.Calendar getEndDate() {
        return this.endDate;
    }

    public int getTimeUnit() {
        return this.timeUnit;
    }

    public int getTimeUnitCount() {
        return this.timeUnitCount;
    }

    public String getTimeFormat() {
        return this.timeFormat;
    }

    public Set<DataReader> getDataIOs() {
        return this.dataIOSet;
    }

    @Override
    public void close() {
        if (this.dumpFileReader != null) {
            try {
                this.dumpFileReader.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void convertTSDataStoreToJ2KFile(Workspace ws, String id) {
        InputDataStore store = ws.getInputDataStore(id);
        File outputFile = new File(ws.getLocalDumpDirectory(), id + ".dat");
        File xmlDescFile = new File(ws.getLocalDumpDirectory(), id + ".xml");
        if (outputFile.exists()) {
            System.out.println("Output file allready existing!");
            return;
        }
        if (!(store instanceof TSDataStore)) {
            System.out.println("Store is not a TSDataStore!");
            return;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.YYYY hh:mm");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        TSDataStore tsStore = (TSDataStore)store;
        DataSetDefinition dsd = store.getDataSetDefinition();
        BufferedWriter writer = null;
        BufferedWriter xmlWriter = null;
        try {
            writer = new BufferedWriter(new FileWriter(outputFile));
            xmlWriter = new BufferedWriter(new FileWriter(xmlDescFile));
            writer.write("@dataValueAttribs\n");
            writer.write(tsStore.getDisplayName() + SEPARATOR + Double.MIN_VALUE + SEPARATOR + Double.MAX_VALUE + "\t?\n");
            writer.write("@dataSetAttribs\n");
            writer.write("missingDataVal\t" + tsStore.getMissingDataValue() + NEWLINE);
            writer.write("dataStart\t" + dateFormat.format(tsStore.getStartDate().getTime()) + NEWLINE);
            writer.write("dataEnd\t" + dateFormat.format(tsStore.getEndDate().getTime()) + NEWLINE);
            if (tsStore.getTimeUnit() == 6) {
                writer.write("tres\td\n");
            }
            if (tsStore.getTimeUnit() == 2) {
                writer.write("tres\tm\n");
            }
            if (tsStore.getTimeUnit() == 1) {
                writer.write("tres\ty\n");
            }
            if (tsStore.getTimeUnit() == 11) {
                writer.write("tres\th\n");
            }
            writer.write("@statAttribVal\n");
            String stationNames = "name";
            String stationIDs = "ID";
            String stationElevation = "elevation";
            String stationX = "x";
            String stationY = "y";
            String dataColumn = "dataColumn";
            ArrayList xList = dsd.getAttributeValues("X");
            ArrayList yList = dsd.getAttributeValues("Y");
            ArrayList elevList = dsd.getAttributeValues("ELEVATION");
            ArrayList nameList = dsd.getAttributeValues("NAME");
            ArrayList idList = dsd.getAttributeValues("ID");
            for (int i = 0; i < dsd.getColumnCount(); ++i) {
                stationNames = stationNames + SEPARATOR + nameList.get(i);
                stationIDs = stationIDs + SEPARATOR + idList.get(i);
                stationElevation = stationElevation + SEPARATOR + elevList.get(i);
                stationX = stationX + SEPARATOR + xList.get(i);
                stationY = stationY + SEPARATOR + yList.get(i);
                dataColumn = dataColumn + SEPARATOR + (i + 1);
            }
            writer.write(stationNames + NEWLINE);
            writer.write(stationIDs + NEWLINE);
            writer.write(stationElevation + NEWLINE);
            writer.write(stationX + NEWLINE);
            writer.write(stationY + NEWLINE);
            writer.write(dataColumn + NEWLINE);
            writer.write("@dataVal\n");
            DefaultDataSet dds = null;
            while ((dds = tsStore.getNext()) != null) {
                String line = "";
                for (int i = 0; i < dds.getData().length; ++i) {
                    line = i == 0 ? line + dateFormat.format(dds.getData()[i].getCalendar().getTime()) + SEPARATOR : line + dds.getData()[i].getObject() + SEPARATOR;
                }
                line = line + NEWLINE;
                writer.write(line);
            }
            xmlWriter.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" standalone=\"no\"?>\n<j2ktsdatastore>\n<parsetime value=\"false\" />\n<dumptimeformat value=\"yyyy-MM-dd HH:mm\" /><charset value=\"ISO-8859-1\" /></j2ktsdatastore>");
        }
        catch (IOException ioe) {
            System.out.println("Error while writing file!");
            return;
        }
        finally {
            try {
                writer.close();
                xmlWriter.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void main(String[] args) throws IOException {
        File workspaceDirectory;
        if (args.length < 1) {
            System.out.println("Usage dump2j2kFile workspaceDir [id]");
        }
        if (!(workspaceDirectory = new File(args[0])).exists()) {
            System.out.println("Error: directory " + workspaceDirectory.getAbsolutePath() + " does not exist!");
            return;
        }
        StandardRuntime runtime = new StandardRuntime(JAMSProperties.createProperties());
        JAMSWorkspace ws = new JAMSWorkspace(workspaceDirectory, runtime, false);
        try {
            ws.init();
        }
        catch (InvalidWorkspaceException iwe) {
            System.out.println("Invalid workspace!\n" + iwe.toString());
        }
        if (args.length > 1) {
            String id = args[1];
            TSDumpProcessor asciiConverter = new TSDumpProcessor();
            System.out.println(asciiConverter.toASCIIString((TSDataStore)ws.getInputDataStore(id)));
        } else {
            Set inputDataStores = ws.getInputDataStoreIDs();
            for (String id : inputDataStores) {
                TSDataStore.convertTSDataStoreToJ2KFile(ws, id);
            }
        }
    }

    public class RingBuffer<T> {
        int index = 0;
        int size = 0;
        int fillsize = 0;
        ArrayList<T> ring = null;

        public RingBuffer(int size) {
            this.size = size;
            this.ring = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                this.ring.add(null);
            }
        }

        public T get(int relativIndex) {
            if (relativIndex < 0) {
                relativIndex += (-relativIndex / this.size + 1) * this.size;
            }
            return this.ring.get((this.index + relativIndex) % this.size);
        }

        public void push(T o) {
            this.index = (this.index + 1) % this.size;
            this.ring.set(this.index, o);
            this.fillsize = Math.min(this.size, this.fillsize + 1);
        }
    }
}

