/*
 * Decompiled with CFR 0.152.
 */
package jams.runtime;

import jams.runtime.JAMSRuntime;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;

public class RuntimeManager
extends Observable {
    private HashMap<JAMSRuntime, RuntimeInfo> runtimeInstances = new HashMap();
    private static RuntimeManager instance;

    private RuntimeManager() {
    }

    public static RuntimeManager getInstance() {
        if (instance == null) {
            instance = new RuntimeManager();
        }
        return instance;
    }

    public void addRuntime(JAMSRuntime runtime) {
        if (runtime.getState() != 1) {
            return;
        }
        RuntimeInfo rtInfo = new RuntimeInfo(Calendar.getInstance(), runtime);
        this.runtimeInstances.put(runtime, rtInfo);
        this.setChanged();
        this.notifyObservers(rtInfo);
        runtime.addStateObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                JAMSRuntime rt = (JAMSRuntime)o;
                if (rt.getState() == 0 || rt.getState() == 2) {
                    RuntimeManager.this.removeRuntime(rt);
                }
            }
        });
    }

    private void removeRuntime(JAMSRuntime runtime) {
        RuntimeInfo rtInfo = this.runtimeInstances.get(runtime);
        if (rtInfo == null) {
            return;
        }
        rtInfo.setEnd(Calendar.getInstance());
        this.runtimeInstances.remove(runtime);
        this.setChanged();
        this.notifyObservers(rtInfo);
    }

    public int getNumberofInstances() {
        return this.runtimeInstances.size();
    }

    public class RuntimeInfo {
        private Calendar startTime;
        private Calendar endTime;
        private JAMSRuntime runtime;

        public RuntimeInfo(Calendar startTime, JAMSRuntime runtime) {
            this.startTime = startTime;
            this.runtime = runtime;
        }

        private String getProgressString() {
            long max = this.runtime.getModel().getProgress()[1];
            long cur = this.runtime.getModel().getProgress()[0];
            if (max == 0L) {
                return String.format("%2d%%", max);
            }
            return String.format("%2.0f%%", Float.valueOf(100.0f * (float)cur / (float)max));
        }

        public String toString() {
            String result = this.runtime.getModel().getName() + " [";
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            result = result + "start=" + sdf.format(this.startTime.getTime()) + ", ";
            result = result + "progress=" + this.getProgressString() + ", ";
            if (this.runtime != null) {
                result = this.runtime.getModel().getWorkspace() != null ? result + "workspace=" + this.runtime.getModel().getWorkspace().getDirectory().getAbsolutePath() : result + "workspace=null";
            }
            result = result + "]";
            return result;
        }

        public void setEnd(Calendar endTime) {
            this.endTime = endTime;
        }

        public Calendar getStartTime() {
            return this.startTime;
        }

        public Calendar getEndTime() {
            return this.endTime;
        }

        public JAMSRuntime getRuntime() {
            return this.runtime;
        }
    }
}

