/*
 * Decompiled with CFR 0.152.
 */
package jams.model;

import jams.JAMS;
import jams.JAMSException;
import jams.data.Attribute;
import jams.data.DataFactory;
import jams.data.DefaultDataFactory;
import jams.data.EntityEnumerator;
import jams.data.JAMSBoolean;
import jams.data.JAMSBooleanArray;
import jams.data.JAMSCalendar;
import jams.data.JAMSData;
import jams.data.JAMSDirName;
import jams.data.JAMSDocument;
import jams.data.JAMSDouble;
import jams.data.JAMSDoubleArray;
import jams.data.JAMSEntity;
import jams.data.JAMSEntityCollection;
import jams.data.JAMSFloat;
import jams.data.JAMSFloatArray;
import jams.data.JAMSGeometry;
import jams.data.JAMSInteger;
import jams.data.JAMSIntegerArray;
import jams.data.JAMSLong;
import jams.data.JAMSLongArray;
import jams.data.JAMSObject;
import jams.data.JAMSObjectArray;
import jams.data.JAMSString;
import jams.data.JAMSStringArray;
import jams.data.JAMSTimeInterval;
import jams.dataaccess.BooleanAccessor;
import jams.dataaccess.BooleanArrayAccessor;
import jams.dataaccess.CalendarAccessor;
import jams.dataaccess.DataAccessor;
import jams.dataaccess.DocumentAccessor;
import jams.dataaccess.DoubleAccessor;
import jams.dataaccess.DoubleArrayAccessor;
import jams.dataaccess.EntityAccessor;
import jams.dataaccess.EntityCollectionAccessor;
import jams.dataaccess.FloatAccessor;
import jams.dataaccess.FloatArrayAccessor;
import jams.dataaccess.GeometryAccessor;
import jams.dataaccess.IntegerAccessor;
import jams.dataaccess.IntegerArrayAccessor;
import jams.dataaccess.LongArrayAccessor;
import jams.dataaccess.ObjectAccessor;
import jams.dataaccess.ObjectArrayAccessor;
import jams.dataaccess.StringAccessor;
import jams.dataaccess.StringArrayAccessor;
import jams.dataaccess.TimeIntervalAccessor;
import jams.io.datatracer.AbstractTracer;
import jams.io.datatracer.DataTracer;
import jams.model.AttributeAccess;
import jams.model.Component;
import jams.model.ComponentEnumerator;
import jams.model.Context;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.Model;
import jams.tools.JAMSTools;
import jams.workspace.stores.Filter;
import jams.workspace.stores.OutputDataStore;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;

@JAMSComponentDescription(title="JAMS Context", author="Sven Kralisch", date="2005-06-22", version="1.0_0", description="This component represents a JAMS context which is the top level component of every component hierarchie in JAMS models")
public class JAMSContext
extends JAMSComponent
implements Context {
    private Attribute.EntityCollection entities;
    protected ArrayList<Component> components = new ArrayList();
    protected ComponentEnumerator initEnumerator = null;
    protected ComponentEnumerator initAllEnumerator = null;
    protected ComponentEnumerator runEnumerator = null;
    protected ComponentEnumerator cleanupEnumerator = null;
    protected ComponentEnumerator cleanupAllEnumerator = null;
    private ArrayList<AttributeAccess> attributeAccessList = new ArrayList();
    private ArrayList<AttributeSpec> attributeSpecs = new ArrayList();
    protected DataAccessor[] dataAccessors = new DataAccessor[0];
    private HashMap<String, DataAccessor> dataAccessorMap;
    private HashMap<String, JAMSData> attributeMap;
    protected DataTracer[] dataTracers;
    protected boolean doRun = true;
    protected boolean isPaused = false;
    protected transient Runnable runRunnable;
    protected transient Runnable resumeRunnable;
    protected transient Runnable initAllRunnable;
    protected transient Runnable cleanupAllRunnable;
    protected transient Component currentComponent;
    protected long runCount;

    public JAMSContext() {
        ArrayList<Attribute.Entity> list = new ArrayList<Attribute.Entity>();
        list.add(DefaultDataFactory.getDataFactory().createEntity());
        this.setEntities(DefaultDataFactory.getDataFactory().createEntityCollection());
        this.getEntities().setEntities(list);
        this.attributeMap = new HashMap();
    }

    public void exchange(int i, int j) {
        Component oi = this.components.get(i);
        Component oj = this.components.get(j);
        this.components.set(i, oj);
        this.components.set(j, oi);
    }

    public void addComponent(Component c) {
        this.components.add(c);
        c.setContext((Context)this);
    }

    public void removeComponent(int index) {
        this.components.remove(index);
    }

    public ArrayList<Component> getComponents() {
        return this.components;
    }

    public void setComponents(ArrayList<Component> components) {
        this.components = components;
        Iterator<Component> i = components.iterator();
        while (i.hasNext()) {
            i.next().setContext((Context)this);
        }
    }

    protected ComponentEnumerator getChildrenEnumerator() {
        return new ComponentEnumerator(){
            Component[] compArray;
            int index;
            {
                this.compArray = JAMSContext.this.getCompArray();
                this.index = 0;
            }

            public boolean hasNext() {
                return this.index < this.compArray.length;
            }

            public boolean hasPrevious() {
                return this.index > 0;
            }

            public Component next() {
                return this.compArray[this.index++];
            }

            public Component previous() {
                return this.compArray[--this.index];
            }

            public void reset() {
                this.index = 0;
            }
        };
    }

    protected ComponentEnumerator getInitEnumerator() {
        return this.getChildrenEnumerator();
    }

    protected ComponentEnumerator getCleanupEnumerator() {
        return this.getChildrenEnumerator();
    }

    protected ComponentEnumerator getRunEnumerator() {
        return new ComponentEnumerator(){
            ComponentEnumerator ce;
            EntityEnumerator ee;
            int index;
            {
                this.ce = JAMSContext.this.getChildrenEnumerator();
                this.ee = JAMSContext.this.getEntities().getEntityEnumerator();
                this.index = 0;
            }

            public boolean hasNext() {
                boolean nextComp = this.ce.hasNext();
                boolean nextEntity = this.ee.hasNext();
                return nextEntity || nextComp;
            }

            public boolean hasPrevious() {
                boolean prevComp = this.ce.hasPrevious();
                boolean prevEntity = this.ee.hasPrevious();
                return prevComp || prevEntity;
            }

            public Component next() {
                if (!this.ce.hasNext() && this.ee.hasNext()) {
                    JAMSContext.this.updateEntityData();
                    Attribute.Entity current = this.ee.next();
                    JAMSContext.this.setEntity(current);
                    ++this.index;
                    JAMSContext.this.updateComponentData(this.index);
                    this.ce.reset();
                }
                return this.ce.next();
            }

            public void reset() {
                this.ee.reset();
                this.ce.reset();
                this.index = 0;
                JAMSContext.this.updateComponentData(this.index);
            }

            public Component previous() {
                if (this.ce.hasPrevious()) {
                    return this.ce.previous();
                }
                if (this.ee.hasPrevious()) {
                    this.ee.previous();
                    --this.index;
                    JAMSContext.this.updateComponentData(this.index);
                    while (this.ce.hasNext()) {
                        this.ce.next();
                    }
                    return this.ce.previous();
                }
                return null;
            }
        };
    }

    protected ComponentEnumerator getInitAllEnumerator() {
        return this.getRunEnumerator();
    }

    protected ComponentEnumerator getCleanupAllEnumerator() {
        return this.getRunEnumerator();
    }

    protected Component[] getCompArray() {
        if (this.components.size() == 0) {
            this.components.add((Component)new JAMSComponent());
        }
        Component[] comps = new Component[this.components.size()];
        this.components.toArray(comps);
        return comps;
    }

    public void addAccess(Component user, String varName, String attributeName, int accessType, int updateType) {
        this.attributeAccessList.add(new AttributeAccess(user, varName, attributeName, accessType, updateType));
    }

    public void addAttribute(String attributeName, String clazz, String value) {
        this.attributeSpecs.add(new AttributeSpec(attributeName, clazz, value));
    }

    public void setModel(Model model) {
        super.setModel(model);
    }

    public void initAccessors() {
        Class<?> clazz;
        this.attributeMap = new HashMap();
        this.dataAccessorMap = new HashMap();
        Attribute.Entity[] entityArray = this.getEntities().getEntityArray();
        for (AttributeSpec attributeSpec : this.attributeSpecs) {
            try {
                clazz = Class.forName(attributeSpec.className);
                JAMSData data = this.getDataObject(entityArray, clazz, attributeSpec.attributeName, 1, 1, null);
                data.setValue(attributeSpec.value);
                for (Attribute.Entity entity : entityArray) {
                    entity.setObject(attributeSpec.attributeName, (Object)data);
                }
            }
            catch (ClassNotFoundException cnfe) {
                this.getModel().getRuntime().handle((Throwable)cnfe, false);
            }
            catch (InstantiationException ie) {
                this.getModel().getRuntime().handle((Throwable)ie, false);
            }
            catch (IllegalAccessException iae) {
                this.getModel().getRuntime().handle((Throwable)iae, false);
            }
            catch (Exception e) {
                this.getModel().getRuntime().handle((Throwable)e, false);
            }
        }
        for (AttributeAccess accessSpec : this.attributeAccessList) {
            try {
                clazz = JAMSTools.getField(accessSpec.getComponent().getClass(), accessSpec.getVarName()).getType();
                if (clazz.isArray()) {
                    StringTokenizer tok = new StringTokenizer(accessSpec.getAttributeName(), ";");
                    int count = tok.countTokens();
                    Class<?> componentClass = clazz.getComponentType();
                    JAMSData[] array = (JAMSData[])Array.newInstance(componentClass, count);
                    for (int i = 0; i < count; ++i) {
                        array[i] = this.getDataObject(entityArray, componentClass, tok.nextToken(), accessSpec.getAccessType(), accessSpec.getUpdateType(), null);
                    }
                    Field field = JAMSTools.getField(accessSpec.getComponent().getClass(), accessSpec.getVarName());
                    JAMSTools.setField(accessSpec.getComponent(), field, array);
                    if (this.getModel().getNullFields() != null) {
                        ArrayList nullFields = (ArrayList)this.getModel().getNullFields().get(accessSpec.getComponent());
                        nullFields.remove(field);
                    }
                } else {
                    JAMSData componentObject = null;
                    JAMSData dataObject = this.getDataObject(entityArray, clazz, accessSpec.getAttributeName(), accessSpec.getAccessType(), accessSpec.getUpdateType(), componentObject);
                    Field field = JAMSTools.getField(accessSpec.getComponent().getClass(), accessSpec.getVarName());
                    JAMSTools.setField(accessSpec.getComponent(), field, dataObject);
                }
            }
            catch (Exception e) {
                this.getModel().getRuntime().sendErrorMsg(JAMS.i18n("Error_occured_in_") + accessSpec.getComponent().getInstanceName() + ": " + accessSpec.getVarName());
                this.getModel().getRuntime().handle((Throwable)e, false);
            }
            if (this.dataAccessorMap.size() <= 0) continue;
            this.dataAccessors = this.dataAccessorMap.values().toArray(new DataAccessor[this.dataAccessorMap.size()]);
        }
    }

    public String getTraceMark() {
        return Long.toString(this.getEntities().getCurrent().getId());
    }

    protected DataTracer createDataTracer(OutputDataStore store) {
        if (store.getFilters().length == 0) {
            return new AbstractTracer(this, store, JAMSLong.class){

                @Override
                public void trace() {
                    DataAccessor[] dataAccessors = this.getAccessorObjects();
                    EntityEnumerator ee = JAMSContext.this.getEntities().getEntityEnumerator();
                    ee.reset();
                    int j = 0;
                    while (true) {
                        this.process(dataAccessors, j);
                        if (!ee.hasNext()) break;
                        ee.next();
                        ++j;
                    }
                    if (this.hasOutput()) {
                        this.endMark();
                        this.setOutput(false);
                    }
                }

                private void process(DataAccessor[] dataAccessors, int j) {
                    String traceMark = JAMSContext.this.getTraceMark();
                    if (!this.hasOutput()) {
                        this.setOutput(true);
                        this.startMark();
                    }
                    this.output(traceMark);
                    for (int i = 0; i < dataAccessors.length; ++i) {
                        dataAccessors[i].setIndex(j);
                        dataAccessors[i].read();
                        this.output(dataAccessors[i].getComponentObject());
                    }
                    this.nextRow();
                }
            };
        }
        return new AbstractTracer(this, store, JAMSLong.class){

            @Override
            public void trace() {
                for (Filter filter : this.store.getFilters()) {
                    String s;
                    if (filter.getContext() == JAMSContext.this || filter.isFiltered(s = filter.getContext().getTraceMark())) continue;
                    return;
                }
                DataAccessor[] dataAccessors = this.getAccessorObjects();
                EntityEnumerator ee = JAMSContext.this.getEntities().getEntityEnumerator();
                ee.reset();
                int j = 0;
                while (true) {
                    this.process(dataAccessors, j);
                    if (!ee.hasNext()) break;
                    ee.next();
                    ++j;
                }
                if (this.hasOutput()) {
                    this.endMark();
                    this.setOutput(false);
                }
            }

            private void process(DataAccessor[] dataAccessors, int j) {
                String traceMark = JAMSContext.this.getTraceMark();
                for (Filter filter : this.store.getFilters()) {
                    if (filter.getContext() != JAMSContext.this || filter.isFiltered(traceMark)) continue;
                    return;
                }
                if (!this.hasOutput()) {
                    this.setOutput(true);
                    this.startMark();
                }
                this.output(traceMark);
                for (int i = 0; i < dataAccessors.length; ++i) {
                    dataAccessors[i].setIndex(j);
                    dataAccessors[i].read();
                    this.output(dataAccessors[i].getComponentObject());
                }
                this.nextRow();
            }
        };
    }

    public void setupDataTracer() {
        if (this.getModel().getWorkspace() == null) {
            this.dataTracers = new DataTracer[0];
        } else {
            OutputDataStore[] stores = this.getModel().getWorkspace().getOutputDataStores(this.getInstanceName());
            this.dataTracers = new DataTracer[stores.length];
            int i = 0;
            for (OutputDataStore store : stores) {
                this.dataTracers[i] = this.createDataTracer(store);
                ++i;
            }
        }
        for (int j = 0; j < this.components.size(); ++j) {
            Component comp = this.components.get(j);
            if (!(comp instanceof Context)) continue;
            ((Context)comp).setupDataTracer();
        }
    }

    private void createRunRunnable(boolean isProfiling) {
        this.runRunnable = isProfiling ? new Runnable(){

            @Override
            public void run() {
                long cStart = System.currentTimeMillis();
                try {
                    JAMSContext.this.currentComponent.run();
                }
                catch (Exception e) {
                    JAMSContext.this.getModel().getRuntime().handle((Throwable)e, JAMSContext.this.currentComponent.getInstanceName());
                }
                JAMSContext.this.getModel().measureTime(cStart, JAMSContext.this.currentComponent);
                ++JAMSContext.this.runCount;
            }
        } : new Runnable(){

            @Override
            public void run() {
                try {
                    JAMSContext.this.currentComponent.run();
                }
                catch (Exception e) {
                    JAMSContext.this.getModel().getRuntime().handle((Throwable)e, JAMSContext.this.currentComponent.getInstanceName());
                }
                ++JAMSContext.this.runCount;
            }
        };
    }

    private void createInitAllRunnable(boolean isProfiling) {
        this.initAllRunnable = isProfiling ? new Runnable(){

            @Override
            public void run() {
                long cStart = System.currentTimeMillis();
                try {
                    JAMSContext.this.currentComponent.initAll();
                }
                catch (Exception e) {
                    JAMSContext.this.getModel().getRuntime().handle((Throwable)e, JAMSContext.this.currentComponent.getInstanceName());
                }
                JAMSContext.this.getModel().measureTime(cStart, JAMSContext.this.currentComponent);
            }
        } : new Runnable(){

            @Override
            public void run() {
                try {
                    JAMSContext.this.currentComponent.initAll();
                }
                catch (Exception e) {
                    JAMSContext.this.getModel().getRuntime().handle((Throwable)e, JAMSContext.this.currentComponent.getInstanceName());
                }
            }
        };
    }

    private void createCleanupAllRunnable(boolean isProfiling) {
        this.cleanupAllRunnable = isProfiling ? new Runnable(){

            @Override
            public void run() {
                long cStart = System.currentTimeMillis();
                try {
                    JAMSContext.this.currentComponent.cleanupAll();
                }
                catch (Exception e) {
                    JAMSContext.this.getModel().getRuntime().handle((Throwable)e, JAMSContext.this.currentComponent.getInstanceName());
                }
                JAMSContext.this.getModel().measureTime(cStart, JAMSContext.this.currentComponent);
            }
        } : new Runnable(){

            @Override
            public void run() {
                try {
                    JAMSContext.this.currentComponent.cleanupAll();
                }
                catch (Exception e) {
                    JAMSContext.this.getModel().getRuntime().handle((Throwable)e, JAMSContext.this.currentComponent.getInstanceName());
                }
            }
        };
    }

    private void createResumeRunnable(boolean isProfiling) {
        this.resumeRunnable = isProfiling ? new Runnable(){

            @Override
            public void run() {
                long cStart = System.currentTimeMillis();
                ((Context)JAMSContext.this.currentComponent).resume();
                JAMSContext.this.getModel().measureTime(cStart, JAMSContext.this.currentComponent);
            }
        } : new Runnable(){

            @Override
            public void run() {
                ((Context)JAMSContext.this.currentComponent).resume();
            }
        };
    }

    protected void initTracerDataAccess() {
        OutputDataStore[] stores = this.getModel().getWorkspace().getOutputDataStores(this.getInstanceName());
        Attribute.Entity[] entityArray = this.getEntities().getEntityArray();
        for (OutputDataStore outputDataStore : stores) {
            for (String attributeName : outputDataStore.getAttributes()) {
                try {
                    JAMSData attribute = (JAMSData)entityArray[0].getObject(attributeName);
                    if (attribute == null) continue;
                    Class<?> clazz = attribute.getClass();
                    this.getDataObject(entityArray, clazz, attributeName, 0, 1, null);
                }
                catch (Attribute.Entity.NoSuchAttributeException nsae) {
                    this.getModel().getRuntime().sendErrorMsg(JAMS.i18n("Can't_trace_attribute_") + attributeName + JAMS.i18n("_in_context_") + this.getInstanceName() + JAMS.i18n("_(not_found)!"));
                }
                catch (Exception e) {
                    this.getModel().getRuntime().sendErrorMsg(JAMS.i18n("Error_while_trying_to_trace_") + attributeName + ": " + this.getInstanceName());
                    this.getModel().getRuntime().handle((Throwable)e, false);
                }
            }
        }
        if (this.dataAccessorMap.size() > this.dataAccessors.length) {
            this.dataAccessors = this.dataAccessorMap.values().toArray(new DataAccessor[this.dataAccessorMap.size()]);
        }
        if (this.dataTracers != null) {
            for (DataTracer dataTracer : this.dataTracers) {
                if (dataTracer == null) continue;
                dataTracer.updateDataAccessors();
            }
        }
    }

    protected JAMSData getDataObject(Attribute.Entity[] ea, Class clazz, String attributeName, int accessType, int updateType, JAMSData componentObject) throws InstantiationException, IllegalAccessException, ClassNotFoundException, Attribute.Entity.NoSuchAttributeException {
        Object da = null;
        JAMSData dataObject = this.attributeMap.get(attributeName);
        if (dataObject == null) {
            if (componentObject != null) {
                dataObject = componentObject;
            } else {
                try {
                    dataObject = DefaultDataFactory.getDataFactory().createInstance(clazz);
                }
                catch (InstantiationException ex) {
                    this.getModel().getRuntime().handle((Throwable)ex, false);
                }
                catch (IllegalAccessException ex) {
                    this.getModel().getRuntime().handle((Throwable)ex, false);
                }
            }
            this.attributeMap.put(attributeName, dataObject);
            DataFactory dataFactory = this.getModel().getRuntime().getDataFactory();
            if (clazz.isInterface()) {
                clazz = dataFactory.getImplementingClass(clazz);
            }
            if (JAMSDouble.class.isAssignableFrom(clazz)) {
                da = new DoubleAccessor(dataFactory, ea, dataObject, attributeName, accessType, updateType);
            } else if (JAMSDoubleArray.class.isAssignableFrom(clazz)) {
                da = new DoubleArrayAccessor(dataFactory, ea, dataObject, attributeName, accessType, updateType);
            } else if (JAMSLong.class.isAssignableFrom(clazz)) {
                da = new CalendarAccessor(dataFactory, ea, dataObject, attributeName, accessType, updateType);
            } else if (JAMSLongArray.class.isAssignableFrom(clazz)) {
                da = new LongArrayAccessor(dataFactory, ea, dataObject, attributeName, accessType, updateType);
            } else if (JAMSString.class.isAssignableFrom(clazz)) {
                da = new StringAccessor(dataFactory, ea, dataObject, attributeName, accessType, updateType);
            } else if (JAMSStringArray.class.isAssignableFrom(clazz)) {
                da = new StringArrayAccessor(dataFactory, ea, dataObject, attributeName, accessType, updateType);
            } else if (JAMSBoolean.class.isAssignableFrom(clazz)) {
                da = new BooleanAccessor(dataFactory, ea, dataObject, attributeName, accessType, updateType);
            } else if (JAMSBooleanArray.class.isAssignableFrom(clazz)) {
                da = new BooleanArrayAccessor(dataFactory, ea, dataObject, attributeName, accessType, updateType);
            } else if (JAMSFloat.class.isAssignableFrom(clazz)) {
                da = new FloatAccessor(dataFactory, ea, dataObject, attributeName, accessType, updateType);
            } else if (JAMSFloatArray.class.isAssignableFrom(clazz)) {
                da = new FloatArrayAccessor(dataFactory, ea, dataObject, attributeName, accessType, updateType);
            } else if (JAMSInteger.class.isAssignableFrom(clazz)) {
                da = new IntegerAccessor(dataFactory, ea, dataObject, attributeName, accessType, updateType);
            } else if (JAMSIntegerArray.class.isAssignableFrom(clazz)) {
                da = new IntegerArrayAccessor(dataFactory, ea, dataObject, attributeName, accessType, updateType);
            } else if (JAMSString.class.isAssignableFrom(clazz)) {
                da = new StringAccessor(dataFactory, ea, dataObject, attributeName, accessType, updateType);
            } else if (JAMSDirName.class.isAssignableFrom(clazz)) {
                da = new StringAccessor(dataFactory, ea, dataObject, attributeName, accessType, updateType);
            } else if (JAMSEntity.class.isAssignableFrom(clazz)) {
                da = new EntityAccessor(dataFactory, ea, dataObject, attributeName, accessType, updateType);
            } else if (JAMSEntityCollection.class.isAssignableFrom(clazz)) {
                da = new EntityCollectionAccessor(dataFactory, ea, dataObject, attributeName, accessType, updateType);
            } else if (JAMSCalendar.class.isAssignableFrom(clazz)) {
                da = new CalendarAccessor(dataFactory, ea, dataObject, attributeName, accessType, updateType);
            } else if (JAMSTimeInterval.class.isAssignableFrom(clazz)) {
                da = new TimeIntervalAccessor(dataFactory, ea, dataObject, attributeName, accessType, updateType);
            } else if (JAMSDocument.class.isAssignableFrom(clazz)) {
                da = new DocumentAccessor(dataFactory, ea, dataObject, attributeName, accessType, updateType);
            } else if (JAMSGeometry.class.isAssignableFrom(clazz)) {
                da = new GeometryAccessor(dataFactory, ea, dataObject, attributeName, accessType, updateType);
            } else if (JAMSObject.class.isAssignableFrom(clazz)) {
                da = new ObjectAccessor(dataFactory, ea, dataObject, attributeName, accessType, updateType);
            } else if (JAMSObjectArray.class.isAssignableFrom(clazz)) {
                da = new ObjectArrayAccessor(dataFactory, ea, dataObject, attributeName, accessType, updateType);
            } else {
                this.getModel().getRuntime().sendHalt(JAMS.i18n("Class_") + clazz.getCanonicalName() + JAMS.i18n("_not_supported!") + " (attribute:" + attributeName + ")");
            }
            if (da != null) {
                this.dataAccessorMap.put(attributeName, (DataAccessor)da);
            }
        }
        return dataObject;
    }

    protected void initEntityData() {
        for (int i = 0; i < this.dataAccessors.length; ++i) {
            if (this.dataAccessors[i].getAccessType() != 1) continue;
            this.dataAccessors[i].initEntityData();
        }
    }

    public void init() {
        this.runEnumerator = null;
        if (!this.doRun) {
            return;
        }
        this.initAccessors();
        if (this.initEnumerator == null) {
            this.initEnumerator = this.getInitEnumerator();
        }
        this.initEnumerator.reset();
        Component comp = null;
        try {
            while (this.initEnumerator.hasNext() && this.doRun) {
                comp = this.initEnumerator.next();
                comp.init();
            }
        }
        catch (Exception e) {
            this.getModel().getRuntime().handle((Throwable)e, comp.getInstanceName());
        }
        this.initEntityData();
        if (this.dataTracers != null) {
            for (DataTracer t : this.dataTracers) {
                t.updateDataAccessors();
            }
        }
        this.createRunRunnable(this.getModel().isProfiling());
        this.createInitAllRunnable(this.getModel().isProfiling());
        this.createCleanupAllRunnable(this.getModel().isProfiling());
        this.createResumeRunnable(this.getModel().isProfiling());
        this.runCount = 0L;
    }

    public void initAll() {
        if (this.getEntities().getEntities().isEmpty()) {
            return;
        }
        if (this.initAllEnumerator == null) {
            this.initAllEnumerator = this.getInitAllEnumerator();
        }
        this.initAllEnumerator.reset();
        this.currentComponent = null;
        while (this.initAllEnumerator.hasNext() && this.doRun) {
            this.currentComponent = this.initAllEnumerator.next();
            this.initAllRunnable.run();
        }
        this.updateEntityData();
    }

    public void run() {
        if (this.getEntities().getEntities().isEmpty()) {
            return;
        }
        if (this.runEnumerator == null) {
            this.runEnumerator = this.getRunEnumerator();
        }
        this.runEnumerator.reset();
        this.currentComponent = null;
        while (this.runEnumerator.hasNext() && this.doRun) {
            this.currentComponent = this.runEnumerator.next();
            try {
                this.runRunnable.run();
            }
            catch (Exception e) {
                this.getModel().getRuntime().handle((Throwable)e, this.currentComponent.getInstanceName());
            }
        }
        this.updateEntityData();
        for (DataTracer dataTracer : this.dataTracers) {
            dataTracer.trace();
        }
    }

    public void cleanup() {
        if (this.cleanupEnumerator == null) {
            this.cleanupEnumerator = this.getCleanupEnumerator();
        }
        this.cleanupEnumerator.reset();
        Component comp = null;
        while (this.cleanupEnumerator.hasNext() && this.doRun) {
            comp = this.cleanupEnumerator.next();
            try {
                comp.cleanup();
            }
            catch (Exception e) {
                this.getModel().getRuntime().handle((Throwable)e, comp.getInstanceName());
            }
        }
        this.updateEntityData();
    }

    public void cleanupAll() {
        if (this.getEntities().getEntities().isEmpty()) {
            return;
        }
        if (this.cleanupAllEnumerator == null) {
            this.cleanupAllEnumerator = this.getCleanupAllEnumerator();
        }
        this.cleanupAllEnumerator.reset();
        this.currentComponent = null;
        while (this.cleanupAllEnumerator.hasNext() && this.doRun) {
            this.currentComponent = this.cleanupAllEnumerator.next();
            this.cleanupAllRunnable.run();
        }
        this.updateEntityData();
    }

    public void resume() {
        for (Component component : this.getCompArray()) {
            try {
                component.restore();
            }
            catch (Exception e) {
                this.getModel().getRuntime().handle((Throwable)e, component.getInstanceName());
            }
        }
        if (this.runEnumerator == null) {
            this.runEnumerator = this.getRunEnumerator();
        }
        this.currentComponent = null;
        if (this.runEnumerator.hasPrevious()) {
            this.currentComponent = this.runEnumerator.previous();
            try {
                if (this.currentComponent instanceof JAMSContext) {
                    this.resumeRunnable.run();
                }
            }
            catch (Exception exception) {
                this.getModel().getRuntime().handle((Throwable)exception, this.currentComponent.getInstanceName());
            }
            this.runEnumerator.next();
        }
        while (this.runEnumerator.hasNext() && this.doRun) {
            this.currentComponent = this.runEnumerator.next();
            try {
                this.runRunnable.run();
            }
            catch (Exception exception) {
                this.getModel().getRuntime().handle((Throwable)exception, this.currentComponent.getInstanceName());
            }
        }
        this.updateEntityData();
        if (!this.isPaused) {
            for (DataTracer dataTracer : this.dataTracers) {
                dataTracer.trace();
            }
        }
    }

    public void restore() {
        for (DataTracer dataTracer : this.dataTracers) {
            dataTracer.updateDataAccessors();
        }
        for (DataTracer dataTracer : this.getCompArray()) {
            try {
                dataTracer.restore();
            }
            catch (Exception e) {
                this.getModel().getRuntime().handle((Throwable)e, dataTracer.getInstanceName());
            }
        }
    }

    public HashMap<String, DataAccessor> getDataAccessorMap() {
        return this.dataAccessorMap;
    }

    public HashMap<String, JAMSData> getAttributeMap() {
        return this.attributeMap;
    }

    public ArrayList<AttributeAccess> getAttributeAccessList() {
        return this.attributeAccessList;
    }

    public void setAccessSpecs(ArrayList<AttributeAccess> accessSpecs) {
        this.attributeAccessList = accessSpecs;
    }

    public Component getComponent(String name) {
        for (int i = 0; i < this.components.size(); ++i) {
            Component comp;
            if (this.components.get(i).getInstanceName().equals(name)) {
                return this.components.get(i);
            }
            if (!(this.components.get(i) instanceof Context) || (comp = ((Context)this.components.get(i)).getComponent(name)) == null) continue;
            return comp;
        }
        return null;
    }

    public void updateEntityData() {
        for (DataAccessor dataAccessor : this.dataAccessors) {
            try {
                dataAccessor.write();
            }
            catch (ArithmeticException ae) {
                String name = "";
                for (String key : this.dataAccessorMap.keySet()) {
                    if (dataAccessor != this.dataAccessorMap.get(key)) continue;
                    name = key;
                }
                throw new JAMSException("Problem occured while accessing attribute \"" + name + "\".", (Throwable)ae);
            }
        }
    }

    public void updateComponentData(int index) {
        for (DataAccessor dataAccessor : this.dataAccessors) {
            dataAccessor.setIndex(index);
            dataAccessor.read();
        }
    }

    public long getNumberOfIterations() {
        return this.getEntities().getEntities().size();
    }

    public long getRunCount() {
        return this.runCount;
    }

    public Attribute.EntityCollection getEntities() {
        return this.entities;
    }

    public void setEntities(Attribute.EntityCollection entities) {
        this.entities = entities;
    }

    public void setEntity(Attribute.Entity entity) {
    }

    public void setExecutionState(int state) {
        switch (state) {
            case 1: {
                this.doRun = true;
                break;
            }
            case 0: {
                this.doRun = false;
                break;
            }
            case 2: {
                this.doRun = false;
            }
        }
        ComponentEnumerator ce = this.getChildrenEnumerator();
        while (ce.hasNext()) {
            Component comp = ce.next();
            if (!(comp instanceof Context)) continue;
            ((Context)comp).setExecutionState(state);
        }
    }

    private void writeObject(ObjectOutputStream objOut) throws IOException {
        objOut.defaultWriteObject();
        objOut.writeBoolean(this.getModel().isProfiling());
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        boolean doProfiling = stream.readBoolean();
        this.createRunRunnable(doProfiling);
        this.createResumeRunnable(doProfiling);
    }

    class AttributeSpec
    implements Serializable {
        public String attributeName;
        public String className;
        public String value;

        public AttributeSpec(String attributeName, String className, String value) {
            this.attributeName = attributeName;
            this.className = className;
            this.value = value;
        }
    }

    class SerializableThread
    extends Thread
    implements Serializable {
        public SerializableThread(Runnable r) {
            super(r);
        }
    }
}

