/*
 * Decompiled with CFR 0.152.
 */
package jams.meta;

import jams.JAMS;
import jams.JAMSException;
import jams.JAMSLogging;
import jams.JAMSVersion;
import jams.data.Attribute;
import jams.data.DefaultDataFactory;
import jams.io.ParameterProcessor;
import jams.meta.AttributeList;
import jams.meta.ComponentDescriptor;
import jams.meta.ComponentField;
import jams.meta.ContextAttribute;
import jams.meta.ContextDescriptor;
import jams.meta.HelpComponent;
import jams.meta.MetaProcessorDescriptor;
import jams.meta.ModelDescriptor;
import jams.meta.ModelNode;
import jams.meta.ModelProperties;
import jams.meta.NodeFactory;
import jams.meta.OutputDSDescriptor;
import jams.model.JAMSContext;
import jams.model.JAMSModel;
import jams.tools.StringTools;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ModelIO {
    private static final Class modelClazz = JAMSModel.class;
    private ClassLoader loader;
    private String modelName;
    private final NodeFactory nodeFactory;

    public ModelIO(NodeFactory nodeFactory) {
        JAMSLogging.registerLogger(JAMSLogging.LogOption.CollectAndShow, Logger.getLogger(this.getClass().getName()));
        this.nodeFactory = nodeFactory;
    }

    public static ModelIO getStandardModelIO() {
        return new ModelIO(new NodeFactory(){

            @Override
            public ModelNode createNode(ComponentDescriptor cd) {
                return new ModelNode(cd);
            }
        });
    }

    public ModelDescriptor createModel() {
        ModelDescriptor md = new ModelDescriptor();
        ContextDescriptor cd = new ContextDescriptor(JAMS.i18n("NewModel"), modelClazz, null, md);
        ModelNode rootNode = this.nodeFactory.createNode(cd);
        rootNode.setType(2);
        md.setRootNode(rootNode);
        md.initDatastores(null);
        return md;
    }

    public ModelDescriptor loadModelDescriptor(Document modelDoc, ClassLoader loader, boolean processEditors) {
        this.loader = loader;
        ParameterProcessor.preProcess(modelDoc);
        ModelDescriptor md = this.getModelDescriptor(modelDoc, processEditors);
        return md;
    }

    private ModelDescriptor getModelDescriptor(Document modelDoc, boolean processEditors) throws ComponentDescriptor.NullClassException {
        Element launcherNode;
        ModelDescriptor md = new ModelDescriptor();
        Element docRoot = modelDoc.getDocumentElement();
        this.modelName = docRoot.getAttribute("name");
        md.setAuthor(docRoot.getAttribute("author"));
        md.setDate(docRoot.getAttribute("date"));
        md.setHelpBaseUrl(docRoot.getAttribute("helpbaseurl"));
        Node descriptionNode = docRoot.getElementsByTagName("description").item(0);
        if (descriptionNode != null) {
            md.setDescription(descriptionNode.getTextContent().trim());
        }
        ContextDescriptor cd = new ContextDescriptor(this.modelName, modelClazz, null, md);
        ModelNode rootNode = this.nodeFactory.createNode(cd);
        rootNode.setType(2);
        md.setRootNode(rootNode);
        NodeList children = docRoot.getChildNodes();
        for (int index = 0; index < children.getLength(); ++index) {
            Element element;
            Node node = children.item(index);
            if (node.getNodeName().equals("contextcomponent") || node.getNodeName().equals("component")) {
                element = (Element)node;
                try {
                    rootNode.add(this.getSubTree(element, md));
                }
                catch (JAMSException mle) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, mle.getMessage(), mle.getWrappedException());
                }
                continue;
            }
            if (node.getNodeName().equals("attribute")) {
                try {
                    this.addContextAttribute(cd, (Element)node);
                }
                catch (JAMSException mle) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, mle.getMessage(), mle.getWrappedException());
                }
                continue;
            }
            if (node.getNodeName().equals("attributelists")) {
                try {
                    this.addAttributeList((Element)node, md);
                }
                catch (JAMSException mle) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, mle.getMessage(), mle.getWrappedException());
                }
                continue;
            }
            if (!node.getNodeName().equals("var") || !(element = (Element)node).getAttribute("name").equals("workspaceDirectory")) continue;
            md.setWorkspacePath(element.getAttribute("value"));
        }
        if (processEditors && (launcherNode = (Element)docRoot.getElementsByTagName("launcher").item(0)) != null) {
            md.setModelParameters(launcherNode);
        }
        Node dataStoreNode = docRoot.getElementsByTagName("datastores").item(0);
        md.initDatastores(dataStoreNode);
        Node metaProcessorNode = docRoot.getElementsByTagName("preprocessors").item(0);
        md.initPreprocessors(metaProcessorNode);
        return md;
    }

    private ModelNode getSubTree(Element rootElement, ModelDescriptor md) {
        ModelNode rootNode;
        block15: {
            String type;
            String version;
            String componentName;
            boolean enabled;
            Class<?> clazz;
            block14: {
                clazz = null;
                rootNode = null;
                enabled = true;
                componentName = rootElement.getAttribute("name");
                String className = rootElement.getAttribute("class");
                version = rootElement.hasAttribute("version") ? rootElement.getAttribute("version") : "1.0_0";
                if (rootElement.hasAttribute("enabled")) {
                    enabled = Boolean.parseBoolean(rootElement.getAttribute("enabled"));
                }
                try {
                    clazz = this.loader.loadClass(className);
                }
                catch (ClassNotFoundException cnfe) {
                    throw new JAMSException(JAMS.i18n("Could_not_load_component") + componentName + "\" (" + className + "). " + JAMS.i18n("Please_fix_the_model_definition_file!"), (Throwable)cnfe);
                }
                catch (NoClassDefFoundError ncdfe) {
                    throw new JAMSException(JAMS.i18n("Could_not_load_component") + componentName + "\" (" + className + "). " + JAMS.i18n("Please_fix_the_model_definition_file!"), (Throwable)ncdfe);
                }
                catch (UnsupportedClassVersionError ucve) {
                    throw new JAMSException(MessageFormat.format(JAMS.i18n("ClassVersionErrorWhileLoadingComponentLib"), className), (Throwable)ucve);
                }
                catch (Throwable t) {
                    throw new JAMSException(t.getMessage(), t);
                }
                type = rootElement.getNodeName();
                if (!type.equals("component")) break block14;
                ComponentDescriptor cd = new ComponentDescriptor(componentName, clazz, version, md);
                cd.setEnabled(enabled);
                rootNode = this.nodeFactory.createNode(cd);
                rootNode.setType(0);
                NodeList varChilds = rootElement.getElementsByTagName("var");
                for (int index = 0; index < varChilds.getLength(); ++index) {
                    try {
                        this.setVar(cd, (Element)varChilds.item(index), md);
                        continue;
                    }
                    catch (JAMSException ex) {
                        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, ex.getMessage(), ex.getWrappedException());
                    }
                }
                break block15;
            }
            if (!type.equals("contextcomponent")) break block15;
            ContextDescriptor cd = new ContextDescriptor(componentName, clazz, version, md);
            cd.setEnabled(enabled);
            rootNode = this.nodeFactory.createNode(cd);
            rootNode.setType(1);
            NodeList children = rootElement.getChildNodes();
            for (int index = 0; index < children.getLength(); ++index) {
                Node node = children.item(index);
                try {
                    if (node.getNodeName().equals("contextcomponent") || node.getNodeName().equals("component")) {
                        rootNode.add(this.getSubTree((Element)children.item(index), md));
                        continue;
                    }
                    if (node.getNodeName().equals("var")) {
                        this.setVar(cd, (Element)node, md);
                        continue;
                    }
                    if (!node.getNodeName().equals("attribute")) continue;
                    this.addContextAttribute(cd, (Element)node);
                    continue;
                }
                catch (JAMSException mle) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, mle.getMessage(), mle.getWrappedException());
                }
            }
        }
        return rootNode;
    }

    private void setVar(ComponentDescriptor cd, Element e, ModelDescriptor md) {
        String fieldName = e.getAttribute("name");
        ComponentField field = cd.getComponentFields().get(fieldName);
        if (field == null) {
            throw new JAMSException(JAMS.i18n("Error_while_loading_component_") + cd.getInstanceName() + JAMS.i18n("_component_attribute_") + fieldName + JAMS.i18n("_does_not_exist!"));
        }
        if (e.hasAttribute("attribute") || e.hasAttribute("attributelist")) {
            ContextDescriptor context;
            String contextName = e.getAttribute("context");
            if (contextName.equals("")) {
                contextName = this.modelName;
            }
            if ((context = (ContextDescriptor)md.getComponentDescriptor(contextName)) == null) {
                throw new JAMSException(JAMS.i18n("Error_while_loading_component_") + cd.getInstanceName() + JAMS.i18n("_context_") + contextName + JAMS.i18n("_does_not_exist!"));
            }
            if (e.hasAttribute("attributelist")) {
                String attributeList = e.getAttribute("attributelist");
                AttributeList aList = md.getAttributeLists().get(attributeList);
                if (aList == null) {
                    throw new JAMSException(MessageFormat.format(JAMS.i18n("Error_while_loading_component_{0}:_attributelist_{1}_does_not_exist!"), cd.getInstanceName(), attributeList));
                }
                field.linkToAttributeList(context, aList);
            } else {
                String attribute = e.getAttribute("attribute");
                field.linkToAttribute(context, attribute);
            }
        } else if (e.hasAttribute("value")) {
            field.setValue(e.getAttribute("value"));
        }
    }

    private void addAttributeList(Element e, ModelDescriptor md) {
        NodeList listElements = e.getElementsByTagName("attributelist");
        for (int i = 0; i < listElements.getLength(); ++i) {
            Class<?> type;
            Element listElement = (Element)listElements.item(i);
            String listName = listElement.getAttribute("name");
            String elementClass = listElement.getAttribute("elementclass");
            try {
                type = Class.forName(elementClass);
            }
            catch (ClassNotFoundException ex) {
                throw new JAMSException("Given type " + elementClass + " for attribute list " + listName + " does not exist!", (Throwable)ex);
            }
            NodeList elements = listElement.getElementsByTagName("element");
            for (int j = 0; j < elements.getLength(); ++j) {
                Element element = (Element)elements.item(j);
                md.addToAttributeList(listName, type, element.getAttribute("value"));
            }
        }
    }

    private void addContextAttribute(ContextDescriptor cd, Element e) {
        Class type;
        String attribute = e.getAttribute("name");
        String typeName = e.getAttribute("class");
        try {
            type = Class.forName(typeName);
        }
        catch (ClassNotFoundException ex) {
            throw new JAMSException("Given type " + typeName + " for context attribute " + attribute + " in context " + cd.getInstanceName() + " does not exist!", (Throwable)ex);
        }
        if (!type.isInterface()) {
            type = DefaultDataFactory.getDataFactory().getBelongingInterface(type);
        }
        if (!type.isArray()) {
            String value = e.getAttribute("value");
            cd.addStaticAttribute(attribute, type, value);
        } else {
            String[] values;
            for (String value : values = StringTools.toArray(attribute, ";")) {
                Logger.getLogger(this.getClass().getName()).info("check addContextAttribute for array types!");
                cd.addStaticAttribute(attribute, type, value);
            }
        }
    }

    public Document getModelDocument(ModelDescriptor md) {
        Document document = null;
        ModelNode rootNode = md.getRootNode();
        if (rootNode == null) {
            return null;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
            ComponentDescriptor cd = (ComponentDescriptor)rootNode.getUserObject();
            Element rootElement = document.createElement("model");
            rootElement.setAttribute("name", cd.getInstanceName());
            rootElement.setAttribute("author", md.getAuthor());
            rootElement.setAttribute("date", md.getDate());
            rootElement.setAttribute("helpbaseurl", md.getHelpBaseUrl());
            rootElement.setAttribute("version", JAMSVersion.getInstance().getVersionString());
            document.appendChild(rootElement);
            Element element = document.createElement("description");
            element.appendChild(document.createCDATASection(md.getDescription()));
            rootElement.appendChild(element);
            element = document.createElement("var");
            element.setAttribute("name", "workspaceDirectory");
            element.setAttribute("value", md.getWorkspacePath());
            rootElement.appendChild(element);
            element = document.createElement("launcher");
            for (String group : md.getModelProperties().getGroupNames()) {
                Element groupElement = document.createElement("group");
                groupElement.setAttribute("name", group);
                ArrayList<Object> properties = md.getModelProperties().getGroup(group).getProperties();
                if (properties != null) {
                    for (Object modelProperty : properties) {
                        if (modelProperty instanceof ModelProperties.ModelProperty) {
                            ModelProperties.ModelProperty property = (ModelProperties.ModelProperty)modelProperty;
                            Element propertyElement = this.createPropertyElement(document, property);
                            groupElement.appendChild(propertyElement);
                        }
                        if (!(modelProperty instanceof ModelProperties.Group)) continue;
                        ModelProperties.Group subgroup = (ModelProperties.Group)modelProperty;
                        Element subgroupElement = document.createElement("subgroup");
                        subgroupElement.setAttribute("name", subgroup.getCanonicalName());
                        HelpComponent helpComponent = subgroup.getHelpComponent();
                        if (!helpComponent.isEmpty()) {
                            Element helpElement = helpComponent.createDOMElement(document);
                            subgroupElement.appendChild(helpElement);
                        }
                        ArrayList<Object> subgroupProperties = subgroup.getProperties();
                        for (int k = 0; k < subgroupProperties.size(); ++k) {
                            Object subgroupProperty = subgroupProperties.get(k);
                            if (!(subgroupProperty instanceof ModelProperties.ModelProperty)) continue;
                            ModelProperties.ModelProperty property = (ModelProperties.ModelProperty)subgroupProperty;
                            Element propertyElement = this.createPropertyElement(document, property);
                            subgroupElement.appendChild(propertyElement);
                        }
                        groupElement.appendChild(subgroupElement);
                    }
                }
                element.appendChild(groupElement);
            }
            rootElement.appendChild(element);
            element = document.createElement("datastores");
            for (OutputDSDescriptor ds : md.getDatastores().values()) {
                Document outputDSDoc = ds.createDocument();
                element.appendChild(document.importNode(outputDSDoc.getDocumentElement(), true));
            }
            rootElement.appendChild(element);
            element = document.createElement("preprocessors");
            for (MetaProcessorDescriptor mpd : md.getPreprocessors()) {
                Document mpdDoc = mpd.createDocument();
                element.appendChild(document.importNode(mpdDoc.getDocumentElement(), true));
            }
            rootElement.appendChild(element);
            element = document.createElement("attributelists");
            for (String name : md.getAttributeLists().keySet()) {
                AttributeList l = md.getAttributeLists().get(name);
                Element listElement = document.createElement("attributelist");
                listElement.setAttribute("name", name);
                listElement.setAttribute("elementclass", l.getType().getName());
                for (String elementString : l.getElements()) {
                    Element elementElement = document.createElement("element");
                    elementElement.setAttribute("value", elementString);
                    listElement.appendChild(elementElement);
                }
                element.appendChild(listElement);
            }
            rootElement.appendChild(element);
            if (cd instanceof ContextDescriptor) {
                ContextDescriptor context = (ContextDescriptor)cd;
                for (ContextAttribute attribute : context.getStaticAttributes().values()) {
                    element = document.createElement("attribute");
                    element.setAttribute("name", attribute.getName());
                    element.setAttribute("class", attribute.getType().getName());
                    element.setAttribute("value", attribute.getValue());
                    rootElement.appendChild(element);
                }
            }
            int childCount = rootNode.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                rootElement.appendChild(this.getSubDoc((ModelNode)rootNode.getChildAt(i), document));
            }
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        return document;
    }

    private Element createPropertyElement(Document document, ModelProperties.ModelProperty property) {
        HelpComponent helpComponent;
        Element propertyElement = document.createElement("property");
        propertyElement.setAttribute("component", property.component.getInstanceName());
        if (property.var != null) {
            propertyElement.setAttribute("attribute", property.var.getName());
            propertyElement.setAttribute("type", DefaultDataFactory.getDataFactory().getBelongingInterface(property.var.getType()).getSimpleName());
        } else if (property.attribute != null) {
            propertyElement.setAttribute("attribute", property.attribute.getName());
            propertyElement.setAttribute("type", DefaultDataFactory.getDataFactory().getBelongingInterface(property.attribute.getType()).getSimpleName());
        } else {
            propertyElement.setAttribute("attribute", "%enable%");
            propertyElement.setAttribute("type", Attribute.Boolean.class.getSimpleName());
        }
        propertyElement.setAttribute("description", property.description);
        propertyElement.setAttribute("name", property.name);
        propertyElement.setAttribute("range", "" + property.lowerBound + ";" + property.upperBound);
        if (property.length > 0) {
            propertyElement.setAttribute("length", "" + property.length);
        }
        if (!(helpComponent = property.getHelpComponent()).isEmpty()) {
            Element helpElement = helpComponent.createDOMElement(document);
            propertyElement.appendChild(helpElement);
        }
        return propertyElement;
    }

    private Element getSubDoc(ModelNode rootNode, Document document) {
        Element element;
        Element rootElement = null;
        ComponentDescriptor cd = (ComponentDescriptor)rootNode.getUserObject();
        switch (rootNode.getType()) {
            case 0: {
                rootElement = document.createElement("component");
                break;
            }
            case 1: {
                rootElement = document.createElement("contextcomponent");
                break;
            }
            case 2: {
                rootElement = document.createElement("contextcomponent");
                cd.setClazz(JAMSContext.class);
            }
        }
        rootElement.setAttribute("name", cd.getInstanceName());
        rootElement.setAttribute("class", cd.getClazz().getName().replace("jams.model.JAMSContext", "jams.components.core.Context"));
        rootElement.setAttribute("enabled", Boolean.toString(cd.isEnabled()));
        rootElement.setAttribute("version", cd.getVersion());
        if (cd instanceof ContextDescriptor) {
            ContextDescriptor context = (ContextDescriptor)cd;
            for (ContextAttribute attribute : context.getStaticAttributes().values()) {
                element = document.createElement("attribute");
                element.setAttribute("name", attribute.getName());
                element.setAttribute("class", attribute.getType().getName());
                element.setAttribute("value", attribute.getValue());
                rootElement.appendChild(element);
            }
        }
        for (ComponentField var : cd.getComponentFields().values()) {
            if (var.getValue() == null && (var.getContext() == null || var.getAttribute().equals("")) && var.getAttributeList() == null) continue;
            element = document.createElement("var");
            element.setAttribute("name", var.getName());
            if (var.getAttributeList() != null) {
                element.setAttribute("attributelist", var.getAttributeList().getName());
                element.setAttribute("context", var.getContext().getInstanceName());
            } else if (!var.getAttribute().equals("")) {
                element.setAttribute("attribute", var.getAttribute());
                element.setAttribute("context", var.getContext().getInstanceName());
            }
            if (var.getValue() != null) {
                element.setAttribute("value", var.getValue());
            }
            rootElement.appendChild(element);
        }
        if (rootNode.getType() == 1 || rootNode.getType() == 2) {
            int childCount = rootNode.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                rootElement.appendChild(this.getSubDoc((ModelNode)rootNode.getChildAt(i), document));
            }
        }
        return rootElement;
    }
}

