/*
 * Decompiled with CFR 0.152.
 */
package jams.dataaccess;

import com.vividsolutions.jts.geom.Geometry;
import jams.JAMS;
import jams.data.Attribute;
import jams.data.DataFactory;
import jams.data.JAMSData;
import jams.dataaccess.DataAccessor;

public class GeometryAccessor
implements DataAccessor {
    Attribute.Geometry componentObject;
    Attribute.Geometry[] entityObject;
    int index;
    int accessType;
    int updateType;

    public GeometryAccessor(DataFactory dataFactory, Attribute.Entity[] entities, JAMSData dataObject, String attributeName, int accessType, int updateType) throws Attribute.Entity.NoSuchAttributeException {
        this.entityObject = new Attribute.Geometry[entities.length];
        for (int i = 0; i < entities.length; ++i) {
            if (entities[i].existsAttribute(attributeName)) {
                try {
                    this.entityObject[i] = (Attribute.Geometry)entities[i].getObject(attributeName);
                }
                catch (Attribute.Entity.NoSuchAttributeException noSuchAttributeException) {}
                continue;
            }
            if (accessType != 0) {
                this.entityObject[i] = dataFactory.createGeometry();
                entities[i].setObject(attributeName, (Object)this.entityObject[i]);
                continue;
            }
            throw new Attribute.Entity.NoSuchAttributeException(JAMS.i18n("Attribute_") + attributeName + JAMS.i18n("_does_not_exist!"));
        }
        this.accessType = accessType;
        this.updateType = updateType;
        this.componentObject = (Attribute.Geometry)dataObject;
    }

    public void initEntityData() {
        for (Attribute.Geometry v : this.entityObject) {
            if (this.componentObject.getValue() == null) continue;
            v.setValue((Geometry)this.componentObject.getValue().clone());
        }
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void read() {
        this.componentObject.setValue(this.entityObject[this.index].getValue());
    }

    public void write() {
        this.entityObject[this.index].setValue(this.componentObject.getValue());
    }

    public int getAccessType() {
        return this.accessType;
    }

    public int getUpdateType() {
        return this.updateType;
    }

    public JAMSData getComponentObject() {
        return this.componentObject;
    }
}

