/*
 * Decompiled with CFR 0.152.
 */
package optas.sampler;

import jams.JAMS;
import jams.model.JAMSComponentDescription;
import optas.core.ObjectiveAchievedException;
import optas.core.SampleLimitException;
import optas.optimizer.Optimizer;
import optas.optimizer.OptimizerLibrary;
import optas.optimizer.management.OptimizerDescription;
import optas.optimizer.management.SampleFactory;

@JAMSComponentDescription(title="Random Sampler", author="Christian Fischer", description="Performs a random search")
public class LatinHyperCubeSampler
extends Optimizer {
    public SampleFactory.Sample[] initialSimplex = null;
    int[][] availableIndexSet;
    int divisions = 0;
    int freeIndexCount = 0;

    @Override
    public OptimizerDescription getDescription() {
        OptimizerDescription desc = OptimizerLibrary.getDefaultOptimizerDescription(LatinHyperCubeSampler.class.getSimpleName(), LatinHyperCubeSampler.class.getName(), 250, true);
        return desc;
    }

    void initIndexSet() {
        this.availableIndexSet = new int[this.n][this.divisions];
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.divisions; ++j) {
                this.availableIndexSet[i][j] = j;
            }
        }
        this.freeIndexCount = this.divisions;
    }

    int[] getFreeIndexSet() {
        if (this.freeIndexCount <= 0) {
            return null;
        }
        int[] indexSet = new int[this.n];
        for (int i = 0; i < this.n; ++i) {
            int index = generator.nextInt(this.freeIndexCount);
            indexSet[i] = this.availableIndexSet[i][index];
            this.availableIndexSet[i][index] = this.availableIndexSet[i][this.freeIndexCount - 1];
        }
        --this.freeIndexCount;
        return indexSet;
    }

    @Override
    public void procedure() {
        this.divisions = (int)this.getMaxn();
        this.initIndexSet();
        double[] d = new double[this.n];
        for (int j = 0; j < this.n; ++j) {
            d[j] = this.upBound[j] - this.lowBound[j];
        }
        SampleFactory.Sample[] simplex = new SampleFactory.Sample[this.divisions];
        for (int i = 0; i < this.divisions; ++i) {
            int[] indexSet = this.getFreeIndexSet();
            double[] sample = new double[this.n];
            for (int j = 0; j < this.n; ++j) {
                sample[j] = ((double)indexSet[j] + 0.5) * (d[j] / (double)this.divisions) + this.lowBound[j];
            }
            try {
                simplex[i] = this.getSample(sample);
                continue;
            }
            catch (SampleLimitException e) {
                break;
            }
            catch (ObjectiveAchievedException e) {
                break;
            }
        }
        this.log("*********************************************************");
        this.log(JAMS.i18n((String)"Maximum_number_of_iterations_reached_finished_optimization"));
        this.log("*********************************************************");
    }
}

