/*
 * Decompiled with CFR 0.152.
 */
package optas.regression.likelihood;

import Jama.Matrix;
import optas.regression.likelihood.LikelihoodFunction;

public class Gaussian
extends LikelihoodFunction {
    Mode mode = Mode.infEP;

    @Override
    public double[][] getHyperparameterRange() {
        return new double[][]{{-4.0, 4.0}};
    }

    @Override
    public int getNumberOfHyperparameters() {
        return 1;
    }

    public Matrix calc(double[] hyp, double[] y, double[] mu, double[] s2, Mode mode) {
        double sn2 = Math.exp(2.0 * hyp[0]);
        switch (mode) {
            case infLaplace: {
                return null;
            }
            case infVB: {
                return null;
            }
            case infEP: {
                int D22 = y.length;
                Matrix lZ = new Matrix(D22, 1);
                for (int i = 0; i < D22; ++i) {
                    double value = -(y[i] - mu[i]) * (y[i] - mu[i]) / (sn2 + s2[i]) / 2.0 - Math.log(Math.PI * 2 * (sn2 + s2[i])) / 2.0;
                    lZ.set(i, 0, value);
                }
                return lZ;
            }
        }
        return null;
    }

    @Override
    public Matrix[] calc(double[] hyp, double[] y, double[] mu, double[] s2) {
        double sn2 = Math.exp(2.0 * hyp[0]);
        boolean s2zero = false;
        if (y == null) {
            y = new double[mu.length];
        }
        if (s2zero) {
            return null;
        }
        Matrix lp = this.calc(hyp, y, mu, s2, Mode.infEP);
        Matrix ymu = new Matrix(mu, 1);
        Matrix ys2 = new Matrix(s2, 1);
        for (int i = 0; i < s2.length; ++i) {
            ys2.set(0, i, s2[i] + sn2);
        }
        return new Matrix[]{lp, ymu, ys2};
    }

    public String toString() {
        return "Gaussian";
    }

    static enum Mode {
        infLaplace,
        infEP,
        infVB;

    }
}

