/*
 * Decompiled with CFR 0.152.
 */
package optas.regression;

import java.util.TreeSet;
import optas.data.SimpleEnsemble;
import optas.tools.ObservableProgress;

public abstract class Interpolation
extends ObservableProgress {
    protected SimpleEnsemble[] x;
    double[] xRange;
    double[] xMin;
    protected int L = 0;
    protected boolean initSuccessful = false;

    protected abstract double[] normalizeX(double[] var1);

    protected abstract double[] normalizeY(double[] var1);

    protected abstract double[] denormalizeX(double[] var1);

    protected abstract double[] denormalizeY(double[] var1);

    protected abstract int getN();

    protected abstract int getM();

    public abstract double getYData(int var1, int var2);

    public double init() {
        return 0.0;
    }

    protected double[] getX(int id) {
        double[] row = new double[this.getN()];
        for (int i = 0; i < this.getN(); ++i) {
            row[i] = this.x[i].getValue(id);
        }
        return row;
    }

    protected abstract double[][] getInterpolatedValue(TreeSet<Integer> var1);

    public abstract double[] getInterpolatedValue(double[] var1);

    private double[] calcDifference(ErrorMethod e, double[][] sim, double[][] obs) {
        this.log("Calculating " + (Object)((Object)e) + " Interpolation Error");
        int K = sim[0].length;
        double[] error = new double[this.getM()];
        switch (e) {
            case ABSE: {
                int i;
                int j;
                for (j = 0; j < this.getM(); ++j) {
                    for (i = 0; i < K; ++i) {
                        int n = j;
                        error[n] = error[n] + Math.abs(sim[j][i] - obs[j][i]) / (double)K;
                    }
                }
            }
            case RMSE: {
                int i;
                int j;
                for (j = 0; j < this.getM(); ++j) {
                    for (i = 0; i < K; ++i) {
                        int n = j;
                        error[n] = error[n] + (sim[j][i] - obs[j][i]) * (sim[j][i] - obs[j][i]);
                    }
                    error[j] = Math.sqrt(error[j] / (double)K);
                }
            }
            case E2: {
                int j;
                for (j = 0; j < this.getM(); ++j) {
                    double aobs = 0.0;
                    for (int i = 0; i < K; ++i) {
                        aobs += obs[j][i];
                    }
                    aobs /= (double)K;
                    double numerator = 0.0;
                    double denumerator = 0.0;
                    for (int i = 0; i < K; ++i) {
                        numerator += (sim[j][i] - obs[j][i]) * (sim[j][i] - obs[j][i]);
                        denumerator += (obs[j][i] - aobs) * (obs[j][i] - aobs);
                    }
                    if (numerator == Double.NaN || denumerator == 0.0 || denumerator == Double.NaN) continue;
                    error[j] = 1.0 - numerator / denumerator;
                }
                return error;
            }
        }
        return null;
    }

    protected void calculate() {
    }

    public double[] estimateCrossValidationError(int K, ErrorMethod e) {
        int j;
        this.log("Estimating Cross Validation Error");
        this.setProgress(0.0);
        double[][] obs = new double[this.getM()][this.L];
        double[][] sim = new double[this.getM()][this.L];
        this.calculate();
        for (int k = 0; k < K; ++k) {
            int i;
            this.log("Cross Validation " + k + " of " + K);
            int indexStart = k * (this.L / K);
            int indexEnd = Math.min((k + 1) * (this.L / K), this.L);
            int size = indexEnd - indexStart;
            if (size == 0) continue;
            TreeSet<Integer> validationSet = new TreeSet<Integer>();
            double[][] validation = new double[size][this.getM()];
            for (int j2 = indexStart; j2 < indexEnd; ++j2) {
                int id_loi = this.x[0].getId(j2);
                validationSet.add(id_loi);
                for (i = 0; i < this.getM(); ++i) {
                    validation[j2 - indexStart][i] = this.getYData(id_loi, i);
                }
            }
            double[][] y_star = this.getInterpolatedValue(validationSet);
            for (j = 0; j < size; ++j) {
                for (i = 0; i < this.getM(); ++i) {
                    obs[i][indexStart + j] = validation[j][i];
                    sim[i][indexStart + j] = y_star[j][i];
                }
            }
        }
        double[] NSE = this.calcDifference(e, sim, obs);
        double maxAbsErr = 0.0;
        double maxRelErr = 0.0;
        double mean_obs = 0.0;
        for (j = 0; j < this.L; ++j) {
            mean_obs += obs[0][1];
        }
        mean_obs /= (double)this.L;
        for (int i = 0; i < this.L; ++i) {
            maxAbsErr = Math.max(maxAbsErr, Math.abs(sim[0][i] - obs[0][i]));
            maxRelErr = Math.max(maxRelErr, Math.abs(sim[0][i] - obs[0][i]) / mean_obs);
        }
        System.out.println("Crossvalidation errors (only first criteria: ");
        System.out.println("NSE: " + NSE[0]);
        System.out.println("max abs. error: " + maxAbsErr);
        System.out.println("max rel. error: " + maxRelErr);
        return NSE;
    }

    public double[] estimateLOOError(ErrorMethod e) {
        return this.estimateCrossValidationError(this.L, e);
    }

    public static enum ErrorMethod {
        ABSE,
        RMSE,
        E2;

    }
}

