/*
 * Decompiled with CFR 0.152.
 */
package optas.optimizer.directsearch;

import Jama.Matrix;
import java.util.Arrays;
import java.util.Random;
import java.util.Vector;
import optas.core.ObjectiveAchievedException;
import optas.core.SampleLimitException;
import optas.optimizer.LinearConstraintDirectPatternSearch;
import optas.optimizer.Optimizer;
import optas.optimizer.directsearch.PatternSearch;
import optas.optimizer.management.SampleFactory;

public class MDS
extends PatternSearch {
    @Override
    public SampleFactory.SampleSO step(Optimizer context, SampleFactory.SampleSO[] Simplex, Matrix LinearConstraintMatrixA, Matrix LinearConstraintVectorb, double[] lowBound, double[] upBound) throws SampleLimitException, ObjectiveAchievedException {
        if (Generator == null) {
            Generator = new Random();
        }
        Arrays.sort(Simplex, new SampleFactory.SampleSOComperator(false));
        boolean ns = false;
        int n = Simplex[0].x.length;
        int m = Simplex.length;
        double mu_e = 2.0;
        double mu_c = 0.5;
        LinearConstraintDirectPatternSearch LCDPS = new LinearConstraintDirectPatternSearch();
        if (LinearConstraintMatrixA != null & LinearConstraintVectorb != null) {
            LCDPS.SetLinearConstraints(LinearConstraintMatrixA, LinearConstraintVectorb);
        }
        Matrix P = new Matrix(n, m - 1);
        for (int j = 1; j < m; ++j) {
            for (int i = 0; i < n; ++i) {
                P.set(i, j - 1, Simplex[0].x[i] - Simplex[j].x[i]);
            }
        }
        Vector<Matrix> P_i = LCDPS.UpdateDirections(Simplex[0], P, 1.0);
        Matrix x0 = new Matrix(Simplex[0].x, n);
        boolean successful = false;
        SampleFactory.SampleSO best = Simplex[0];
        SampleFactory.SampleSO[] reflection = new SampleFactory.SampleSO[m - 1];
        for (int i = 0; i < m - 1; ++i) {
            Matrix d = P.getMatrix(0, n - 1, i, i);
            Matrix x_new = x0.plus(d);
            if (i >= m - 1) continue;
            reflection[i] = context.getSampleSO(x_new.getColumnPackedCopy());
            if (!(reflection[i].f() < best.f())) continue;
            successful = true;
            best = reflection[i];
        }
        if (successful) {
            int i;
            Matrix P_expand = new Matrix(n, m - 1);
            for (int j = 1; j < m; ++j) {
                for (int i2 = 0; i2 < n; ++i2) {
                    P_expand.set(i2, j - 1, -mu_e * (Simplex[j].x[i2] - Simplex[0].x[i2]));
                }
            }
            Vector<Matrix> P_i_expand = LCDPS.UpdateDirections(Simplex[0], P_expand, 1.0);
            boolean expansion_successful = false;
            SampleFactory.SampleSO[] expansion = new SampleFactory.SampleSO[m - 1];
            for (i = 0; i < m - 1; ++i) {
                Matrix d = P_expand.getMatrix(0, n - 1, i, i);
                Matrix x_new = x0.plus(d);
                if (i >= m - 1) continue;
                expansion[i] = context.getSampleSO(x_new.getColumnPackedCopy());
                if (!(expansion[i].f() < best.f())) continue;
                best = expansion[i];
                expansion_successful = true;
            }
            if (expansion_successful) {
                for (i = 0; i < m - 1; ++i) {
                    Simplex[i + 1] = expansion[i];
                }
            } else {
                for (i = 0; i < m - 1; ++i) {
                    Simplex[i + 1] = reflection[i];
                }
            }
            return Simplex[n - 1];
        }
        Matrix P_contract = new Matrix(n, m - 1);
        for (int j = 1; j < m; ++j) {
            for (int i = 0; i < n; ++i) {
                P_contract.set(i, j - 1, mu_c * (Simplex[0].x[i] - Simplex[j].x[i]));
            }
        }
        Vector<Matrix> P_i_contract = LCDPS.UpdateDirections(Simplex[0], P_contract, 1.0);
        for (int i = 0; i < m - 1; ++i) {
            Matrix d = P_contract.getMatrix(0, n - 1, i, i);
            Matrix x_new = x0.plus(d);
            SampleFactory.SampleSO sample_new = context.getSampleSO(x_new.getColumnPackedCopy());
            if (i + 1 < Simplex.length) {
                Simplex[i + 1] = sample_new;
            }
            if (!(sample_new.f() < best.f())) continue;
            best = sample_new;
        }
        return Simplex[n - 1];
    }

    @Override
    public SampleFactory.SampleSO search(Optimizer context, Matrix LinearConstraintMatrixA, Matrix LinearConstraintVectorb) {
        return null;
    }
}

