/*
 * Decompiled with CFR 0.152.
 */
package optas.optimizer;

import Jama.CholeskyDecomposition;
import Jama.Matrix;
import jams.JAMS;
import jams.model.JAMSComponentDescription;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import optas.core.ObjectiveAchievedException;
import optas.core.SampleLimitException;
import optas.optimizer.Optimizer;
import optas.optimizer.OptimizerLibrary;
import optas.optimizer.management.NumericOptimizerParameter;
import optas.optimizer.management.OptimizerDescription;
import optas.optimizer.management.SampleFactory;

@JAMSComponentDescription(title="SCEM_UA", author="Christian Fischer", description="Optimization routine SCEM_UA")
public class SCEM_UA
extends Optimizer {
    public int population;
    public int complexes;
    int q;
    int s;
    int m;
    int L;
    double gamma;
    double ndraw;

    @Override
    public OptimizerDescription getDescription() {
        OptimizerDescription desc = OptimizerLibrary.getDefaultOptimizerDescription(SCEM_UA.class.getSimpleName(), SCEM_UA.class.getName(), 500, false);
        desc.addParameter(new NumericOptimizerParameter("population", JAMS.i18n((String)"size_of_population"), 500.0, 0.0, 100000.0));
        desc.addParameter(new NumericOptimizerParameter("complexes", JAMS.i18n((String)"number_of_complexes"), 3.0, 1.0, 100.0));
        return desc;
    }

    public double getPopulation() {
        return this.population;
    }

    public void setPopulation(double population) {
        this.population = (int)population;
    }

    public double getComplexes() {
        return this.complexes;
    }

    public void setComplexes(double complexes) {
        this.complexes = (int)complexes;
    }

    private boolean isSampleValid(double[] sample) {
        for (int i = 0; i < this.n; ++i) {
            if (!(sample[i] < this.lowBound[i]) && !(sample[i] > this.upBound[i])) continue;
            return false;
        }
        return true;
    }

    public void sort(double[][] data, int col, boolean decreasing_order) {
        SCE_Comparator comparator = new SCE_Comparator(col, decreasing_order);
        Arrays.sort(data, comparator);
    }

    public double[] getMean(double[][] data) {
        double[] mean = new double[this.n];
        Arrays.fill(mean, 0.0);
        int j = 0;
        while (j < this.n) {
            for (int i = 0; i < data.length; ++i) {
                int n = j;
                mean[n] = mean[n] + data[i][j];
            }
            if (data.length == 0) {
                this.log("Complex in SCEM_UA ist leer! - Kritischer Fehler!!");
            }
            int n = j++;
            mean[n] = mean[n] / (double)data.length;
        }
        return mean;
    }

    public double[][] getCoVarMatrix(double[][] data) {
        int i;
        double[][] coV = new double[this.n][this.n];
        double[] mean = this.getMean(data);
        double vecLength = data.length;
        if (data.length == 0) {
            this.log("Complex in SCEM_UA hat nur die Gr\u00f6\u00dfe von 1! - Kritischer Fehler!!");
        }
        for (i = 0; i < this.n; ++i) {
            Arrays.fill(coV[i], 0.0);
        }
        for (i = 0; i < this.n; ++i) {
            int j = 0;
            while (j < this.n) {
                int k = 0;
                while ((double)k < vecLength) {
                    double[] dArray = coV[i];
                    int n = j;
                    dArray[n] = dArray[n] + data[k][i] * data[k][j];
                    ++k;
                }
                double[] dArray = coV[i];
                int n = j;
                dArray[n] = dArray[n] - vecLength * mean[i] * mean[j];
                double[] dArray2 = coV[i];
                int n2 = j++;
                dArray2[n2] = dArray2[n2] / (vecLength - 1.0);
            }
        }
        return coV;
    }

    public double[][] latin(int s, int n) {
        double[][] x = new double[s][n];
        for (int i = 0; i < s; ++i) {
            x[i] = this.randomSampler();
        }
        return x;
    }

    public double[] ComputeDensity(double[] x) throws SampleLimitException, ObjectiveAchievedException {
        double[] pset = new double[this.n + this.m + 1];
        for (int j = 0; j < x.length; ++j) {
            pset[j] = x[j];
        }
        SampleFactory.Sample s = this.getSample(x);
        for (int i = 0; i < this.m; ++i) {
            pset[this.n + i] = s.F()[i];
        }
        return pset;
    }

    public double[][] ComputeDensity(double[][] x) throws SampleLimitException, ObjectiveAchievedException {
        boolean e = false;
        double[][] pset = new double[x.length][this.n + this.m + 1];
        for (int i = 0; i < x.length; ++i) {
            double[] tmp = this.ComputeDensity(x[i]);
            for (int j = 0; j < this.n + this.m + 1; ++j) {
                pset[i][j] = tmp[j];
            }
        }
        return pset;
    }

    public double[][][] PartComplexes(double[][] D) {
        double[][][] C = new double[this.q][this.m][this.n + this.m + 1];
        for (int kk = 0; kk < this.q; ++kk) {
            for (int j = 0; j < this.m; ++j) {
                int idx = this.q * j + kk;
                for (int i = 0; i < this.n + this.m + 1; ++i) {
                    C[kk][j][i] = D[idx][i];
                }
            }
        }
        return C;
    }

    public void SEM(double[][] D, double[][][] C, ArrayList<ArrayList<double[]>> Sequences, double[][] x) throws SampleLimitException, ObjectiveAchievedException {
        for (int kk = 0; kk < this.q; ++kk) {
            for (int bb = 0; bb < this.L; ++bb) {
                this.OffMetro(Sequences.get(kk), C[kk], kk, bb);
            }
        }
    }

    public double[] randn(int n) {
        double[] randn = new double[n];
        for (int i = 0; i < n; ++i) {
            randn[i] = generator.nextGaussian();
        }
        return randn;
    }

    public void OffMetro(ArrayList<double[]> Seq, double[][] C, int kk, int bb) throws SampleLimitException, ObjectiveAchievedException {
        int j;
        double[] newgen;
        int s = Seq.size();
        double[] offspring = null;
        s = generator.nextInt(s);
        double[] b = Seq.get(s);
        double[][] coV = this.getCoVarMatrix(C);
        double[] mean = this.getMean(C);
        Matrix MatrixCoV = new Matrix(coV);
        CholeskyDecomposition sqrtCoV = new CholeskyDecomposition(MatrixCoV);
        double[] tmpArray = new double[this.n];
        int critical_counter = 0;
        do {
            int i;
            if (critical_counter++ > 100) {
                return;
            }
            Matrix ru = new Matrix(this.randn(this.n), this.n);
            offspring = sqrtCoV.getL().times(ru).getColumnPackedCopy();
            for (i = 0; i < this.n; ++i) {
                int n = i;
                offspring[n] = offspring[n] + b[i];
                if (!Double.isNaN(offspring[i])) continue;
                System.out.println("Fehler -> Parameter ist NaN!!");
            }
            for (i = 0; i < this.n; ++i) {
                tmpArray[i] = offspring[i];
            }
        } while (!this.isSampleValid(tmpArray));
        (newgen = this.ComputeDensity((double[])offspring))[this.m + this.n] = this.IsPointNonDominated(C, newgen);
        if ((newgen = this.ComputeDensity((double[])offspring))[this.m + this.n] != -1.0) {
            int n = this.m + this.n;
            newgen[n] = newgen[n] / (double)C.length;
        } else {
            newgen[this.m + this.n] = this.ComputeFitnessOfDominatedPoint(C, newgen);
        }
        double fitness1 = b[this.n + this.m];
        double fitness2 = newgen[this.n + this.m];
        double ratio = fitness1 / fitness2;
        ratio = Math.pow(ratio, 0.5 * fitness2);
        double Z = generator.nextDouble();
        System.out.println("newgen:");
        for (j = 0; j < this.n; ++j) {
            this.log(":" + newgen[j] + " ,");
        }
        for (j = 0; j < this.m; ++j) {
            this.log(":" + newgen[this.n + j] + " ,");
        }
        this.log("Fitness:" + newgen[this.n + this.m]);
        if (Z < ratio) {
            Seq.add(newgen);
            for (int i = 0; i < this.n + this.m + 1; ++i) {
                C[this.m - 1][i] = newgen[i];
            }
        }
    }

    public void reshuffle(double[][][] C, double[][] D) {
        int counter = 0;
        for (int qq = 0; qq < this.q; ++qq) {
            for (int ii = 0; ii < this.m; ++ii) {
                for (int j = 0; j < this.n + this.m + 1; ++j) {
                    D[counter][j] = C[qq][ii][j];
                }
                ++counter;
            }
        }
        this.ComputeFitness(D);
        this.sort(D, this.n + this.m, false);
        System.out.println("Current D:");
        for (int i = 0; i < D.length; ++i) {
            int j;
            for (j = 0; j < this.n; ++j) {
                this.log(":" + D[i][j] + " ,");
            }
            for (j = 0; j < this.m; ++j) {
                this.log(":" + D[i][this.n + j] + " ,");
            }
            this.log("Fitness:" + D[i][this.n + this.m]);
        }
    }

    public double ComputeFitnessOfDominatedPoint(double[][] D, double[] Point2) {
        Point2[this.m + this.n] = 1.00001;
        for (int j = 0; j < D.length; ++j) {
            if (D[j] == Point2 || D[j][this.m + this.n] > 1.0 || D[j][this.m + this.n] == -1.0) continue;
            boolean j_DominatesPoint = true;
            for (int k = this.n; k < this.n + this.m; ++k) {
                if (!(Point2[k] > D[j][k])) continue;
                j_DominatesPoint = false;
            }
            if (!j_DominatesPoint) continue;
            int n = this.m + this.n;
            Point2[n] = Point2[n] + D[j][this.m + this.n];
        }
        return Point2[this.m + this.n];
    }

    public int IsPointNonDominated(double[][] D, double[] Point2) {
        int domCount = 0;
        boolean PointIsDominated = false;
        for (int j = 0; j < D.length; ++j) {
            if (D[j] == Point2) continue;
            boolean j_DominatesPoint = true;
            boolean PointDominates_j = true;
            for (int k = this.n; k < this.n + this.m; ++k) {
                if (Point2[k] > D[j][k]) {
                    j_DominatesPoint = false;
                }
                if (!(Point2[k] < D[j][k])) continue;
                PointDominates_j = false;
            }
            if (j_DominatesPoint) {
                PointIsDominated = true;
                break;
            }
            if (!PointDominates_j) continue;
            ++domCount;
        }
        if (PointIsDominated) {
            return -1;
        }
        return domCount;
    }

    public void ComputeFitness(double[][] D) {
        int i;
        for (i = 0; i < D.length; ++i) {
            D[i][this.m + this.n] = -1.0;
        }
        for (i = 0; i < D.length; ++i) {
            int numOfDominatedPoints = this.IsPointNonDominated(D, D[i]);
            if (numOfDominatedPoints == -1) continue;
            D[i][this.m + this.n] = (double)numOfDominatedPoints / (double)D.length;
        }
        for (i = 0; i < D.length; ++i) {
            if (D[i][this.m + this.n] != -1.0) continue;
            D[i][this.m + this.n] = this.ComputeFitnessOfDominatedPoint(D, D[i]);
        }
        for (i = 0; i < D.length; ++i) {
            if (D[i][this.m + this.n] != -1.0) continue;
            D[i][this.m + this.n] = 1.0;
        }
    }

    @Override
    public void procedure() throws SampleLimitException, ObjectiveAchievedException {
        this.q = (int)this.getComplexes();
        this.s = (int)this.getPopulation();
        this.s = this.s / this.q * this.q;
        this.m = this.s / this.q;
        this.L = Math.max(1, this.m / 5);
        double[][] D = new double[this.s][this.n + this.m + 1];
        ArrayList<ArrayList<double[]>> Sequences = new ArrayList<ArrayList<double[]>>();
        double[][] x = new double[this.s][this.n];
        x = this.latin(this.s, this.n);
        D = this.ComputeDensity(x);
        this.ComputeFitness(D);
        this.sort(D, this.m + this.n, false);
        for (int i = 0; i < this.q; ++i) {
            ArrayList<double[]> Sequence_k = new ArrayList<double[]>();
            double[] extX = new double[this.n + this.m + 1];
            for (int j = 0; j < this.n + this.m + 1; ++j) {
                extX[j] = D[i][j];
            }
            Sequence_k.add(extX);
            Sequences.add(Sequence_k);
        }
        int converged = -1;
        int convergence = 2;
        int iter = 0;
        while ((double)iter < this.getMaxn()) {
            double[][][] C = this.PartComplexes(D);
            this.SEM(D, C, Sequences, x);
            this.reshuffle(C, D);
            ++iter;
        }
    }

    public class SCE_Comparator
    implements Comparator {
        private int col = 0;
        private int order = 1;

        public SCE_Comparator(int col, boolean decreasing_order) {
            this.col = col;
            this.order = decreasing_order ? -1 : 1;
        }

        public int compare(Object d1, Object d2) {
            double[] b1 = (double[])d1;
            double[] b2 = (double[])d2;
            if (b1[this.col] < b2[this.col]) {
                return -1 * this.order;
            }
            if (b1[this.col] == b2[this.col]) {
                return 0 * this.order;
            }
            return 1 * this.order;
        }
    }
}

