/*
 * Decompiled with CFR 0.152.
 */
package optas.optimizer;

import jams.JAMS;
import jams.runtime.JAMSRuntime;
import java.util.Set;
import java.util.TreeSet;
import optas.optimizer.BranchAndBound;
import optas.optimizer.DREAM;
import optas.optimizer.Direct;
import optas.optimizer.MOCOM;
import optas.optimizer.NSGA2;
import optas.optimizer.NelderMead;
import optas.optimizer.Optimizer;
import optas.optimizer.SCE;
import optas.optimizer.management.NumericOptimizerParameter;
import optas.optimizer.management.OptimizerDescription;
import optas.sampler.HaltonSequence;
import optas.sampler.LatinHyperCubeSampler;
import optas.sampler.RandomSampler;
import optas.sampler.SobolsSequence;

public class OptimizerLibrary {
    static Set<Optimizer> optimizerPool = new TreeSet<Optimizer>();

    public static void register(Optimizer clazz) {
        if (clazz instanceof Optimizer) {
            optimizerPool.add(clazz);
        }
    }

    public static Set<Optimizer> getAvailableOptimizer() {
        optimizerPool.clear();
        optimizerPool.add(new Direct());
        optimizerPool.add(new SCE());
        optimizerPool.add(new BranchAndBound());
        optimizerPool.add(new DREAM());
        optimizerPool.add(new LatinHyperCubeSampler());
        optimizerPool.add(new MOCOM());
        optimizerPool.add(new NSGA2());
        optimizerPool.add(new NelderMead());
        optimizerPool.add(new RandomSampler());
        optimizerPool.add(new SobolsSequence());
        optimizerPool.add(new HaltonSequence());
        return optimizerPool;
    }

    public static Optimizer getDefaultOptimizer() {
        return new Direct();
    }

    public static OptimizerDescription getDefaultOptimizerDescription(String shortName, String className, int id, boolean multiObj) {
        OptimizerDescription defDesc = new OptimizerDescription(shortName, id, multiObj);
        defDesc.setOptimizerClassName(className);
        defDesc.addParameter(new NumericOptimizerParameter("maxn", JAMS.i18n((String)"maximum_number_of_iterations"), 500.0, 1.0, 100000.0));
        return defDesc;
    }

    public static Optimizer loadOptimizer(ClassLoader cl, String name) {
        Class<?> optimizerClass = null;
        Object objOptimizer = null;
        try {
            optimizerClass = cl.loadClass(name);
            objOptimizer = optimizerClass.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            System.out.println("could not find optimizer class, " + name);
            cnfe.printStackTrace();
            return null;
        }
        catch (InstantiationException ie) {
            System.out.println("could not instantiate optimizer class, " + name);
            ie.printStackTrace();
            return null;
        }
        catch (IllegalAccessException ie) {
            System.out.println("could not instantiate optimizer class, " + name);
            ie.printStackTrace();
            return null;
        }
        if (!(objOptimizer instanceof Optimizer)) {
            System.out.println("class " + name + " is not assignable of optas.Optimizer!");
            return null;
        }
        return objOptimizer;
    }

    public static Optimizer getOptimizer(String className) {
        for (Optimizer o : OptimizerLibrary.getAvailableOptimizer()) {
            if (!o.getDescription().getOptimizerClassName().equals(className)) continue;
            return o;
        }
        return null;
    }

    public static Optimizer loadOptimizer(JAMSRuntime rt, String name) {
        Class<?> optimizerClass = null;
        Object objOptimizer = null;
        try {
            optimizerClass = rt.getClassLoader().loadClass(name);
            objOptimizer = optimizerClass.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            rt.sendHalt("could not find optimizer class, " + name);
            cnfe.printStackTrace();
            return null;
        }
        catch (InstantiationException ie) {
            rt.sendHalt("could not instantiate optimizer class, " + name);
            ie.printStackTrace();
            return null;
        }
        catch (IllegalAccessException ie) {
            rt.sendHalt("could not instantiate optimizer class, " + name);
            ie.printStackTrace();
            return null;
        }
        if (!(objOptimizer instanceof Optimizer)) {
            rt.sendHalt("class " + name + " is not assignable of optas.Optimizer!");
            return null;
        }
        return objOptimizer;
    }
}

