/*
 * Decompiled with CFR 0.152.
 */
package optas.hydro.calculations;

import java.util.ArrayList;
import java.util.TreeSet;
import optas.data.TimeSerie;
import optas.hydro.calculations.BaseFlow;
import optas.hydro.calculations.HydrographSection;
import optas.hydro.calculations.Peak;

public class HydrographEvent
implements Comparable {
    HydrographSection raisingEdge;
    Peak peak;
    HydrographSection fallingEdge;
    double width;
    double height;
    double heightAboveGround;
    double triangeShapeIndex;
    double quality;
    boolean isEvent;

    public HydrographEvent(HydrographSection raisingEdge, Peak peak, HydrographSection fallingEdge) {
        this.fallingEdge = fallingEdge;
        this.peak = peak;
        this.raisingEdge = raisingEdge;
        this.isEvent = raisingEdge.value.isEmpty() || fallingEdge.value.isEmpty() ? false : this.calcEventProperties();
    }

    public boolean isEvent() {
        return this.isEvent;
    }

    private boolean calcEventProperties() {
        int endIndex = this.fallingEdge.endIndex;
        int startIndex = this.raisingEdge.startIndex;
        if (endIndex - startIndex <= 2) {
            return false;
        }
        double lbx = startIndex;
        double lby = this.raisingEdge.at(startIndex);
        double rbx = this.fallingEdge.endIndex - 1;
        double rby = this.fallingEdge.at(endIndex - 1);
        double tx = this.peak.index;
        double ty = this.peak.value;
        double q1 = 0.0;
        for (int i = startIndex; i < endIndex; ++i) {
            double y = HydrographEvent.triangleFunction(lbx, lby, rbx, rby, tx, ty, i);
            double ystar = 0.0;
            if (i < this.peak.index) {
                ystar = this.raisingEdge.at(i);
            } else if (i > this.peak.index) {
                ystar = this.fallingEdge.at(i);
            }
            if (Double.isNaN(y) || Double.isInfinite(y) || ystar == 0.0) continue;
            q1 += Math.abs(y - ystar) / ystar;
        }
        q1 /= rbx - lbx;
        double q2 = ty / (0.5 * (lby + rby));
        if (q2 < 1.3) {
            return false;
        }
        this.width = endIndex - startIndex;
        this.height = this.peak.value;
        this.heightAboveGround = q2;
        this.triangeShapeIndex = 1.0 - q1;
        this.quality = this.height * this.heightAboveGround * Math.max(Math.min(Math.exp(this.triangeShapeIndex), 0.33), 3.0);
        return true;
    }

    public double getQuality() {
        return this.quality;
    }

    public HydrographSection getRaisingEdge() {
        return this.raisingEdge;
    }

    public HydrographSection getFallingEdge() {
        return this.fallingEdge;
    }

    public Peak getPeak() {
        return this.peak;
    }

    public int compareTo(Object obj) {
        if (obj instanceof HydrographEvent) {
            double q2;
            HydrographEvent p2 = (HydrographEvent)obj;
            double q1 = this.getQuality();
            if (q1 < (q2 = p2.getQuality())) {
                return 1;
            }
            if (q1 > q2) {
                return -1;
            }
            return 0;
        }
        return 0;
    }

    private static double triangleFunction(double lbx, double lby, double rbx, double rby, double tx, double ty, double x) {
        if (x < lbx) {
            return 0.0;
        }
        if (x > rbx) {
            return 0.0;
        }
        if (lbx > rbx || lbx > tx || tx > rbx) {
            return 0.0;
        }
        if (x < tx) {
            double w1 = x - lbx;
            double w2 = tx - x;
            double w = w1 + w2;
            return (w2 * lby + w1 * ty) / w;
        }
        double w1 = rbx - tx;
        double w2 = Math.exp(x - tx);
        double w = w1 + w2;
        return (w2 * rby + w1 * ty) / w;
    }

    private static HydrographEvent isEvent(int evtStart, int evtEnd, TimeSerie hydrograph) {
        if (evtEnd - evtStart < 2) {
            return null;
        }
        int peak = 0;
        double peakValue = 0.0;
        for (int i = evtStart; i < evtEnd; ++i) {
            if (!(hydrograph.getValue(i) > peakValue)) continue;
            peakValue = hydrograph.getValue(i);
            peak = i;
        }
        HydrographEvent event = new HydrographEvent(new HydrographSection(evtStart, peak, hydrograph), new Peak(peak, peakValue), new HydrographSection(peak, evtEnd, hydrograph));
        if (event.isEvent()) {
            return event;
        }
        return null;
    }

    public static ArrayList<HydrographEvent> findEvents(TimeSerie hydrograph, int windowSize) {
        TreeSet<HydrographEvent> eventList = new TreeSet<HydrographEvent>();
        long n = hydrograph.getTimeDomain().getNumberOfTimesteps();
        double[] baseFlow = BaseFlow.groundwaterWindowMethod(hydrograph, windowSize);
        int eventStart = 0;
        int eventEnd = 0;
        for (int i = 0; i < (int)n; ++i) {
            double vB;
            double vF = hydrograph.getValue(i);
            if (!(Math.abs(1.0 - vF / (vB = baseFlow[i])) < 0.05)) continue;
            eventEnd = i;
            HydrographEvent e = HydrographEvent.isEvent(eventStart, eventEnd, hydrograph);
            if (e != null) {
                eventList.add(e);
            }
            eventStart = i;
        }
        return new ArrayList<HydrographEvent>(eventList);
    }
}

