/*
 * Decompiled with CFR 0.152.
 */
package optas.hydro;

import optas.data.SimpleEnsemble;
import optas.hydro.Identifiable;

public class ParameterGroup
implements Identifiable {
    int[] stack = null;
    double[] w = null;
    int size = 0;
    long key = 0L;
    static int counter = 0;
    int id;
    SimpleEnsemble[] parameterIDs;

    @Override
    public int getID() {
        return this.id;
    }

    private void init(int n) {
        if (this.stack == null || this.stack.length != n) {
            this.stack = new int[n];
        }
        this.key = 0L;
        this.w = null;
        this.size = 0;
    }

    private void reset() {
        for (int i = 0; i < this.stack.length; ++i) {
            this.add(i);
        }
    }

    private void init(ParameterGroup p, boolean reset) {
        this.init(p.stack.length);
        this.size = 0;
        this.parameterIDs = p.parameterIDs;
        this.w = p.w;
        if (!reset) {
            for (int i = 0; i < p.size; ++i) {
                this.add(p.get(i));
            }
        }
    }

    public ParameterGroup(SimpleEnsemble[] p, int n) {
        this.parameterIDs = p;
        this.id = counter++;
        this.init(n);
        this.reset();
    }

    ParameterGroup(SimpleEnsemble[] p, int n, double[] w) {
        this.parameterIDs = p;
        this.id = counter++;
        this.init(n);
        this.w = w;
        this.reset();
    }

    private void setMap(int index, boolean value) {
        long b = 1L << index;
        if (value) {
            this.key |= b;
        } else {
            this.key |= b;
            this.key ^= b;
        }
    }

    public boolean getMap(int index) {
        long b = 1L << index;
        return (this.key & b) != 0L;
    }

    public void add(int p) {
        if (!this.getMap(p)) {
            this.setMap(p, true);
            this.stack[this.size++] = p;
        }
    }

    public void remove(int index) {
        this.setMap(this.stack[index], false);
        this.stack[index] = this.stack[--this.size];
    }

    public void add(ParameterGroup p) {
        for (int i = 0; i < this.stack.length; ++i) {
            if (!(p.getMap(i) & !this.getMap(i))) continue;
            this.setMap(i, true);
            this.stack[this.size++] = i;
        }
    }

    public void sub(ParameterGroup p) {
        this.size = 0;
        for (int i = 0; i < this.stack.length; ++i) {
            if (p.getMap(i) & this.getMap(i)) {
                this.setMap(i, false);
                continue;
            }
            if (!this.getMap(i)) continue;
            this.stack[this.size++] = i;
        }
    }

    public int get(int index) {
        return this.stack[index];
    }

    public ParameterGroup createEmptyGroup() {
        return this.createEmptyGroup(new ParameterGroup(this.parameterIDs, this.stack.length));
    }

    public ParameterGroup createEmptyGroup(ParameterGroup p) {
        p.init(this, true);
        return p;
    }

    public ParameterGroup copy() {
        return this.copy(new ParameterGroup(this.parameterIDs, this.stack.length));
    }

    public ParameterGroup copy(ParameterGroup p) {
        p.init(this, false);
        return p;
    }

    public int getIndex(int index) {
        for (int i = 0; i < this.size; ++i) {
            if (this.stack[i] != index) continue;
            return i;
        }
        return -1;
    }

    public double weight(int index) {
        return this.w[index];
    }

    public double[] normalizeWeight() {
        double norm = this.calcNorm();
        for (int j = 0; j < this.stack.length; ++j) {
            this.w[j] = norm != 0.0 ? this.w[j] / norm : 1.0 / (double)this.size;
        }
        return this.w;
    }

    public double calcNorm() {
        double sum = 0.0;
        for (int i = 0; i < this.size; ++i) {
            sum += this.w[this.stack[i]];
        }
        return sum;
    }

    public int getSize() {
        return this.size;
    }

    public void sortByWeight() {
        boolean flip = true;
        while (flip) {
            flip = false;
            for (int i = 0; i < this.size - 1; ++i) {
                if (!(this.w[this.stack[i]] < this.w[this.stack[i + 1]])) continue;
                int tmp = this.stack[i + 1];
                this.stack[i + 1] = this.stack[i];
                this.stack[i] = tmp;
                flip = true;
            }
        }
    }

    public String toString() {
        String result = "";
        result = result + "Parameter: ";
        for (int i = 0; i < this.size; ++i) {
            result = result + this.parameterIDs[this.stack[i]] + "  ";
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o instanceof ParameterGroup) {
            ParameterGroup p = (ParameterGroup)o;
            return p.key == this.key;
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 11 * hash + (int)(this.key ^ this.key >>> 32);
        return hash;
    }
}

