/*
 * Decompiled with CFR 0.152.
 */
package optas.gui.MCAT5;

import jams.JAMS;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import optas.data.DataCollection;
import optas.data.Efficiency;
import optas.data.EfficiencyEnsemble;
import optas.data.Parameter;
import optas.data.SimpleEnsemble;
import optas.gui.MCAT5.DataRequestPanel;
import optas.gui.MCAT5.MCAT5Plot;
import optas.optimizer.management.SampleFactory;
import optas.optimizer.management.Statistics;
import optas.tools.PatchedChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.renderer.category.BoxAndWhiskerRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.statistics.DefaultBoxAndWhiskerCategoryDataset;

public class ParetoBoxPlot
extends MCAT5Plot {
    SimpleEnsemble[] parameterEnsembles;
    JTable objectiveTable = new JTable();
    ObjectiveTableModel objTableModel = null;
    BoxAndWhiskerRenderer renderer = new BoxAndWhiskerRenderer();
    CategoryPlot plot = null;
    JCheckBox showMean = new JCheckBox(JAMS.i18n((String)"show_mean"), true);
    JCheckBox showMedian = new JCheckBox(JAMS.i18n((String)"show_median"), true);
    boolean calcParetoFront = true;
    JCheckBox useParetoOptimalSolutionsOnly = new JCheckBox(JAMS.i18n((String)"use_only_pareto_solutions"), this.calcParetoFront);
    JLabel alphaLabel = new JLabel("\u03b1: ");
    JTextField alphaField = new JTextField("0.1");
    JButton applyAlpha = new JButton(JAMS.i18n((String)"Apply"));
    JLabel numLabel = new JLabel("n: ");
    JTextField numField = new JTextField("0.0");
    JPanel mainPanel = new JPanel();

    public ParetoBoxPlot() {
        this.init();
    }

    private void init() {
        CategoryAxis xAxis = new CategoryAxis("");
        CategoryAxis xAxis2 = new CategoryAxis(JAMS.i18n((String)"Parameter"));
        CategoryAxis xAxis3 = new CategoryAxis("");
        NumberAxis yAxis = new NumberAxis(JAMS.i18n((String)"NORMALISED_RANGE"));
        this.plot = new CategoryPlot(null, xAxis, (ValueAxis)yAxis, (CategoryItemRenderer)this.renderer);
        this.plot.setDomainAxis(1, xAxis2);
        this.plot.setDomainAxis(2, xAxis3);
        xAxis.setFixedDimension(20.0);
        xAxis2.setFixedDimension(20.0);
        xAxis3.setFixedDimension(20.0);
        JFreeChart chart = new JFreeChart((Plot)this.plot);
        chart.removeLegend();
        this.renderer.setFillBox(true);
        this.renderer.setSeriesPaint(0, (Paint)Color.BLUE);
        this.renderer.setSeriesFillPaint(0, (Paint)Color.BLUE);
        this.renderer.setSeriesFillPaint(1, (Paint)Color.BLUE);
        this.renderer.setSeriesFillPaint(2, (Paint)Color.BLUE);
        this.renderer.setUseOutlinePaintForWhiskers(false);
        this.renderer.setMaximumBarWidth(0.33);
        this.plot.setBackgroundPaint((Paint)Color.WHITE);
        this.plot.setRangeGridlinePaint((Paint)Color.BLACK);
        this.plot.setDomainGridlinePaint((Paint)Color.BLACK);
        this.plot.setDomainGridlinesVisible(true);
        PatchedChartPanel chartPanel = new PatchedChartPanel(chart, true);
        chartPanel.setMinimumDrawWidth(0);
        chartPanel.setMinimumDrawHeight(0);
        chartPanel.setMaximumDrawWidth(2000);
        chartPanel.setMaximumDrawHeight(2000);
        chartPanel.setChart(chart);
        GroupLayout layout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(layout);
        JScrollPane tableScrollPane = new JScrollPane(this.objectiveTable);
        this.showMedian.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParetoBoxPlot.this.renderer.setMedianVisible(ParetoBoxPlot.this.showMedian.isSelected());
                ParetoBoxPlot.this.objTableModel.update();
            }
        });
        this.showMean.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParetoBoxPlot.this.renderer.setMeanVisible(ParetoBoxPlot.this.showMean.isSelected());
                ParetoBoxPlot.this.objTableModel.update();
            }
        });
        this.useParetoOptimalSolutionsOnly.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParetoBoxPlot.this.calcParetoFront = ParetoBoxPlot.this.useParetoOptimalSolutionsOnly.isSelected();
                ParetoBoxPlot.this.objTableModel.update();
            }
        });
        ActionListener applyAlphaListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double alpha = 0.0;
                try {
                    alpha = Double.parseDouble(ParetoBoxPlot.this.alphaField.getText());
                }
                catch (NumberFormatException nfe) {
                    alpha = 0.0;
                }
                for (int i = 0; i < ParetoBoxPlot.this.objTableModel.m; ++i) {
                    Integer[] sortedIds = ParetoBoxPlot.this.objTableModel.objectives[i].sort();
                    int id = sortedIds[(int)((double)sortedIds.length * alpha)];
                    ParetoBoxPlot.this.objTableModel.worstAcceptableValue[i] = ParetoBoxPlot.this.objTableModel.objectives[i].getValue(id);
                }
                ParetoBoxPlot.this.objTableModel.update();
            }
        };
        this.alphaField.addActionListener(applyAlphaListener);
        this.applyAlpha.addActionListener(applyAlphaListener);
        this.numField.setEditable(false);
        layout.setHorizontalGroup(layout.createSequentialGroup().addComponent((Component)((Object)chartPanel)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(tableScrollPane, 200, 425, 500).addGroup(layout.createSequentialGroup().addComponent(this.alphaLabel).addComponent(this.alphaField, 35, 50, 75).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 5, 10).addComponent(this.applyAlpha).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 10, 20)).addComponent(this.useParetoOptimalSolutionsOnly).addGroup(layout.createSequentialGroup().addComponent(this.numLabel).addComponent(this.numField, 35, 50, 75)).addComponent(this.useParetoOptimalSolutionsOnly).addComponent(this.showMedian).addComponent(this.showMean)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)((Object)chartPanel)).addGroup(layout.createSequentialGroup().addComponent(tableScrollPane, 200, 350, 400).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 20, 20).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.alphaLabel, 20, 26, 30).addComponent(this.alphaField, 20, 26, 30).addComponent(this.applyAlpha, 20, 26, 30)).addComponent(this.useParetoOptimalSolutionsOnly).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.numLabel, 20, 26, 30).addComponent(this.numField, 20, 26, 30)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.showMedian).addComponent(this.showMean).addContainerGap(100, 2000)));
    }

    private void initDataSet() {
        this.objTableModel = new ObjectiveTableModel(this.getDataSource());
        this.objectiveTable.setModel(this.objTableModel);
        Set<String> parameterSet = this.getDataSource().getDatasets(Parameter.class);
        this.parameterEnsembles = new SimpleEnsemble[parameterSet.size()];
        int counter = 0;
        for (String name : parameterSet) {
            this.parameterEnsembles[counter++] = this.getDataSource().getSimpleEnsemble(name);
        }
        this.objectiveTable.getColumnModel().getColumn(0).setPreferredWidth(55);
        this.objectiveTable.getColumnModel().getColumn(1).setPreferredWidth(115);
        this.objectiveTable.getColumnModel().getColumn(2).setPreferredWidth(80);
        this.objectiveTable.getColumnModel().getColumn(3).setPreferredWidth(160);
        this.objectiveTable.getTableHeader().setPreferredSize(new Dimension(this.objectiveTable.getTableHeader().getPreferredSize().width, 40));
        this.objectiveTable.setAutoResizeMode(0);
        this.objTableModel.update();
    }

    public void updateBoxPlot(ArrayList<SampleFactory.Sample> candidates) {
        CategoryAxis xAxis = this.plot.getDomainAxis(1);
        xAxis.setLabel("");
        xAxis.setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions((double)1.0471975511965976));
        xAxis = this.plot.getDomainAxis(0);
        xAxis.setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions((double)1.0471975511965976));
        xAxis.setLabel("");
        xAxis = this.plot.getDomainAxis(2);
        xAxis.setLabel("");
        xAxis.setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions((double)1.0471975511965976));
        this.plot.getRangeAxis().setRange(0.0, 1.0);
        double[] min = new double[this.parameterEnsembles.length];
        double[] max = new double[this.parameterEnsembles.length];
        for (int parameterNumber = 0; parameterNumber < this.parameterEnsembles.length; ++parameterNumber) {
            SimpleEnsemble ensemble = this.parameterEnsembles[parameterNumber];
            String name = ensemble.name;
            xAxis.addCategoryLabelToolTip((Comparable)((Object)name), name + " (Min: " + ensemble.getMin() + " Max: " + ensemble.getMax() + ")");
            min[parameterNumber] = ensemble.getMin();
            max[parameterNumber] = ensemble.getMax();
        }
        DefaultBoxAndWhiskerCategoryDataset dataset = new DefaultBoxAndWhiskerCategoryDataset();
        DefaultBoxAndWhiskerCategoryDataset dataset1 = new DefaultBoxAndWhiskerCategoryDataset();
        DefaultBoxAndWhiskerCategoryDataset dataset2 = new DefaultBoxAndWhiskerCategoryDataset();
        List<List<Double>> parameterValues = new ArrayList<List<Double>>(this.parameterEnsembles.length);
        for (int i = 0; i < this.parameterEnsembles.length; ++i) {
            parameterValues.add(new ArrayList());
        }
        for (SampleFactory.Sample sample : candidates) {
            for (int i = 0; i < sample.x.length; ++i) {
                parameterValues.get(i).add(sample.x[i]);
            }
        }
        parameterValues = this.normalize(parameterValues);
        int parameterNumber = 0;
        for (List<Double> parameter : parameterValues) {
            dataset.add(parameter, (Comparable)((Object)"Single Series1"), (Comparable)((Object)this.parameterEnsembles[parameterNumber].name));
            dataset1.add(parameter, (Comparable)((Object)"Single Series2"), (Comparable)new DoubleFormatter(min[parameterNumber]));
            dataset2.add(parameter, (Comparable)((Object)"Single Series3"), (Comparable)new DoubleFormatter(max[parameterNumber]));
            double c = 1.0E-10;
            while (dataset1.getColumnCount() <= parameterNumber) {
                dataset1.add(parameter, (Comparable)((Object)"Single Series2"), (Comparable)new DoubleFormatter(min[parameterNumber]));
                c += 1.0E-10;
            }
            while (dataset2.getColumnCount() <= parameterNumber) {
                dataset2.add(parameter, (Comparable)((Object)"Single Series3"), (Comparable)new DoubleFormatter(max[parameterNumber]));
                c += 1.0E-10;
            }
            ++parameterNumber;
        }
        this.plot.mapDatasetToDomainAxis(1, 1);
        this.plot.mapDatasetToDomainAxis(2, 2);
        this.plot.setDataset(0, (CategoryDataset)dataset1);
        this.plot.setDataset(1, (CategoryDataset)dataset);
        this.plot.setDataset(2, (CategoryDataset)dataset2);
        this.plot.setDomainAxisLocation(0, AxisLocation.BOTTOM_OR_LEFT);
        this.plot.setDomainAxisLocation(1, AxisLocation.BOTTOM_OR_LEFT);
        this.plot.setDomainAxisLocation(2, AxisLocation.TOP_OR_LEFT);
    }

    @Override
    public void refresh() throws MCAT5Plot.NoDataException {
        this.initDataSet();
    }

    @Override
    public JPanel getPanel() {
        return this.mainPanel;
    }

    private List<List<Double>> normalize(List<List<Double>> parameterValues) {
        int parameterNumber = 0;
        for (List<Double> list : parameterValues) {
            double max = this.parameterEnsembles[parameterNumber].getMax();
            double min = this.parameterEnsembles[parameterNumber].getMin();
            double difference = max - min;
            for (int i = 0; i < list.size(); ++i) {
                list.set(i, (list.get(i) - min) / difference);
            }
            ++parameterNumber;
        }
        return parameterValues;
    }

    public static double roundToSignificantFigures(double num, int n) {
        if (num == 0.0) {
            return 0.0;
        }
        double d = Math.ceil(Math.log10(num < 0.0 ? -num : num));
        int power = n - (int)d;
        double magnitude = Math.pow(10.0, power);
        long shifted = Math.round(num * magnitude);
        return (double)shifted / magnitude;
    }

    public static void main(String[] args) {
        DataCollection dc = DataCollection.createFromFile(new File("E:\\ModelData\\Testgebiete\\J2000\\Gehlberg\\output\\20140424_131138\\new_nsga_sample.cdat"));
        try {
            DataRequestPanel d = new DataRequestPanel(new ParetoBoxPlot(), dc);
            JFrame plotWindow = new JFrame("test");
            plotWindow.setDefaultCloseOperation(2);
            plotWindow.setLayout(new BorderLayout());
            plotWindow.setSize(800, 700);
            plotWindow.add((Component)d, "Center");
            plotWindow.pack();
            plotWindow.setVisible(true);
        }
        catch (MCAT5Plot.NoDataException noDataException) {
            // empty catch block
        }
    }

    private class DoubleFormatter
    implements Comparable<Double> {
        double value = 0.0;
        DecimalFormat df2 = new DecimalFormat("#,###,###,##0.00");

        public DoubleFormatter(double value) {
            this.value = value;
        }

        @Override
        public int compareTo(Double o) {
            if (o instanceof Double) {
                return o.compareTo(o);
            }
            return 0;
        }

        public String toString() {
            return this.df2.format(ParetoBoxPlot.roundToSignificantFigures(this.value, 3));
        }
    }

    class ObjectiveTableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{JAMS.i18n((String)"selected"), JAMS.i18n((String)"Name"), JAMS.i18n((String)"best_value"), JAMS.i18n((String)"worst_acceptable_value")};
        DataCollection dataSource = null;
        EfficiencyEnsemble[] objectives = null;
        private String[] name = null;
        private boolean[] selected = null;
        double[] bestValue;
        double[] worstAcceptableValue;
        int m;

        ObjectiveTableModel(DataCollection dataSource) {
            this.dataSource = dataSource;
            Set<String> effDataSets = this.dataSource.getDatasets(Efficiency.class);
            this.m = effDataSets.size();
            this.name = new String[this.m];
            effDataSets.toArray(this.name);
            this.selected = new boolean[this.m];
            this.bestValue = new double[this.m];
            this.worstAcceptableValue = new double[this.m];
            Arrays.fill(this.worstAcceptableValue, Double.POSITIVE_INFINITY);
            Arrays.fill(this.selected, true);
            this.objectives = new EfficiencyEnsemble[this.m];
            for (int i = 0; i < this.m; ++i) {
                this.objectives[i] = (EfficiencyEnsemble)dataSource.getDataSet(this.name[i]);
            }
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.m;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    return this.selected[row];
                }
                case 1: {
                    return this.name[row];
                }
                case 2: {
                    return this.bestValue[row];
                }
                case 3: {
                    return this.worstAcceptableValue[row];
                }
            }
            return null;
        }

        public Class getColumnClass(int c) {
            switch (c) {
                case 0: {
                    return Boolean.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return Double.class;
                }
                case 3: {
                    return Double.class;
                }
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            switch (col) {
                case 0: {
                    return true;
                }
                case 1: {
                    return false;
                }
                case 2: {
                    return false;
                }
                case 3: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 0) {
                this.selected[row] = (Boolean)value;
                this.update();
            }
            if (col == 3) {
                this.worstAcceptableValue[row] = (Double)value;
                this.update();
            }
        }

        public void update() {
            SampleFactory factory = new SampleFactory();
            ParetoBoxPlot.this.getDataSource().constructSample(factory);
            Statistics stats = factory.getStatistics();
            ArrayList<SampleFactory.Sample> paretoFront = null;
            paretoFront = ParetoBoxPlot.this.calcParetoFront ? stats.getParetoSubset(this.selected) : factory.getSampleList();
            for (int j = 0; j < this.m; ++j) {
                this.bestValue[j] = Double.POSITIVE_INFINITY;
                for (int i = 0; i < paretoFront.size(); ++i) {
                    this.bestValue[j] = Math.min(paretoFront.get(i).F()[j], this.bestValue[j]);
                }
            }
            block2: for (int i = 0; i < paretoFront.size(); ++i) {
                for (int j = 0; j < this.m; ++j) {
                    if (!this.selected[j] || !(paretoFront.get(i).F()[j] > this.worstAcceptableValue[j])) continue;
                    paretoFront.set(i, paretoFront.get(paretoFront.size() - 1));
                    paretoFront.remove(paretoFront.size() - 1);
                    --i;
                    continue block2;
                }
            }
            ParetoBoxPlot.this.numField.setText(Integer.toString(paretoFront.size()));
            ParetoBoxPlot.this.updateBoxPlot(paretoFront);
            this.fireTableDataChanged();
        }
    }
}

