/*
 * Decompiled with CFR 0.152.
 */
package optas.gui.MCAT5;

import jams.JAMS;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import optas.data.DataSet;
import optas.data.Efficiency;
import optas.data.EfficiencyEnsemble;
import optas.data.TimeSerie;
import optas.data.TimeSerieEnsemble;
import optas.gui.MCAT5.MCAT5Plot;
import optas.tools.PatchedChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public class ClassPlot
extends MCAT5Plot {
    XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
    XYPlot plot = new XYPlot();
    JTextField groupCount = new JTextField(2);
    JPanel mainPanel = new JPanel();
    int GROUPS = 10;

    public ClassPlot() {
        this.addRequest(new MCAT5Plot.SimpleRequest(this, JAMS.i18n((String)"SIMULATED_TIMESERIE"), TimeSerie.class));
        this.addRequest(new MCAT5Plot.SimpleRequest(this, JAMS.i18n((String)"Efficiency"), Efficiency.class));
        this.init();
    }

    private void init() {
        this.plot.setRenderer((XYItemRenderer)this.renderer);
        this.plot.setDomainAxis((ValueAxis)new DateAxis(JAMS.i18n((String)"TIME")));
        this.plot.setRangeAxis((ValueAxis)new NumberAxis(JAMS.i18n((String)"OUTPUT")));
        JFreeChart chart = new JFreeChart((Plot)this.plot);
        chart.setTitle(JAMS.i18n((String)"CLASS_PLOT"));
        chart.getPlot().setBackgroundPaint((Paint)Color.white);
        chart.getXYPlot().setDomainGridlinePaint((Paint)Color.black);
        PatchedChartPanel chartPanel = new PatchedChartPanel(chart, true);
        chartPanel.setMinimumDrawWidth(0);
        chartPanel.setMinimumDrawHeight(0);
        chartPanel.setMaximumDrawWidth(2000);
        chartPanel.setMaximumDrawHeight(2000);
        JPanel sliderPanel = new JPanel(new FlowLayout(2));
        sliderPanel.setMaximumSize(new Dimension(250, 100));
        sliderPanel.setPreferredSize(new Dimension(250, 100));
        sliderPanel.setMinimumSize(new Dimension(250, 100));
        JSlider slider = new JSlider();
        slider.setMinimum(2);
        slider.setMaximum(30);
        slider.setValue(this.GROUPS);
        this.groupCount.setText(Integer.toString(this.GROUPS));
        this.groupCount.setEnabled(false);
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider slider = (JSlider)e.getSource();
                if (!slider.getValueIsAdjusting()) {
                    ClassPlot.this.GROUPS = slider.getValue();
                    ClassPlot.this.groupCount.setText(Integer.toString(ClassPlot.this.GROUPS));
                    ClassPlot.this.redraw();
                }
            }
        });
        sliderPanel.setBorder(BorderFactory.createTitledBorder(JAMS.i18n((String)"number_of_groups")));
        sliderPanel.add(slider);
        sliderPanel.add(this.groupCount);
        sliderPanel.setMaximumSize(new Dimension(500, 60));
        sliderPanel.setMinimumSize(new Dimension(500, 60));
        this.groupCount.setMaximumSize(new Dimension(60, 60));
        this.mainPanel = new JPanel();
        GroupLayout layout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent((Component)((Object)chartPanel)).addComponent(sliderPanel));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent((Component)((Object)chartPanel)).addComponent(sliderPanel));
        this.redraw();
    }

    @Override
    public void refresh() throws MCAT5Plot.NoDataException {
        if (!this.isRequestFulfilled()) {
            return;
        }
        ArrayList<DataSet>[] p = this.getData(new int[]{0, 1});
        TimeSerieEnsemble ts = (TimeSerieEnsemble)p[0].get(0);
        EfficiencyEnsemble eff = (EfficiencyEnsemble)p[1].get(0);
        for (int i = 0; i < this.GROUPS; ++i) {
            this.renderer.setSeriesShapesVisible(i, false);
            int c = (int)((double)i * 255.0 / (double)this.GROUPS);
            this.renderer.setSeriesPaint(i, (Paint)new Color(255 - c, 0, c));
            this.renderer.setSeriesVisibleInLegend(i, Boolean.valueOf(false));
            if (i == 0 || i == this.GROUPS - 1) {
                this.renderer.setSeriesStroke(i, (Stroke)new BasicStroke(3.0f));
                continue;
            }
            this.renderer.setSeriesStroke(i, (Stroke)new BasicStroke(1.0f));
        }
        this.renderer.setSeriesVisibleInLegend(0, Boolean.valueOf(true));
        this.renderer.setSeriesVisibleInLegend(this.GROUPS - 1, Boolean.valueOf(true));
        EfficiencyEnsemble likelihood = eff.CalculateLikelihood();
        Integer[] sortedIds = likelihood.sort();
        int n = eff.getSize();
        int T = ts.getTimesteps();
        TimeSeriesCollection series = new TimeSeriesCollection();
        for (int i = 0; i < this.GROUPS; ++i) {
            TimeSeries dataset = new TimeSeries((Comparable)((Object)""));
            if (i == 0) {
                dataset = new TimeSeries((Comparable)((Object)JAMS.i18n((String)"HIGH_LIKELIHOOD")));
            }
            if (i == this.GROUPS - 1) {
                dataset = new TimeSeries((Comparable)((Object)JAMS.i18n((String)"LOW_LIKELIHOOD")));
            }
            int index_low = (int)((double)n / (double)this.GROUPS * (double)i);
            int index_high = (int)((double)n / (double)this.GROUPS * (double)(i + 1));
            if (index_high >= n) {
                index_high = n - 1;
            }
            for (int j = 0; j < T; ++j) {
                Day d = new Day(ts.getDate(j));
                double mean = 0.0;
                for (int k = index_low; k < index_high; ++k) {
                    mean += ts.get(j, sortedIds[k]);
                }
                dataset.add((RegularTimePeriod)d, mean /= (double)(index_high - index_low));
            }
            double mean_eff = 0.0;
            for (int k = index_low; k < index_high; ++k) {
                mean_eff += eff.getValue(sortedIds[k]);
            }
            series.addSeries(dataset);
            String tooltip = "<html><body>";
            tooltip = tooltip + eff.getName() + ":" + String.format("%.2f&nbsp;", mean_eff /= (double)(index_high - index_low));
            tooltip = tooltip + "</body></html>";
            this.plot.getRenderer().setSeriesToolTipGenerator(i, (XYToolTipGenerator)new CustomXYToolTipGenerator(i, tooltip));
        }
        this.plot.setDataset((XYDataset)series);
        if (this.plot.getRangeAxis() != null) {
            this.plot.getRangeAxis().setAutoRange(true);
        }
        if (this.plot.getDomainAxis() != null) {
            this.plot.getDomainAxis().setAutoRange(true);
        }
    }

    @Override
    public JPanel getPanel() {
        return this.mainPanel;
    }

    private class CustomXYToolTipGenerator
    implements XYToolTipGenerator {
        int index = 0;
        String tooltip = "";

        public CustomXYToolTipGenerator(int index, String tooltip) {
            this.tooltip = tooltip;
            this.index = index;
        }

        public String generateToolTip(XYDataset xyd, int i, int i1) {
            return this.tooltip;
        }
    }
}

