/*
 * Decompiled with CFR 0.152.
 */
package optas.efficiencies;

import optas.efficiencies.WeightedEfficiencyCalculator;

public class KGEprime_weighted
extends WeightedEfficiencyCalculator {
    double pow = 2.0;

    @Override
    public double calc(double[] m, double[] s, double[] weights) {
        int i;
        double r_weight = weights[0];
        double gamma_weight = weights[1];
        double beta_weight = weights[2];
        double r = 0.0;
        double beta = 0.0;
        double gamma = 0.0;
        double covs = 0.0;
        double covm = 0.0;
        double vars = 0.0;
        double varm = 0.0;
        double sum = 0.0;
        double avgs = 0.0;
        double avgm = 0.0;
        for (i = 0; i < m.length; ++i) {
            avgm += m[i];
            avgs += s[i];
        }
        avgm /= (double)m.length;
        avgs /= (double)s.length;
        for (i = 0; i < m.length; ++i) {
            sum += (m[i] - avgm) * (s[i] - avgs);
            varm += Math.pow(Math.abs(m[i] - avgm), this.pow);
            vars += Math.pow(Math.abs(s[i] - avgs), this.pow);
        }
        sum /= (double)m.length;
        double sigm = Math.sqrt(varm /= (double)m.length);
        double sigs = Math.sqrt(vars /= (double)s.length);
        covm = sigm / avgm;
        covs = sigs / avgs;
        gamma = covs / covm;
        beta = avgs / avgm;
        r = sum / (sigs * sigm);
        return 1.0 - Math.sqrt(gamma_weight * Math.pow(gamma - 1.0, this.pow) + beta_weight * Math.pow(beta - 1.0, this.pow) + r_weight * Math.pow(r - 1.0, this.pow));
    }

    @Override
    public double calcNormative(double[] t1, double[] t2, double[] weights) {
        return 1.0 - this.calc(t1, t2, weights);
    }
}

