/*
 * Decompiled with CFR 0.152.
 */
package optas.datamining.kernels;

import Jama.Matrix;
import optas.datamining.kernels.MeanModell;

public class FixedMeanModell
extends MeanModell {
    public FixedMeanModell(int inputSize) {
        this.inputSize = inputSize;
        this.parameterCount = 1;
        this.beta = null;
    }

    @Override
    public void create(double[][] data, double[] result) {
        this.beta = new double[1];
        double average = 0.0;
        for (int i = 0; i < data.length; ++i) {
            average += result[i];
        }
        this.beta[0] = average /= (double)data.length;
    }

    @Override
    public String[] getMeanModelParameterNames() {
        String[] stringRep = new String[]{"mean"};
        return stringRep;
    }

    @Override
    public Matrix Transform(double[][] data, double[] result) {
        Matrix transformed = new Matrix(result.length, 1);
        for (int i = 0; i < data.length; ++i) {
            transformed.set(i, 0, result[i] - this.beta[0]);
        }
        return transformed;
    }

    @Override
    public double[] ReTransform(double[][] data, Matrix prediction) {
        double[] transformed = new double[prediction.getRowDimension()];
        for (int i = 0; i < data.length; ++i) {
            transformed[i] = prediction.get(i, 0) + this.beta[0];
        }
        return transformed;
    }
}

