/*
 * Decompiled with CFR 0.152.
 */
package optas.datamining;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import optas.core.AbstractFunction;
import optas.core.ObjectiveAchievedException;
import optas.core.SampleLimitException;
import optas.data.DataCollection;
import optas.data.Parameter;
import optas.data.SimpleEnsemble;
import optas.optimizer.SCE;
import optas.optimizer.management.SampleFactory;

public class FindLargestEmptyRectangle {
    int n = 0;
    int K = 0;
    double[] initialPoint = null;
    double[][] pointList = null;
    double[] lowerBound = null;
    double[] upperBound = null;
    double[][] result = null;

    private double constraintPenalty(double[] l_in, double[] u_in) {
        double v;
        int i;
        double[] l = Arrays.copyOf(l_in, this.n);
        double[] u = Arrays.copyOf(u_in, this.n);
        double penalty = 0.0;
        for (i = 0; i < this.n; ++i) {
            v = Math.min(this.initialPoint[i] - l[i], u[i] - this.initialPoint[i]);
            if (!(v < 0.0)) continue;
            penalty = -v * 10.0 * this.volume(l, u);
            if (this.initialPoint[i] < l[i]) {
                l[i] = this.initialPoint[i];
                continue;
            }
            if (!(this.initialPoint[i] > u[i])) continue;
            u[i] = this.initialPoint[i];
        }
        for (int j = 0; j < this.K; ++j) {
            double min = Double.MAX_VALUE;
            for (int i2 = 0; i2 < this.n; ++i2) {
                double v2 = Math.min(this.pointList[j][i2] - l[i2], u[i2] - this.pointList[j][i2]);
                if (v2 > 0.0) {
                    v2 /= Math.abs(u[i2] - l[i2]);
                }
                min = Math.min(v2, min);
            }
            if (!(min > 0.0)) continue;
            penalty += min;
        }
        for (i = 0; i < this.n; ++i) {
            v = Math.max(this.lowerBound[i] - l[i], u[i] - this.upperBound[i]);
            if (!(v > 0.0)) continue;
            penalty += v / Math.abs(u[i] - l[i]);
        }
        return 2.0 * penalty * this.volume(l, u);
    }

    private double volume(double[] l, double[] u) {
        double v = 1.0;
        for (int i = 0; i < l.length; ++i) {
            v *= Math.max(Math.min(u[i], this.upperBound[i]) - Math.max(l[i], this.lowerBound[i]), 0.0);
        }
        return v;
    }

    private double[][] expandRectangle(double[] w) {
        double d = 1.0;
        double[] lastGoodPlus = null;
        double[] lastGoodMinus = null;
        double eps = 1.0E-4;
        double iter = -Math.ceil(Math.log(eps) / Math.log(2.0));
        double[] test_plus = new double[this.n];
        double[] test_minus = new double[this.n];
        int k = 1;
        while ((double)k <= iter) {
            for (int i = 0; i < this.n; ++i) {
                test_plus[i] = this.initialPoint[i];
                test_minus[i] = this.initialPoint[i];
            }
            boolean isValid = true;
            for (int i = 0; i < this.n; ++i) {
                int n = i;
                test_plus[n] = test_plus[n] + d * w[i] * (this.upperBound[i] - this.lowerBound[i]);
                test_plus[i] = Math.min(this.upperBound[i], test_plus[i]);
                int n2 = i;
                test_minus[n2] = test_minus[n2] - d * w[this.n + i] * (this.upperBound[i] - this.lowerBound[i]);
                test_minus[i] = Math.max(this.lowerBound[i], test_minus[i]);
            }
            if (!(isValid &= this.constraintPenalty(test_minus, test_plus) <= 0.0)) {
                d -= Math.pow(2.0, -k);
            } else {
                lastGoodPlus = test_plus;
                lastGoodMinus = test_minus;
                d += Math.pow(2.0, -k);
            }
            ++k;
        }
        if (lastGoodPlus != null && lastGoodMinus != null) {
            return new double[][]{lastGoodMinus, lastGoodPlus};
        }
        return new double[][]{this.initialPoint, this.initialPoint};
    }

    private double[] determineStartvalue() {
        double d = 1.0;
        double[] lastGoodMinus = null;
        double[] lastGoodPlus = null;
        double eps = 0.001;
        double iter = -Math.ceil(Math.log(eps) / Math.log(2.0));
        int k = 1;
        while ((double)k <= iter) {
            double[] test_plus = Arrays.copyOf(this.initialPoint, this.n);
            double[] test_minus = Arrays.copyOf(this.initialPoint, this.n);
            boolean isValid = true;
            for (int i = 0; i < this.n; ++i) {
                int n = i;
                test_plus[n] = test_plus[n] + d * (this.upperBound[i] - this.lowerBound[i]);
                test_plus[i] = Math.min(this.upperBound[i], test_plus[i]);
                int n2 = i;
                test_minus[n2] = test_minus[n2] - d * (this.upperBound[i] - this.lowerBound[i]);
                test_minus[i] = Math.max(this.lowerBound[i], test_minus[i]);
            }
            if (!(isValid &= this.constraintPenalty(test_minus, test_plus) <= 0.0)) {
                d -= Math.pow(2.0, -k);
            } else {
                lastGoodMinus = test_minus;
                lastGoodPlus = test_plus;
                d += Math.pow(2.0, -k);
            }
            ++k;
        }
        double[] result = new double[2 * this.n];
        for (int i = 0; i < this.n; ++i) {
            result[i] = lastGoodMinus[i];
            result[i + this.n] = lastGoodPlus[i] - lastGoodMinus[i];
        }
        return result;
    }

    public FindLargestEmptyRectangle(double[] initialPoint, double[] lowerBound, double[] upperBound, double[][] pointList) {
        this.n = initialPoint.length;
        this.K = pointList.length;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.pointList = (double[][])Arrays.copyOf(pointList, this.K + 2);
        this.pointList[this.K] = lowerBound;
        this.pointList[this.K + 1] = upperBound;
        this.pointList = pointList;
        this.initialPoint = initialPoint;
        System.out.println("Find largest empty rectangle .. ");
        System.out.println("Dimension is:" + this.n);
        if (lowerBound.length != this.n) {
            System.out.println("Dimension of lower bound does not fit to n" + lowerBound.length + " vs " + this.n);
        }
        if (upperBound.length != this.n) {
            System.out.println("Dimension of upper bound does not fit to n" + lowerBound.length + " vs " + this.n);
        }
    }

    private double[][] expand(double[] src) {
        return this.expandRectangle(src);
    }

    private void procedure() {
        SCE sce = new SCE();
        sce.setVerbose(false);
        double[] sceStartValue = new double[2 * this.n];
        Arrays.fill(sceStartValue, 1.0);
        System.out.println("Lower Bound is:" + Arrays.toString(this.lowerBound));
        System.out.println("Upper Bound is:" + Arrays.toString(this.upperBound));
        System.out.println("Start value lb:" + Arrays.toString(this.expand(sceStartValue)[0]));
        System.out.println("Start value ub:" + Arrays.toString(this.expand(sceStartValue)[1]));
        System.out.println("Volume of startvalue is:" + this.volume(this.expand(sceStartValue)[0], this.expand(sceStartValue)[1]));
        System.out.println("Penalty of startvalue is:" + this.constraintPenalty(this.expand(sceStartValue)[0], this.expand(sceStartValue)[1]));
        sce.setMaxn(200000.0);
        sce.setStartValue(sceStartValue);
        sce.setFunction(new AbstractFunction(){

            @Override
            public int getInputDimension() {
                return 2 * FindLargestEmptyRectangle.this.n;
            }

            @Override
            public int getOutputDimension() {
                return 1;
            }

            @Override
            public double[] evaluate(double[] x) throws SampleLimitException, ObjectiveAchievedException {
                double[][] t = FindLargestEmptyRectangle.this.expand(x);
                double[] l = t[0];
                double[] u = t[1];
                return new double[]{-FindLargestEmptyRectangle.this.volume(l, u) + FindLargestEmptyRectangle.this.constraintPenalty(l, u)};
            }

            @Override
            public void log(String msg) {
                System.out.println(msg);
            }

            public String[] getParameterNames() {
                String[] names = new String[2 * FindLargestEmptyRectangle.this.n];
                for (int i = 0; i < FindLargestEmptyRectangle.this.n; ++i) {
                    names[2 * i + 0] = "li_" + i;
                    names[2 * i + 1] = "wi_" + i;
                }
                return names;
            }

            @Override
            public double[][] getRange() {
                double[][] range = new double[2 * FindLargestEmptyRectangle.this.n][2];
                for (int i = 0; i < 2 * FindLargestEmptyRectangle.this.n; ++i) {
                    range[i][0] = 0.0;
                    range[i][1] = 1.0;
                }
                return range;
            }
        });
        sce.setDebugMode(false);
        sce.setVerbose(false);
        sce.kstop = 500.0;
        sce.complexesCount = 5.0;
        ArrayList<SampleFactory.Sample> result = sce.optimize();
        System.out.println("Finished optimization of largest empty rectangle ..");
        System.out.println("Result is ..");
        double[] x = result.get((int)0).x;
        double[] lopt = this.expand(x)[0];
        double[] uopt = this.expand(x)[1];
        System.out.println("lower boundary:" + Arrays.toString(lopt));
        System.out.println("upper boundary:" + Arrays.toString(uopt));
        System.out.println("volume:" + this.volume(lopt, uopt));
        System.out.println("penalty:" + this.constraintPenalty(lopt, uopt));
        this.result = new double[][]{lopt, uopt};
    }

    public double[][] getFLER() {
        this.procedure();
        return this.result;
    }

    public static double format(double d) {
        return (double)Math.round(d * 100.0) / 100.0;
    }

    public static void main(String[] args) {
        int j;
        DataCollection dc = DataCollection.createFromFile(new File("C:/Arbeit/ModelData/Testgebiete/J2000/Gehlberg/output/20120331_013625/complete2.cdat"));
        Set<String> parameterSets = dc.getDatasets(Parameter.class);
        ArrayList<SimpleEnsemble> ps = new ArrayList<SimpleEnsemble>();
        for (String parameterSet : parameterSets) {
            ps.add((SimpleEnsemble)dc.getDataSet(parameterSet));
        }
        SimpleEnsemble objective = (SimpleEnsemble)dc.getDataSet("bias_normalized");
        ArrayList<double[]> exclude = new ArrayList<double[]>();
        double dmin = objective.getMin();
        double dthresh = dmin * 1.1;
        int n = ps.size();
        for (int i = 0; i < objective.getSize(); ++i) {
            int id = objective.getId(i);
            double value = objective.getValue(id);
            if (value > dthresh) {
                double[] excludePoint = new double[n];
                for (j = 0; j < n; ++j) {
                    excludePoint[j] = ((SimpleEnsemble)ps.get(j)).getValue(id);
                }
                exclude.add(excludePoint);
                continue;
            }
            System.out.println("Keep id" + objective.getId(i) + " with value:" + value);
        }
        double[][] pointList = (double[][])exclude.toArray((T[])new double[0][]);
        double[] lowerBound = new double[n];
        double[] upperBound = new double[n];
        double[] initialPoint = new double[n];
        int idbest = objective.findArgMin();
        for (j = 0; j < n; ++j) {
            lowerBound[j] = ((SimpleEnsemble)ps.get(j)).getMin();
            upperBound[j] = ((SimpleEnsemble)ps.get(j)).getMax();
            initialPoint[j] = ((SimpleEnsemble)ps.get(j)).getValue(idbest);
        }
        FindLargestEmptyRectangle FLER = new FindLargestEmptyRectangle(initialPoint, lowerBound, upperBound, pointList);
        double[][] ranges = FLER.getFLER();
        for (int i = 0; i < n; ++i) {
            System.out.println(((SimpleEnsemble)ps.get(i)).getName() + "=[" + FindLargestEmptyRectangle.format(ranges[0][i]) + "-" + FindLargestEmptyRectangle.format(ranges[1][i]) + "]");
        }
    }
}

