/*
 * Decompiled with CFR 0.152.
 */
package optas.data;

import jams.JAMS;
import jams.data.Attribute;
import jams.data.DefaultDataFactory;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.TreeSet;
import optas.data.DataCollection;
import optas.data.Ensemble;
import optas.data.Measurement;
import optas.data.SimpleEnsemble;
import optas.data.TimeFilter;
import optas.data.TimeSerieEnsemble;

public class EfficiencyEnsemble
extends SimpleEnsemble {
    boolean isPostiveBest = true;
    double rangeMin = Double.NEGATIVE_INFINITY;
    double rangeMax = Double.POSITIVE_INFINITY;
    TimeFilter filter = null;
    boolean[] filterMap;

    public EfficiencyEnsemble(SimpleEnsemble s, boolean isPositiveBest) {
        super(s);
        this.isPostiveBest = isPositiveBest;
    }

    public EfficiencyEnsemble(String name, int size) {
        super(name, size);
    }

    public EfficiencyEnsemble(String name, int size, boolean isPositiveBest) {
        super(name, size);
        this.isPostiveBest = isPositiveBest;
    }

    public EfficiencyEnsemble(String name, int size, boolean isPositiveBest, double rangeMin, double rangeMax) {
        super(name, size);
        this.isPostiveBest = isPositiveBest;
        this.rangeMin = rangeMin;
        this.rangeMax = rangeMax;
    }

    @Override
    public void add(Integer id, double value) {
        if (value > this.rangeMax) {
            value = this.rangeMax;
        }
        if (value < this.rangeMin) {
            value = this.rangeMin;
        }
        super.add(id, value);
    }

    public EfficiencyEnsemble(String name, Measurement obs, TimeSerieEnsemble sim, Method m, TimeFilter filter) {
        super(name, sim.size);
        int i;
        int K = sim.getTimesteps();
        this.filter = filter;
        this.filterMap = new boolean[K];
        int kStar = 0;
        if (filter != null) {
            this.filter = filter;
            for (int i2 = 0; i2 < K; ++i2) {
                boolean bl = this.filterMap[i2] = filter.isFiltered(obs.getTime(i2)) || obs.getValue(i2) == JAMS.getMissingDataValue();
                if (this.filterMap[i2]) continue;
                ++kStar;
            }
        } else {
            kStar = K;
        }
        double[] filteredObservation = new double[kStar];
        double[][] filteredSim = new double[sim.size][kStar];
        int c = 0;
        for (i = 0; i < K; ++i) {
            if (!this.filterMap[i]) {
                filteredObservation[c] = obs.getValue(i);
            }
            for (int j = 0; j < sim.size; ++j) {
                int id_i = sim.getId(j);
                if (this.filterMap[i]) continue;
                filteredSim[j][c] = sim.get(i, id_i);
            }
            if (this.filterMap[i]) continue;
            ++c;
        }
        switch (m) {
            case logNashSutcliffe: {
                int i3;
                int i4;
                double aobs = 0.0;
                for (i4 = 0; i4 < kStar; ++i4) {
                    if (!(filteredObservation[i4] > 0.0)) continue;
                    aobs += Math.log(filteredObservation[i4]);
                }
                aobs /= (double)filteredObservation.length;
                double denumerator = 0.0;
                for (i3 = 0; i3 < kStar; ++i3) {
                    if (!(filteredObservation[i3] > 0.0)) continue;
                    double d = Math.log(filteredObservation[i3]) - aobs;
                    denumerator += d * d;
                }
                for (i3 = 0; i3 < sim.size; ++i3) {
                    int id_i = sim.getId(i3);
                    double numerator = 0.0;
                    for (int j = 0; j < kStar; ++j) {
                        if (!(filteredObservation[j] > 0.0) || !(filteredSim[i3][j] > 0.0)) continue;
                        double d1 = Math.abs(Math.log(filteredSim[i3][j]) - Math.log(filteredObservation[j]));
                        numerator += d1 * d1;
                    }
                    double e2 = 1.0 - numerator / denumerator;
                    this.add(id_i, e2);
                }
                this.isPostiveBest = true;
                break;
            }
            case logNashSutcliffe1: {
                int i5;
                int i4;
                double aobs = 0.0;
                for (i4 = 0; i4 < kStar; ++i4) {
                    if (!(filteredObservation[i4] > 0.0)) continue;
                    aobs += Math.log(filteredObservation[i4]);
                }
                aobs /= (double)filteredObservation.length;
                double denumerator = 0.0;
                for (i5 = 0; i5 < kStar; ++i5) {
                    if (!(filteredObservation[i5] > 0.0)) continue;
                    double d = Math.log(filteredObservation[i5]) - aobs;
                    denumerator += Math.abs(d);
                }
                for (i5 = 0; i5 < sim.size; ++i5) {
                    int id_i = sim.getId(i5);
                    double numerator = 0.0;
                    for (int j = 0; j < kStar; ++j) {
                        if (!(filteredObservation[j] > 0.0) || !(filteredSim[i5][j] > 0.0)) continue;
                        double d1 = Math.abs(Math.log(filteredSim[i5][j]) - Math.log(filteredObservation[j]));
                        numerator += Math.abs(d1);
                    }
                    double e2 = 1.0 - numerator / denumerator;
                    this.add(id_i, e2);
                }
                this.isPostiveBest = true;
                break;
            }
            case NashSutcliffe: {
                int i6;
                int i4;
                double aobs = 0.0;
                for (i4 = 0; i4 < kStar; ++i4) {
                    aobs += filteredObservation[i4];
                }
                aobs /= (double)filteredObservation.length;
                double denumerator = 0.0;
                for (i6 = 0; i6 < kStar; ++i6) {
                    double d = filteredObservation[i6] - aobs;
                    denumerator += d * d;
                }
                for (i6 = 0; i6 < sim.size; ++i6) {
                    int id_i = sim.getId(i6);
                    double numerator = 0.0;
                    for (int j = 0; j < kStar; ++j) {
                        double d1 = filteredSim[i6][j] - filteredObservation[j];
                        numerator += d1 * d1;
                    }
                    double e2 = 1.0 - numerator / denumerator;
                    this.add(id_i, e2);
                }
                this.isPostiveBest = true;
                break;
            }
            case NashSutcliffe1: {
                int i7;
                int i4;
                double aobs = 0.0;
                for (i4 = 0; i4 < kStar; ++i4) {
                    aobs += filteredObservation[i4];
                }
                aobs /= (double)filteredObservation.length;
                double denumerator = 0.0;
                for (i7 = 0; i7 < kStar; ++i7) {
                    double d = filteredObservation[i7] - aobs;
                    denumerator += Math.abs(d);
                }
                for (i7 = 0; i7 < sim.size; ++i7) {
                    int id_i = sim.getId(i7);
                    double numerator = 0.0;
                    for (int j = 0; j < kStar; ++j) {
                        double d1 = filteredSim[i7][j] - filteredObservation[j];
                        numerator += Math.abs(d1);
                    }
                    double e1 = 1.0 - numerator / denumerator;
                    this.add(id_i, e1);
                }
                this.isPostiveBest = true;
                break;
            }
            case RootMeanSquareError: {
                int id_i;
                for (i = 0; i < sim.size; ++i) {
                    id_i = sim.getId(i);
                    double rsme = 0.0;
                    for (int j = 0; j < kStar; ++j) {
                        double d1 = filteredSim[i][j] - filteredObservation[j];
                        rsme += d1 * d1;
                    }
                    this.add(id_i, rsme);
                }
                this.isPostiveBest = false;
                break;
            }
            case AbsoluteError: {
                int id_i;
                for (i = 0; i < sim.size; ++i) {
                    id_i = sim.getId(i);
                    double abse = 0.0;
                    for (int j = 0; j < kStar; ++j) {
                        double d1 = filteredSim[i][j] - filteredObservation[j];
                        abse += Math.abs(d1);
                    }
                    this.add(id_i, abse);
                }
                this.isPostiveBest = false;
                break;
            }
            case Bias: {
                int id_i;
                for (i = 0; i < sim.size; ++i) {
                    id_i = sim.getId(i);
                    double bias = 0.0;
                    for (int j = 0; j < kStar; ++j) {
                        double d1 = filteredSim[i][j] - filteredObservation[j];
                        bias += d1;
                    }
                    this.add(id_i, bias);
                }
                this.isPostiveBest = false;
            }
        }
    }

    @Override
    public Ensemble clone() {
        EfficiencyEnsemble s = new EfficiencyEnsemble(this.name, this.size, this.isPostiveBest);
        for (int i = 0; i < this.size; ++i) {
            s.set(i, this.getId(i));
        }
        s.currentIndex = this.currentIndex;
        s.parent = this.parent;
        s.value = (double[])this.value.clone();
        s.filter = this.filter;
        s.filterMap = this.filterMap;
        return s;
    }

    public int findArgBest() {
        if (this.isPostiveBest) {
            return super.findArgMax();
        }
        return super.findArgMin();
    }

    public int findArgWorst() {
        if (this.isPostiveBest) {
            return super.findArgMin();
        }
        return super.findArgMax();
    }

    public void setPositiveBest(boolean flag) {
        this.isPostiveBest = flag;
    }

    public boolean isPositiveBest() {
        return this.isPostiveBest;
    }

    public EfficiencyEnsemble CalculateLikelihood() {
        int i;
        double Lmin;
        double[] likelihood = Arrays.copyOf(this.value, this.size);
        if (this.isPostiveBest) {
            Lmin = this.getMin();
            for (i = 0; i < this.size; ++i) {
                likelihood[i] = likelihood[i] - Lmin;
            }
        } else {
            Lmin = 1.0 - this.getMax();
            for (i = 0; i < this.size; ++i) {
                likelihood[i] = 1.0 - likelihood[i] - Lmin;
            }
        }
        double sum = 0.0;
        for (i = 0; i < this.size; ++i) {
            sum += likelihood[i];
        }
        sum = 0.0;
        for (i = 0; i < this.size; ++i) {
            sum += likelihood[i];
        }
        i = 0;
        while (i < this.size) {
            int n = i++;
            likelihood[n] = likelihood[n] / sum;
        }
        EfficiencyEnsemble eff = new EfficiencyEnsemble(this.name, this.size);
        for (int i2 = 0; i2 < this.size; ++i2) {
            eff.set(i2, this.getId(i2));
        }
        eff.isPostiveBest = true;
        eff.parent = this.parent;
        eff.value = likelihood;
        eff.update();
        return eff;
    }

    @Override
    public Integer[] sort() {
        return this.sort(!this.isPostiveBest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void exportTimeFilter(File f, Attribute.TimeInterval domain) {
        if (this.parent instanceof DataCollection && domain == null) {
            DataCollection dc = (DataCollection)this.parent;
            domain = dc.getTimeDomain();
        }
        String stringRepresentation = "";
        try {
            TreeSet<Integer> tSteps = new TreeSet<Integer>();
            Attribute.Calendar start = domain.getStart().clone();
            Attribute.Calendar end = domain.getEnd().clone();
            int t = 0;
            while (!start.after(end)) {
                if (!this.filter.isFiltered(start.getTime())) {
                    tSteps.add(t);
                }
                start.add(domain.getTimeUnit(), domain.getTimeUnitCount());
                ++t;
            }
            Iterator iter = tSteps.iterator();
            if (!iter.hasNext()) {
                return;
            }
            while (iter.hasNext()) {
                int next;
                int startIndex;
                int currentIndex = startIndex = ((Integer)iter.next()).intValue();
                int endIndex = startIndex;
                while (iter.hasNext() && (next = ((Integer)iter.next()).intValue()) - currentIndex <= 1) {
                    endIndex = currentIndex + 1;
                    currentIndex = next;
                }
                Attribute.TimeInterval interval = DefaultDataFactory.getDataFactory().createTimeInterval();
                Attribute.Calendar startCal = DefaultDataFactory.getDataFactory().createCalendar();
                Attribute.Calendar endCal = DefaultDataFactory.getDataFactory().createCalendar();
                startCal.setTime(domain.getStart().clone().getTime());
                endCal.setTime(domain.getStart().clone().getTime());
                startCal.add(domain.getTimeUnit(), domain.getTimeUnitCount() * startIndex);
                endCal.add(domain.getTimeUnit(), domain.getTimeUnitCount() * endIndex);
                interval.setStart(startCal);
                interval.setEnd(endCal);
                stringRepresentation = stringRepresentation + interval.toString() + ";";
            }
        }
        finally {
            block44: {
                BufferedWriter writer = null;
                writer = new BufferedWriter(new FileWriter(f));
                writer.write(stringRepresentation);
                writer.close();
                try {
                    if (writer != null) {
                        writer.close();
                    }
                    break block44;
                }
                catch (IOException iOException) {}
                break block44;
                catch (IOException ioe2222222222) {
                    try {
                        ioe2222222222.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        try {
                            if (writer != null) {
                                writer.close();
                            }
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                    }
                    catch (IOException ioe2222222222) {}
                }
            }
        }
    }

    public static enum Method {
        NashSutcliffe,
        NashSutcliffe1,
        RootMeanSquareError,
        AbsoluteError,
        Bias,
        logNashSutcliffe,
        logNashSutcliffe1;

    }
}

