/*
 * Decompiled with CFR 0.152.
 */
package optas.data;

import java.util.ArrayList;
import java.util.Arrays;
import optas.data.EfficiencyEnsemble;
import optas.data.SimpleEnsemble;
import optas.optimizer.management.SampleFactory;

public class Calculations {
    public static double[] calcBounds(ArrayList<SampleFactory.Sample> list, int param, int objective, int boxcount, double threshold) {
        SimpleEnsemble p = new SimpleEnsemble("test1", list.size());
        EfficiencyEnsemble e = new EfficiencyEnsemble("test2", list.size(), false);
        for (int i = 0; i < list.size(); ++i) {
            p.add(i, list.get((int)i).x[param]);
            e.add(i, list.get(i).F()[objective]);
        }
        return Calculations.calcBounds(p, e, boxcount, threshold);
    }

    public static double[] calcBounds(SimpleEnsemble p, EfficiencyEnsemble e, int boxcount, double threshold) {
        int pMax;
        double[] distribution = Calculations.calcPostioriDistribution(p, e, boxcount);
        double boxMin = Double.POSITIVE_INFINITY;
        double boxMax = Double.NEGATIVE_INFINITY;
        for (double confidence = 0.0; confidence < 0.93; confidence += distribution[pMax]) {
            pMax = 0;
            for (int i = 0; i < boxcount; ++i) {
                if (!(distribution[i] > distribution[pMax])) continue;
                pMax = i;
            }
            distribution[pMax] = 0.0;
            boxMin = Math.min(boxMin, (double)pMax);
            boxMax = Math.max(boxMax, (double)pMax);
        }
        double r1 = boxMin / (double)(boxcount - 1);
        double r2 = boxMax / (double)(boxcount - 1);
        double lb = p.getMin() + r1 * (p.getMax() - p.getMin());
        double ub = p.getMin() + r2 * (p.getMax() - p.getMin());
        int bestId = e.findArgBest();
        lb = Math.min(p.getValue(bestId), lb);
        ub = Math.max(p.getValue(bestId), ub);
        return new double[]{lb, ub};
    }

    public static double[] calcPostioriDistribution(SimpleEnsemble p, EfficiencyEnsemble e, int boxcount) {
        int pMax;
        int i;
        double[] boxes = new double[boxcount];
        double[] elitism = new double[boxcount];
        int[] boxContentCount = new int[boxcount];
        Arrays.fill(boxContentCount, 0);
        double min = p.getMin();
        double max = p.getMax();
        double range = max - min;
        Integer[] ids = e.sort();
        double tau = 0.1;
        double elitismThreshold = e.getValue(ids[(int)((double)ids.length * tau)]);
        int i2 = 0;
        while ((double)i2 < (double)ids.length * tau) {
            double fx = e.getValue(ids[i2]);
            if (!Double.isInfinite(fx) && !Double.isNaN(fx)) {
                double x = p.getValue(ids[i2]);
                double di = (x - min) / range;
                int index = (int)(di * (double)boxcount);
                if (index == boxcount) {
                    // empty if block
                }
                int n = --index;
                boxes[n] = boxes[n] + fx;
                int n2 = index;
                boxContentCount[n2] = boxContentCount[n2] + 1;
                if (e.isPostiveBest && fx > elitismThreshold) {
                    int n3 = index;
                    elitism[n3] = elitism[n3] + 1.0;
                } else if (!e.isPostiveBest && fx < elitismThreshold) {
                    int n4 = index;
                    elitism[n4] = elitism[n4] + 1.0;
                }
            }
            ++i2;
        }
        double elitismCountTotal = 0.0;
        for (i = 0; i < boxcount; ++i) {
            elitismCountTotal += elitism[i];
        }
        i = 0;
        while (i < boxcount) {
            int n = i++;
            elitism[n] = elitism[n] / elitismCountTotal;
        }
        double boxMin = Double.POSITIVE_INFINITY;
        double boxMax = Double.NEGATIVE_INFINITY;
        System.out.println("min: " + e.getMin());
        for (int i3 = 0; i3 < boxcount; ++i3) {
            if (boxContentCount[i3] != 0) {
                int n = i3;
                boxes[n] = boxes[n] / (double)boxContentCount[i3];
            }
            System.out.println("box(" + i3 + ")" + elitism[i3]);
        }
        boxes = Arrays.copyOf(elitism, boxcount);
        for (double confidence = 0.0; confidence < 0.93; confidence += elitism[pMax]) {
            pMax = 0;
            for (int i4 = 0; i4 < boxcount; ++i4) {
                if (!(elitism[i4] > elitism[pMax])) continue;
                pMax = i4;
            }
            elitism[pMax] = 0.0;
            boxMin = Math.min(boxMin, (double)pMax);
            boxMax = Math.max(boxMax, (double)pMax);
        }
        System.out.println("[" + (min + boxMin / (double)(boxcount - 1) * (max - min)) + "<" + (min + boxMax / (double)(boxcount - 1) * (max - min)) + "]");
        return boxes;
    }
}

