/*
 * Decompiled with CFR 0.152.
 */
package optas.SA;

import Jama.LUDecomposition;
import Jama.Matrix;
import java.util.Random;
import optas.SA.SensitivityAnalyzer;

public class GradientSensitivityAnalysis
extends SensitivityAnalyzer {
    @Override
    public void calculate() {
        super.calculate();
        int K = 2 * this.n;
        Matrix X = new Matrix(K, this.n + 1);
        Matrix Y = new Matrix(K, 1);
        double[] x0 = new double[this.n];
        double[] x1 = new double[this.n];
        double deltah = 0.01;
        Random rnd = new Random();
        double error_avg = 0.0;
        for (int i = 0; i < this.sampleSize; ++i) {
            for (int k = 0; k < this.n; ++k) {
                x0[k] = rnd.nextDouble();
            }
            double value_0 = this.evaluateModel(x0);
            for (int j = 0; j < K; ++j) {
                X.set(j, this.n, 1.0);
                for (int k = 0; k < this.n; ++k) {
                    if (rnd.nextBoolean()) {
                        x1[k] = x0[k] + 0.01;
                        X.set(j, k, 0.01);
                        continue;
                    }
                    x1[k] = x0[k] - 0.01;
                    X.set(j, k, -0.01);
                }
                double value = this.evaluateModel(x0);
                Y.set(j, 0, value);
            }
            LUDecomposition solver = new LUDecomposition(X.transpose().times(X));
            Matrix beta = solver.solve(X.transpose().times(Y));
            error_avg += beta.get(this.n, 0) - value_0;
            for (int j = 0; j < this.n; ++j) {
                this.sensitivityIndex[j] = Math.max(this.sensitivityIndex[j], Math.abs(beta.get(j, 0)));
            }
        }
        error_avg /= (double)this.sampleSize;
        for (int j = 0; j < this.n; ++j) {
        }
        System.out.println("Average error for gradient regression is:" + error_avg);
    }
}

