/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.mcidas;

import ucar.ma2.Array;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.transform.AbstractTransformBuilder;
import ucar.nc2.dataset.transform.HorizTransformBuilderIF;
import ucar.nc2.iosp.mcidas.McIDASAreaProjection;

public class McIDASAreaTransformBuilder
extends AbstractTransformBuilder
implements HorizTransformBuilderIF {
    @Override
    public String getTransformName() {
        return McIDASAreaProjection.GRID_MAPPING_NAME;
    }

    @Override
    public ProjectionCT makeCoordinateTransform(AttributeContainer ctv, String units) {
        int[] area = this.getIntArray(ctv, McIDASAreaProjection.ATTR_AREADIR);
        int[] nav = this.getIntArray(ctv, McIDASAreaProjection.ATTR_NAVBLOCK);
        int[] aux = null;
        if (ctv.findAttributeIgnoreCase(McIDASAreaProjection.ATTR_AUXBLOCK) != null) {
            aux = this.getIntArray(ctv, McIDASAreaProjection.ATTR_AUXBLOCK);
        }
        McIDASAreaProjection proj = new McIDASAreaProjection(area, nav, aux);
        return new ProjectionCT(ctv.getName(), "FGDC", proj);
    }

    private int[] getIntArray(AttributeContainer ctv, String attName) {
        Attribute att = ctv.findAttribute(attName);
        if (att == null) {
            throw new IllegalArgumentException("McIDASArea coordTransformVariable " + ctv.getName() + " must have " + attName + " attribute");
        }
        Array arr = att.getValues();
        return (int[])arr.get1DJavaArray(Integer.TYPE);
    }
}

