/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.dmsp;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.iosp.dmsp.DMSPHeader;
import ucar.nc2.util.CancelTask;
import ucar.unidata.io.RandomAccessFile;

public class DMSPiosp
extends AbstractIOServiceProvider {
    DMSPHeader header;
    private float[] calculatedTime;
    private String startDateString;
    private Date startDate;
    private int[] cachedYear;
    private int[] cachedDayOfYear;
    private double[] cachedSecondsOfDay;
    private float[] calculatedLatitude;
    private float[] calculatedLongitude;
    private float[] cachedSatEphemLatitude;
    private float[] cachedSatEphemLongitude;
    private float[] cachedSatEphemAltitude;
    private float[] cachedSatEphemHeading;
    private float[] cachedScannerOffset;
    private byte[] cachedScanDirection;

    @Override
    public boolean isValidFile(RandomAccessFile raf) {
        DMSPHeader localHeader = new DMSPHeader();
        return localHeader.isValidFile(raf);
    }

    @Override
    public String getFileTypeId() {
        return "DMSP";
    }

    @Override
    public String getFileTypeDescription() {
        return "Defense Meteorological Satellite Program";
    }

    @Override
    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        super.open(raf, ncfile, cancelTask);
        this.raf.order(0);
        this.header = new DMSPHeader();
        this.header.read(this.raf, this.ncfile);
        ArrayList<Dimension> nonScanDimList = new ArrayList<Dimension>();
        nonScanDimList.add(this.header.getNumDataRecordsDim());
        ArrayList<Dimension> scanDimList = new ArrayList<Dimension>();
        scanDimList.add(this.header.getNumDataRecordsDim());
        scanDimList.add(this.header.getNumSamplesPerBandDim());
        for (VariableInfo curVarInfo : VariableInfo.getAll()) {
            Variable curVariable = new Variable(this.ncfile, this.ncfile.getRootGroup(), null, curVarInfo.getName());
            curVariable.setDataType(curVarInfo.getDataType());
            if (curVarInfo.getNumElementsInRecord() == 1) {
                curVariable.setDimensions(nonScanDimList);
            } else {
                curVariable.setDimensions(scanDimList);
            }
            curVariable.addAttribute(new Attribute("long_name", curVarInfo.getLongName()));
            curVariable.addAttribute(new Attribute("units", curVarInfo.getUnits()));
            switch (curVariable.getShortName()) {
                case "latitude": {
                    curVariable.addAttribute(new Attribute("calculatedVariable", "Using the geometry of the satellite scans and an ellipsoidal earth (a=6378.14km and e=0.0818191830)."));
                    curVariable.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lat.toString()));
                    break;
                }
                case "longitude": {
                    curVariable.addAttribute(new Attribute("calculatedVariable", "Using the geometry of the satellite scans and an ellipsoidal earth (a=6378.14km and e=0.0818191830)."));
                    curVariable.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lon.toString()));
                    break;
                }
                case "time": {
                    curVariable.addAttribute(new Attribute("calculatedVariable", "Using the satellite epoch for each scan."));
                    this.startDateString = this.header.getStartDateAtt().getStringValue();
                    try {
                        this.startDate = DMSPHeader.DateFormatHandler.ISO_DATE_TIME.getDateFromDateTimeString(this.startDateString);
                    }
                    catch (ParseException e) {
                        throw new IOException("Invalid DMSP file: \"startDate\" attribute value <" + this.startDateString + "> not parseable with format string <" + DMSPHeader.DateFormatHandler.ISO_DATE_TIME.getDateTimeFormatString() + ">.");
                    }
                    curVariable.addAttribute(new Attribute("units", "seconds since " + this.startDateString));
                    curVariable.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Time.toString()));
                    break;
                }
                case "infraredImagery": {
                    curVariable.addAttribute(new Attribute("_CoordinateAxes", "latitude longitude time"));
                    curVariable.addAttribute(new Attribute("scale_factor", Float.valueOf(0.47058824f)));
                    curVariable.addAttribute(new Attribute("add_offset", Float.valueOf(190.0f)));
                    curVariable.addAttribute(new Attribute("description", "Infrared pixel values correspond to a temperature range of 190 to 310 Kelvins in 256 equally spaced steps. Onboard calibration is performed during each scan. -- From http://dmsp.ngdc.noaa.gov/html/sensors/doc_ols.html"));
                    break;
                }
                case "visibleImagery": {
                    curVariable.addAttribute(new Attribute("_CoordinateAxes", "latitude longitude time"));
                    curVariable.addAttribute(new Attribute("description", "Visible pixels are relative values ranging from 0 to 63 rather than absolute values in Watts per m^2. Instrumental gain levels are adjusted to maintain constant cloud reference values under varying conditions of solar and lunar illumination. Telescope pixel values are replaced by Photo Multiplier Tube (PMT) values at night. -- From http://dmsp.ngdc.noaa.gov/html/sensors/doc_ols.html"));
                }
            }
            this.ncfile.addVariable(null, curVariable);
        }
        this.ncfile.finish();
    }

    @Override
    public Array readData(Variable v2, Section section) throws IOException, InvalidRangeException {
        if (v2 == null) {
            throw new IllegalArgumentException("Variable must not be null.");
        }
        if (section == null) {
            throw new IllegalArgumentException("Section must not be null.");
        }
        List<Range> ranges = section.getRanges();
        if (v2.getShortName().equals(VariableInfo.YEAR.getName())) {
            if (this.cachedYear == null) {
                this.cachedYear = (int[])this.readIntArray1D(VariableInfo.YEAR.getByteOffsetInRecord());
            }
            int[] data = this.cachedYear;
            Array dataArray = Array.factory(DataType.INT, v2.getShape(), (Object)data);
            return dataArray.sectionNoReduce(ranges).copy();
        }
        if (v2.getShortName().equals(VariableInfo.DAY_OF_YEAR.getName())) {
            if (this.cachedDayOfYear == null) {
                this.cachedDayOfYear = (int[])this.readIntArray1D(VariableInfo.DAY_OF_YEAR.getByteOffsetInRecord());
            }
            int[] data = this.cachedDayOfYear;
            Array dataArray = Array.factory(DataType.INT, v2.getShape(), (Object)data);
            return dataArray.sectionNoReduce(ranges).copy();
        }
        if (v2.getShortName().equals(VariableInfo.SECONDS_OF_DAY.getName())) {
            if (this.cachedSecondsOfDay == null) {
                this.cachedSecondsOfDay = (double[])this.readDoubleArray1D(VariableInfo.SECONDS_OF_DAY.getByteOffsetInRecord());
            }
            double[] data = this.cachedSecondsOfDay;
            Array dataArray = Array.factory(DataType.DOUBLE, v2.getShape(), (Object)data);
            return dataArray.sectionNoReduce(ranges).copy();
        }
        if (v2.getShortName().equals(VariableInfo.TIME.getName())) {
            if (this.calculatedTime == null) {
                this.calculatedTime = new float[v2.getShape()[0]];
                Variable curVar = this.ncfile.findVariable(VariableInfo.YEAR.getName());
                this.readData(curVar, curVar.getShapeAsSection());
                curVar = this.ncfile.findVariable(VariableInfo.DAY_OF_YEAR.getName());
                this.readData(curVar, curVar.getShapeAsSection());
                curVar = this.ncfile.findVariable(VariableInfo.SECONDS_OF_DAY.getName());
                this.readData(curVar, curVar.getShapeAsSection());
                Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.US);
                for (int i = 0; i < v2.getShape()[0]; ++i) {
                    calendar.clear();
                    calendar.set(1, this.cachedYear[i]);
                    calendar.set(6, this.cachedDayOfYear[i]);
                    double secOfDay = this.cachedSecondsOfDay[i];
                    double hours = Math.floor(secOfDay / 3600.0);
                    double secOfHour = secOfDay % 3600.0;
                    double mins = Math.floor(secOfHour / 60.0);
                    double secOfMinute = secOfHour % 60.0;
                    double secs = Math.floor(secOfMinute);
                    double millis = Math.floor((secOfMinute - secs) * 1000.0);
                    calendar.add(11, (int)hours);
                    calendar.add(12, (int)mins);
                    calendar.add(13, (int)secs);
                    calendar.add(14, (int)millis);
                    this.calculatedTime[i] = (float)(calendar.getTimeInMillis() - this.startDate.getTime()) / 1000.0f;
                }
                Array dataArray = Array.factory(DataType.FLOAT, v2.getShape(), (Object)this.calculatedTime);
                return dataArray.sectionNoReduce(ranges).copy();
            }
        } else {
            if (v2.getShortName().equals(VariableInfo.SAT_EPHEM_LATITUDE.getName())) {
                if (this.cachedSatEphemLatitude == null) {
                    this.cachedSatEphemLatitude = (float[])this.readFloatArray1D(VariableInfo.SAT_EPHEM_LATITUDE.getByteOffsetInRecord());
                }
                float[] data = this.cachedSatEphemLatitude;
                Array dataArray = Array.factory(DataType.FLOAT, v2.getShape(), (Object)data);
                return dataArray.sectionNoReduce(ranges).copy();
            }
            if (v2.getShortName().equals(VariableInfo.SAT_EPHEM_LONGITUDE.getName())) {
                if (this.cachedSatEphemLongitude == null) {
                    this.cachedSatEphemLongitude = (float[])this.readFloatArray1D(VariableInfo.SAT_EPHEM_LONGITUDE.getByteOffsetInRecord());
                }
                float[] data = this.cachedSatEphemLongitude;
                Array dataArray = Array.factory(DataType.FLOAT, v2.getShape(), (Object)data);
                return dataArray.sectionNoReduce(ranges).copy();
            }
            if (v2.getShortName().equals(VariableInfo.SAT_EPHEM_ALTITUDE.getName())) {
                if (this.cachedSatEphemAltitude == null) {
                    this.cachedSatEphemAltitude = (float[])this.readFloatArray1D(VariableInfo.SAT_EPHEM_ALTITUDE.getByteOffsetInRecord());
                }
                float[] data = this.cachedSatEphemAltitude;
                Array dataArray = Array.factory(DataType.FLOAT, v2.getShape(), (Object)data);
                return dataArray.sectionNoReduce(ranges).copy();
            }
            if (v2.getShortName().equals(VariableInfo.SAT_EPHEM_HEADING.getName())) {
                if (this.cachedSatEphemHeading == null) {
                    this.cachedSatEphemHeading = (float[])this.readFloatArray1D(VariableInfo.SAT_EPHEM_HEADING.getByteOffsetInRecord());
                }
                float[] data = this.cachedSatEphemHeading;
                Array dataArray = Array.factory(DataType.FLOAT, v2.getShape(), (Object)data);
                return dataArray.sectionNoReduce(ranges).copy();
            }
            if (v2.getShortName().equals(VariableInfo.SCANNER_OFFSET.getName())) {
                if (this.cachedScannerOffset == null) {
                    this.cachedScannerOffset = (float[])this.readFloatArray1D(VariableInfo.SCANNER_OFFSET.getByteOffsetInRecord());
                }
                float[] data = this.cachedScannerOffset;
                Array dataArray = Array.factory(DataType.FLOAT, v2.getShape(), (Object)data);
                return dataArray.sectionNoReduce(ranges).copy();
            }
            if (v2.getShortName().equals(VariableInfo.SCAN_DIRECTION.getName())) {
                if (this.cachedScanDirection == null) {
                    this.cachedScanDirection = (byte[])this.readUCharArray1D(VariableInfo.SCAN_DIRECTION.getByteOffsetInRecord());
                }
                byte[] data = this.cachedScanDirection;
                Array dataArray = Array.factory(DataType.BYTE, v2.getShape(), (Object)data);
                return dataArray.sectionNoReduce(ranges).copy();
            }
            if (v2.getShortName().equals(VariableInfo.SOLAR_ELEVATION.getName())) {
                Object data = this.readFloatArray1D(VariableInfo.SOLAR_ELEVATION.getByteOffsetInRecord());
                Array dataArray = Array.factory(DataType.FLOAT, v2.getShape(), data);
                return dataArray.sectionNoReduce(ranges);
            }
            if (v2.getShortName().equals(VariableInfo.SOLAR_AZIMUTH.getName())) {
                Object data = this.readFloatArray1D(VariableInfo.SOLAR_AZIMUTH.getByteOffsetInRecord());
                Array dataArray = Array.factory(DataType.FLOAT, v2.getShape(), data);
                return dataArray.sectionNoReduce(ranges);
            }
            if (v2.getShortName().equals(VariableInfo.LUNAR_ELEVATION.getName())) {
                Object data = this.readFloatArray1D(VariableInfo.LUNAR_ELEVATION.getByteOffsetInRecord());
                Array dataArray = Array.factory(DataType.FLOAT, v2.getShape(), data);
                return dataArray.sectionNoReduce(ranges);
            }
            if (v2.getShortName().equals(VariableInfo.LUNAR_AZIMUTH.getName())) {
                Object data = this.readFloatArray1D(VariableInfo.LUNAR_AZIMUTH.getByteOffsetInRecord());
                Array dataArray = Array.factory(DataType.FLOAT, v2.getShape(), data);
                return dataArray.sectionNoReduce(ranges);
            }
            if (v2.getShortName().equals(VariableInfo.LUNAR_PHASE.getName())) {
                Object data = this.readFloatArray1D(VariableInfo.LUNAR_PHASE.getByteOffsetInRecord());
                Array dataArray = Array.factory(DataType.FLOAT, v2.getShape(), data);
                return dataArray.sectionNoReduce(ranges);
            }
            if (v2.getShortName().equals(VariableInfo.GAIN_CODE.getName())) {
                Object data = this.readFloatArray1D(VariableInfo.GAIN_CODE.getByteOffsetInRecord());
                Array dataArray = Array.factory(DataType.FLOAT, v2.getShape(), data);
                return dataArray.sectionNoReduce(ranges);
            }
            if (v2.getShortName().equals(VariableInfo.GAIN_MODE.getName())) {
                Object data = this.readUCharArray1D(VariableInfo.GAIN_MODE.getByteOffsetInRecord());
                Array dataArray = Array.factory(DataType.BYTE, v2.getShape(), data);
                return dataArray.sectionNoReduce(ranges);
            }
            if (v2.getShortName().equals(VariableInfo.GAIN_SUB_MODE.getName())) {
                Object data = this.readUCharArray1D(VariableInfo.GAIN_SUB_MODE.getByteOffsetInRecord());
                Array dataArray = Array.factory(DataType.BYTE, v2.getShape(), data);
                return dataArray.sectionNoReduce(ranges);
            }
            if (v2.getShortName().equals(VariableInfo.T_CHANNEL_GAIN.getName())) {
                Object data = this.readFloatArray1D(VariableInfo.T_CHANNEL_GAIN.getByteOffsetInRecord());
                Array dataArray = Array.factory(DataType.FLOAT, v2.getShape(), data);
                return dataArray.sectionNoReduce(ranges);
            }
            if (v2.getShortName().equals(VariableInfo.HOT_T_CAL_SEGMENT_ID.getName())) {
                Object data = this.readUCharArray1D(VariableInfo.HOT_T_CAL_SEGMENT_ID.getByteOffsetInRecord());
                Array dataArray = Array.factory(DataType.BYTE, v2.getShape(), data);
                return dataArray.sectionNoReduce(ranges);
            }
            if (v2.getShortName().equals(VariableInfo.COLD_T_CAL_SEGMENT_ID.getName())) {
                Object data = this.readUCharArray1D(VariableInfo.COLD_T_CAL_SEGMENT_ID.getByteOffsetInRecord());
                Array dataArray = Array.factory(DataType.BYTE, v2.getShape(), data);
                return dataArray.sectionNoReduce(ranges);
            }
            if (v2.getShortName().equals(VariableInfo.HOT_T_CAL.getName())) {
                Object data = this.readUCharArray1D(VariableInfo.HOT_T_CAL.getByteOffsetInRecord());
                Array dataArray = Array.factory(DataType.BYTE, v2.getShape(), data);
                return dataArray.sectionNoReduce(ranges);
            }
            if (v2.getShortName().equals(VariableInfo.COLD_T_CAL.getName())) {
                Object data = this.readUCharArray1D(VariableInfo.COLD_T_CAL.getByteOffsetInRecord());
                Array dataArray = Array.factory(DataType.BYTE, v2.getShape(), data);
                return dataArray.sectionNoReduce(ranges);
            }
            if (v2.getShortName().equals(VariableInfo.PMT_CAL.getName())) {
                Object data = this.readUCharArray1D(VariableInfo.PMT_CAL.getByteOffsetInRecord());
                Array dataArray = Array.factory(DataType.BYTE, v2.getShape(), data);
                return dataArray.sectionNoReduce(ranges);
            }
            if (v2.getShortName().equals(VariableInfo.VISIBLE_SCAN_QUALITY_FLAG.getName())) {
                Object data = this.readIntArray1D(VariableInfo.VISIBLE_SCAN_QUALITY_FLAG.getByteOffsetInRecord());
                Array dataArray = Array.factory(DataType.INT, v2.getShape(), data);
                return dataArray.sectionNoReduce(ranges);
            }
            if (v2.getShortName().equals(VariableInfo.THERMAL_SCAN_QUALITY_FLAG.getName())) {
                Object data = this.readIntArray1D(VariableInfo.THERMAL_SCAN_QUALITY_FLAG.getByteOffsetInRecord());
                Array dataArray = Array.factory(DataType.INT, v2.getShape(), data);
                return dataArray.sectionNoReduce(ranges);
            }
            if (v2.getShortName().equals(VariableInfo.VISIBLE_SCAN.getName())) {
                Object data = this.readByteArray2D(VariableInfo.VISIBLE_SCAN.getByteOffsetInRecord(), VariableInfo.VISIBLE_SCAN.getNumElementsInRecord());
                Array dataArray = Array.factory(DataType.BYTE, v2.getShape(), data);
                return dataArray.sectionNoReduce(ranges);
            }
            if (v2.getShortName().equals(VariableInfo.THERMAL_SCAN.getName())) {
                Object data = this.readByteArray2D(VariableInfo.THERMAL_SCAN.getByteOffsetInRecord(), VariableInfo.THERMAL_SCAN.getNumElementsInRecord());
                Array dataArray = Array.factory(DataType.BYTE, v2.getShape(), data);
                return dataArray.sectionNoReduce(ranges);
            }
            if (v2.getShortName().equals(VariableInfo.LATITUDE.getName()) || v2.getShortName().equals(VariableInfo.LONGITUDE.getName())) {
                if (this.calculatedLatitude == null && this.calculatedLongitude == null) {
                    this.calculatedLatitude = new float[this.header.getNumDataRecords() * this.header.getNumSamplesPerBandDim().getLength()];
                    this.calculatedLongitude = new float[this.header.getNumDataRecords() * this.header.getNumSamplesPerBandDim().getLength()];
                    Variable curVar = this.ncfile.findVariable(VariableInfo.SCANNER_OFFSET.getName());
                    this.readData(curVar, curVar.getShapeAsSection());
                    curVar = this.ncfile.findVariable(VariableInfo.SAT_EPHEM_LATITUDE.getName());
                    this.readData(curVar, curVar.getShapeAsSection());
                    curVar = this.ncfile.findVariable(VariableInfo.SAT_EPHEM_LONGITUDE.getName());
                    this.readData(curVar, curVar.getShapeAsSection());
                    curVar = this.ncfile.findVariable(VariableInfo.SAT_EPHEM_ALTITUDE.getName());
                    this.readData(curVar, curVar.getShapeAsSection());
                    curVar = this.ncfile.findVariable(VariableInfo.SAT_EPHEM_HEADING.getName());
                    this.readData(curVar, curVar.getShapeAsSection());
                    int satID = Integer.parseInt(this.ncfile.getRootGroup().findAttribute("spacecraftId").getStringValue().substring(1));
                    GeolocateOLS.geolocateOLS(satID, 0, this.header.getNumDataRecords(), this.cachedScannerOffset, this.cachedSatEphemLatitude, this.cachedSatEphemLongitude, this.cachedSatEphemAltitude, this.cachedSatEphemHeading, this.calculatedLatitude, this.calculatedLongitude);
                }
                float[] data = v2.getShortName().equals(VariableInfo.LATITUDE.getName()) ? this.calculatedLatitude : this.calculatedLongitude;
                Array dataArray = Array.factory(DataType.FLOAT, v2.getShape(), (Object)data);
                return dataArray.sectionNoReduce(ranges).copy();
            }
            throw new IOException("Requested variable <name=" + v2.getShortName() + "> not in DMSP file.");
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.header = null;
    }

    Object readUCharArray1D(int offsetInRecord) throws IOException {
        int elementSizeInBytes = 4;
        byte[] elementArray = new byte[elementSizeInBytes];
        byte[] array = new byte[this.header.getNumDataRecords()];
        this.raf.seek(this.header.getRecordSizeInBytes() * this.header.getNumHeaderRecords() + offsetInRecord);
        for (int i = 0; i < this.header.getNumDataRecords(); ++i) {
            this.raf.readFully(elementArray);
            array[i] = elementArray[3];
            this.raf.skipBytes(this.header.getRecordSizeInBytes() - elementSizeInBytes);
        }
        return array;
    }

    Object readIntArray1D(int offsetInRecord) throws IOException {
        int elementSizeInBytes = 4;
        int[] array = new int[this.header.getNumDataRecords()];
        this.raf.seek(this.header.getRecordSizeInBytes() * this.header.getNumHeaderRecords() + offsetInRecord);
        for (int i = 0; i < this.header.getNumDataRecords(); ++i) {
            this.raf.readInt(array, i, 1);
            this.raf.skipBytes(this.header.getRecordSizeInBytes() - elementSizeInBytes);
        }
        return array;
    }

    Object readFloatArray1D(int offsetInRecord) throws IOException {
        int elementSizeInBytes = 4;
        float[] array = new float[this.header.getNumDataRecords()];
        this.raf.seek(this.header.getRecordSizeInBytes() * this.header.getNumHeaderRecords() + offsetInRecord);
        for (int i = 0; i < this.header.getNumDataRecords(); ++i) {
            this.raf.readFloat(array, i, 1);
            this.raf.skipBytes(this.header.getRecordSizeInBytes() - elementSizeInBytes);
        }
        return array;
    }

    Object readDoubleArray1D(int offsetInRecord) throws IOException {
        int elementSizeInBytes = 8;
        double[] array = new double[this.header.getNumDataRecords()];
        this.raf.seek(this.header.getRecordSizeInBytes() * this.header.getNumHeaderRecords() + offsetInRecord);
        for (int i = 0; i < this.header.getNumDataRecords(); ++i) {
            this.raf.readDouble(array, i, 1);
            this.raf.skipBytes(this.header.getRecordSizeInBytes() - elementSizeInBytes);
        }
        return array;
    }

    Object readByteArray2D(int offsetInRecord, int numElementsInRecord) throws IOException {
        byte[] array = new byte[this.header.getNumDataRecords() * numElementsInRecord];
        this.raf.seek(this.header.getRecordSizeInBytes() * this.header.getNumHeaderRecords() + offsetInRecord);
        for (int i = 0; i < this.header.getNumDataRecords(); ++i) {
            this.raf.readFully(array, i * numElementsInRecord, numElementsInRecord);
            this.raf.skipBytes(this.header.getRecordSizeInBytes() - numElementsInRecord);
        }
        return array;
    }

    static class VectorMath {
        VectorMath() {
        }

        static double vectorMagnitude(double[] vector) {
            if (vector.length != 3) {
                throw new IllegalArgumentException("Argument not a 3-D vector <dim=" + vector.length + ">.");
            }
            return Math.sqrt(Math.pow(vector[0], 2.0) + Math.pow(vector[1], 2.0) + Math.pow(vector[2], 2.0));
        }

        static double[] unitVector(double[] vector) {
            if (vector.length != 3) {
                throw new IllegalArgumentException("Argument not a 3-D vector <dim=" + vector.length + ">.");
            }
            double magnitude = VectorMath.vectorMagnitude(vector);
            return new double[]{vector[0] / magnitude, vector[1] / magnitude, vector[2] / magnitude};
        }

        static double[] vectorScalarMultiplication(double[] vector, double scalar) {
            if (vector.length != 3) {
                throw new IllegalArgumentException("Argument not a 3-D vector <dim=" + vector.length + ">.");
            }
            return new double[]{scalar * vector[0], scalar * vector[1], scalar * vector[2]};
        }

        static double vectorDotProduct(double[] vectorA, double[] vectorB) {
            if (vectorA.length != 3) {
                throw new IllegalArgumentException("First argument not a 3-D vector <dim=" + vectorA.length + ">.");
            }
            if (vectorB.length != 3) {
                throw new IllegalArgumentException("Second argument not a 3-D vector <dim=" + vectorB.length + ">.");
            }
            return vectorA[0] * vectorB[0] + vectorA[1] * vectorB[1] + vectorA[2] * vectorB[2];
        }

        static double[] vectorCrossProduct(double[] vectorA, double[] vectorB) {
            if (vectorA.length != 3) {
                throw new IllegalArgumentException("First argument not a 3-D vector <dim=" + vectorA.length + ">.");
            }
            if (vectorB.length != 3) {
                throw new IllegalArgumentException("Second argument not a 3-D vector <dim=" + vectorB.length + ">.");
            }
            double[] resultingVector = new double[]{vectorA[1] * vectorB[2] - vectorA[2] * vectorB[1], vectorA[2] * vectorB[0] - vectorA[0] * vectorB[2], vectorA[0] * vectorB[1] - vectorA[1] * vectorB[0]};
            return resultingVector;
        }
    }

    static class EllipsoidalEarthModel {
        static final double EARTH_MEAN_EQUATORIAL_RADIUS_KM = 6378.14;
        static final double EARTHS_ECCENTRICITY = 0.081819183;
        static final double E_ECC_SQUARED = Math.pow(0.081819183, 2.0);

        EllipsoidalEarthModel() {
        }

        static double earthRadius(double gcLatitude) {
            return Math.sqrt(1.0 - E_ECC_SQUARED) / Math.sqrt(1.0 - E_ECC_SQUARED * Math.cos(gcLatitude));
        }

        static double earthRadiusKm(double gcLatitude) {
            return EllipsoidalEarthModel.earthRadius(gcLatitude) * 6378.14;
        }

        static double geodeticToGeocentric(double geodeticLatitude) {
            return Math.atan((1.0 - E_ECC_SQUARED) * Math.tan(geodeticLatitude));
        }

        static double geocentricToGeodetic(double geocentricLatitude) {
            return Math.atan(Math.tan(geocentricLatitude) / (1.0 - E_ECC_SQUARED));
        }
    }

    static class OLSSensorModel {
        static final int NUM_DATA_TYPES = 4;
        static final int NUM_SAT_GROUPS = 2;
        static final int[][] RANGE_SAT_GROUPS = new int[][]{{11, 16}, {15, 20}};
        static final double peakScanAngle = 1.00967;
        static final double[] nominalTotalSamplePeriod = new double[]{1464.436, 1464.436, 7322.179, 7322.179};
        static final int[] numSamplesPerScan = new int[]{1465, 1465, 7322, 7322};
        static final double M = 2.66874;
        static final double[][] B = new double[][]{{0.23686, 0.23591, 0.23665, 0.23665}, {0.23686, 0.23686, 0.23665, 0.23665}};

        OLSSensorModel() {
        }

        static double scanAngleOLS(int satID, int dataType, int sampleNumber, double scannerOffset) {
            if (sampleNumber > 1464) {
                throw new IllegalArgumentException("Sample number <" + sampleNumber + "> not within smooth sample range <0-1464> (fine data not currently supported).");
            }
            int satGroup = satID <= 15 ? 0 : 1;
            return 1.00967 * Math.cos((double)sampleNumber / nominalTotalSamplePeriod[dataType] * 2.66874 + B[satGroup][dataType]) - scannerOffset;
        }
    }

    static class GeolocateOLS {
        static final double PI = Math.PI;
        static final double TWO_PI = Math.PI * 2;
        static final double HALF_PI = 1.5707963267948966;
        static final double DEGREES_PER_RADIANS = 57.29577951308232;

        GeolocateOLS() {
        }

        static void geolocateOLS(int satID, int dataType, int numScans, float[] scannerOffset, float[] satEphemLatitude, float[] satEphemLongitude, float[] satEphemAltitude, float[] satEphemHeading, float[] latitude, float[] longitude) {
            if (satID < OLSSensorModel.RANGE_SAT_GROUPS[0][0] || satID > OLSSensorModel.RANGE_SAT_GROUPS[1][1]) {
                throw new IllegalArgumentException("Satellite ID <" + satID + "> outside supported range <min=" + OLSSensorModel.RANGE_SAT_GROUPS[0][0] + ",max=" + OLSSensorModel.RANGE_SAT_GROUPS[1][1] + ">.");
            }
            if (dataType < 0 || dataType > 4) {
                throw new IllegalArgumentException("Data type <" + dataType + "> not in valid range <min=0,max=" + 4 + ">.");
            }
            if (scannerOffset.length != numScans) {
                throw new IllegalArgumentException("Size of scannerOffset vector <" + scannerOffset.length + "> not as expected <" + numScans + ">.");
            }
            if (satEphemLatitude.length != numScans) {
                throw new IllegalArgumentException("Size of satEphemLatitude vector <" + satEphemLatitude.length + "> not as expected <" + numScans + ">.");
            }
            if (satEphemLongitude.length != numScans) {
                throw new IllegalArgumentException("Size of satEphemLongitude vector <" + satEphemLongitude.length + "> not as expected <" + numScans + ">.");
            }
            if (satEphemAltitude.length != numScans) {
                throw new IllegalArgumentException("Size of satEphemAltitude vector <" + satEphemAltitude.length + "> not as expected <" + numScans + ">.");
            }
            if (satEphemHeading.length != numScans) {
                throw new IllegalArgumentException("Size of satEphemHeading vector <" + satEphemHeading.length + "> not as expected <" + numScans + ">.");
            }
            if (latitude.length != OLSSensorModel.numSamplesPerScan[dataType] * numScans) {
                throw new IllegalArgumentException("Size of latitude vector <" + latitude.length + "> not as expected <" + OLSSensorModel.numSamplesPerScan[dataType] + " * " + numScans + ">.");
            }
            if (longitude.length != OLSSensorModel.numSamplesPerScan[dataType] * numScans) {
                throw new IllegalArgumentException("Size of longitude vector <" + longitude.length + "> not as expected <" + OLSSensorModel.numSamplesPerScan[dataType] + " * " + numScans + ">.");
            }
            double[] surfaceNormal = new double[3];
            double[] satPoint = new double[3];
            double[] north = new double[3];
            double[] satHeading = new double[3];
            double[] scanPoint = new double[3];
            double[] lineOfSightSlope = new double[3];
            double[] geolocatedPoint = new double[3];
            double[] scratchVec = new double[3];
            for (int swathIndex = 0; swathIndex < numScans; ++swathIndex) {
                double gdLatitude = GeolocateOLS.degreesToRadians(satEphemLatitude[swathIndex]);
                double gdLongitude = GeolocateOLS.degreesToRadians(satEphemLongitude[swathIndex]);
                double satAltitude = satEphemAltitude[swathIndex];
                double satHeadingAngle = GeolocateOLS.degreesToRadians(satEphemHeading[swathIndex]);
                double gcLatitude = EllipsoidalEarthModel.geodeticToGeocentric(gdLatitude);
                double gcLongitude = gdLongitude;
                double cosLat = Math.cos(gcLatitude);
                double sinLat = Math.sin(gcLatitude);
                double cosLon = Math.cos(gcLongitude);
                double sinLon = Math.sin(gcLongitude);
                double earthRadius = EllipsoidalEarthModel.earthRadiusKm(gcLatitude);
                scratchVec[0] = cosLat * cosLon;
                scratchVec[1] = cosLat * sinLon;
                scratchVec[2] = sinLat;
                double[] subSatPoint = VectorMath.vectorScalarMultiplication(scratchVec, earthRadius);
                cosLat = Math.cos(gdLatitude);
                sinLat = Math.sin(gdLatitude);
                cosLon = Math.cos(gdLongitude);
                sinLon = Math.sin(gdLongitude);
                surfaceNormal[0] = cosLat * cosLon;
                surfaceNormal[1] = cosLat * sinLon;
                surfaceNormal[2] = sinLat;
                satPoint[0] = subSatPoint[0] + surfaceNormal[0] * satAltitude;
                satPoint[1] = subSatPoint[1] + surfaceNormal[1] * satAltitude;
                satPoint[2] = subSatPoint[2] + surfaceNormal[2] * satAltitude;
                north[0] = -subSatPoint[0];
                north[1] = -subSatPoint[1];
                north[2] = EllipsoidalEarthModel.earthRadiusKm(1.5707963267948966) - subSatPoint[2];
                double projectMag = VectorMath.vectorDotProduct(north, surfaceNormal) / Math.pow(VectorMath.vectorMagnitude(surfaceNormal), 2.0);
                north[0] = north[0] - projectMag * surfaceNormal[0];
                north[1] = north[1] - projectMag * surfaceNormal[1];
                north[2] = north[2] - projectMag * surfaceNormal[2];
                north = VectorMath.unitVector(north);
                double[] west = VectorMath.vectorCrossProduct(surfaceNormal, north);
                west = VectorMath.unitVector(west);
                double cosHeading = Math.cos(satHeadingAngle);
                double sinHeading = Math.sin(satHeadingAngle);
                satHeading[0] = sinHeading * west[0] + cosHeading * north[0];
                satHeading[1] = sinHeading * west[1] + cosHeading * north[1];
                satHeading[2] = sinHeading * west[2] + cosHeading * north[2];
                double[] scanLine = VectorMath.vectorCrossProduct(surfaceNormal, satHeading);
                for (int sampleIndex = 0; sampleIndex < OLSSensorModel.numSamplesPerScan[dataType]; ++sampleIndex) {
                    double quadraticSoln2;
                    double scannerAngle = OLSSensorModel.scanAngleOLS(satID, dataType, sampleIndex, scannerOffset[swathIndex]);
                    double scanPointMag = satAltitude * Math.tan(scannerAngle);
                    scanPoint[0] = subSatPoint[0] + scanPointMag * scanLine[0];
                    scanPoint[1] = subSatPoint[1] + scanPointMag * scanLine[1];
                    scanPoint[2] = subSatPoint[2] + scanPointMag * scanLine[2];
                    lineOfSightSlope[0] = scanPoint[0] - satPoint[0];
                    lineOfSightSlope[1] = scanPoint[1] - satPoint[1];
                    lineOfSightSlope[2] = scanPoint[2] - satPoint[2];
                    double earthMajorAxis = EllipsoidalEarthModel.earthRadiusKm(0.0);
                    double earthMinorAxis = EllipsoidalEarthModel.earthRadiusKm(1.5707963267948966);
                    double earthMajorAxisSquared = Math.pow(earthMajorAxis, 2.0);
                    double earthMinorAxisSquared = Math.pow(earthMinorAxis, 2.0);
                    double quadraticEqnA = earthMinorAxisSquared * Math.pow(lineOfSightSlope[0], 2.0) + earthMinorAxisSquared * Math.pow(lineOfSightSlope[1], 2.0) + earthMajorAxisSquared * Math.pow(lineOfSightSlope[2], 2.0);
                    double quadraticEqnB = 2.0 * (earthMinorAxisSquared * satPoint[0] * lineOfSightSlope[0] + earthMinorAxisSquared * satPoint[1] * lineOfSightSlope[1] + earthMajorAxisSquared * satPoint[2] * lineOfSightSlope[2]);
                    double quadraticEqnC = earthMinorAxisSquared * Math.pow(satPoint[0], 2.0) + earthMinorAxisSquared * Math.pow(satPoint[1], 2.0) + earthMajorAxisSquared * Math.pow(satPoint[2], 2.0) - earthMajorAxisSquared * earthMinorAxisSquared;
                    double scratch = Math.sqrt(Math.pow(quadraticEqnB, 2.0) - 4.0 * quadraticEqnA * quadraticEqnC);
                    double quadraticSoln1 = (-quadraticEqnB + scratch) / (2.0 * quadraticEqnA);
                    double lineParameter = quadraticSoln1 < (quadraticSoln2 = (-quadraticEqnB - scratch) / (2.0 * quadraticEqnA)) ? quadraticSoln1 : quadraticSoln2;
                    geolocatedPoint[0] = lineOfSightSlope[0] * lineParameter + satPoint[0];
                    geolocatedPoint[1] = lineOfSightSlope[1] * lineParameter + satPoint[1];
                    geolocatedPoint[2] = lineOfSightSlope[2] * lineParameter + satPoint[2];
                    double[] unitVecGeolocatedPoint = VectorMath.unitVector(geolocatedPoint);
                    double gcLat = Math.asin(unitVecGeolocatedPoint[2]);
                    double gcLon = Math.acos(unitVecGeolocatedPoint[0] / Math.cos(gcLat));
                    gcLon = unitVecGeolocatedPoint[1] < 0.0 ? -gcLon : gcLon;
                    int currentSampleIndex = swathIndex * OLSSensorModel.numSamplesPerScan[dataType] + sampleIndex;
                    latitude[currentSampleIndex] = (float)GeolocateOLS.radiansToDegrees(gcLat);
                    longitude[currentSampleIndex] = (float)GeolocateOLS.radiansToDegrees(gcLon);
                }
            }
        }

        static double degreesToRadians(double angleInDegrees) {
            return angleInDegrees / 57.29577951308232;
        }

        static double radiansToDegrees(double angleInRadians) {
            return angleInRadians * 57.29577951308232;
        }
    }

    private static class VariableInfo {
        private static List<VariableInfo> list = new ArrayList<VariableInfo>(30);
        private static Map<String, VariableInfo> hash = new HashMap<String, VariableInfo>(30);
        public static final VariableInfo YEAR = new VariableInfo("year", "year at time of scan", "year", DataType.INT, 0, 1);
        public static final VariableInfo DAY_OF_YEAR = new VariableInfo("dayOfYear", "day of year at time of scan", "day of year", DataType.INT, 4, 1);
        public static final VariableInfo SECONDS_OF_DAY = new VariableInfo("secondsOfDay", "seconds of day at time of scan", "seconds of day", DataType.DOUBLE, 8, 1);
        public static final VariableInfo TIME = new VariableInfo("time", "time of scan", "seconds since ??? (see above)", DataType.FLOAT, -1, 1);
        public static final VariableInfo SAT_EPHEM_LATITUDE = new VariableInfo("satEphemLatitude", "geodetic latitude of the satellite for this scan", "degrees_north", DataType.FLOAT, 16, 1);
        public static final VariableInfo SAT_EPHEM_LONGITUDE = new VariableInfo("satEphemLongitude", "longitude of the satellite for this scan", "degrees_east", DataType.FLOAT, 20, 1);
        public static final VariableInfo SAT_EPHEM_ALTITUDE = new VariableInfo("satEphemAltitude", "altitude of the satellite for this scan", "kilometers", DataType.FLOAT, 24, 1);
        public static final VariableInfo SAT_EPHEM_HEADING = new VariableInfo("satEphemHeading", "heading of the satellite (degrees west of north) for this scan", "degrees", DataType.FLOAT, 28, 1);
        public static final VariableInfo SCANNER_OFFSET = new VariableInfo("scannerOffset", "scanner offset", "radians", DataType.FLOAT, 32, 1);
        public static final VariableInfo SCAN_DIRECTION = new VariableInfo("scanDirection", "scan direction", "", DataType.BYTE, 36, 1);
        public static final VariableInfo SOLAR_ELEVATION = new VariableInfo("solarElevation", "solar elevation", "degrees", DataType.FLOAT, 40, 1);
        public static final VariableInfo SOLAR_AZIMUTH = new VariableInfo("solarAzimuth", "solar azimuth", "degrees", DataType.FLOAT, 44, 1);
        public static final VariableInfo LUNAR_ELEVATION = new VariableInfo("lunarElevation", "lunar elevation", "degrees", DataType.FLOAT, 48, 1);
        public static final VariableInfo LUNAR_AZIMUTH = new VariableInfo("lunarAzimuth", "lunar azimuth", "degrees", DataType.FLOAT, 52, 1);
        public static final VariableInfo LUNAR_PHASE = new VariableInfo("lunarPhase", "lunar phase", "degrees", DataType.FLOAT, 56, 1);
        public static final VariableInfo GAIN_CODE = new VariableInfo("gainCode", "gain code", "decibels", DataType.FLOAT, 60, 1);
        public static final VariableInfo GAIN_MODE = new VariableInfo("gainMode", "gain mode (0=linear, 1=logrithmic)", "", DataType.BYTE, 64, 1);
        public static final VariableInfo GAIN_SUB_MODE = new VariableInfo("gainSubMode", "gain sub-mode", "", DataType.BYTE, 68, 1);
        public static final VariableInfo HOT_T_CAL_SEGMENT_ID = new VariableInfo("hotTCalSegmentID", "Hot T cal seg ID (0 = right, 1 = left)", "", DataType.BYTE, 72, 1);
        public static final VariableInfo COLD_T_CAL_SEGMENT_ID = new VariableInfo("coldTCalSegmentID", "Cold T cal seg ID (0 = right, 1 = left)", "", DataType.BYTE, 76, 1);
        public static final VariableInfo HOT_T_CAL = new VariableInfo("hotTCal", "Hot T calibration", "", DataType.BYTE, 80, 1);
        public static final VariableInfo COLD_T_CAL = new VariableInfo("coldTCal", "Cold T calibration", "", DataType.BYTE, 84, 1);
        public static final VariableInfo PMT_CAL = new VariableInfo("pmtCal", "Photomultiplier tube calibration", "", DataType.BYTE, 88, 1);
        public static final VariableInfo T_CHANNEL_GAIN = new VariableInfo("tChannelGain", "T channel gain", "decibels", DataType.FLOAT, 92, 1);
        public static final VariableInfo VISIBLE_SCAN_QUALITY_FLAG = new VariableInfo("visibleScanQualityFlag", "quality flag for the visible scan", "", DataType.INT, 96, 1);
        public static final VariableInfo THERMAL_SCAN_QUALITY_FLAG = new VariableInfo("thermalScanQualityFlag", "quality flag for the thermal scan", "", DataType.INT, 1568, 1);
        public static final VariableInfo LATITUDE = new VariableInfo("latitude", "latitude of pixel", "degrees_north", DataType.FLOAT, -1, 1465);
        public static final VariableInfo LONGITUDE = new VariableInfo("longitude", "longitude of pixel", "degrees_east", DataType.FLOAT, -1, 1465);
        public static final VariableInfo VISIBLE_SCAN = new VariableInfo("visibleImagery", "visible imagery  (6-bit per pixel)", "", DataType.UBYTE, 100, 1465);
        public static final VariableInfo THERMAL_SCAN = new VariableInfo("infraredImagery", "infrared imagery (8-bit per pixel)", "kelvin", DataType.UBYTE, 1572, 1465);
        private String name;
        private String longName;
        private String units;
        private DataType dataType;
        private int byteOffsetInRecord;
        private int numElementsInRecord;

        private VariableInfo(String name, String long_name, String units, DataType dataType, int byteOffsetInRecord, int numElementsInRecord) {
            this.name = name;
            this.longName = long_name;
            this.units = units;
            this.dataType = dataType;
            this.byteOffsetInRecord = byteOffsetInRecord;
            this.numElementsInRecord = numElementsInRecord;
            list.add(this);
            hash.put(this.name, this);
        }

        public static List getAll() {
            return list;
        }

        public static Set getAllNames() {
            return hash.keySet();
        }

        public String getName() {
            return this.name;
        }

        public String getLongName() {
            return this.longName;
        }

        public String getUnits() {
            return this.units;
        }

        public DataType getDataType() {
            return this.dataType;
        }

        public int getByteOffsetInRecord() {
            return this.byteOffsetInRecord;
        }

        public int getNumElementsInRecord() {
            return this.numElementsInRecord;
        }

        public String toString() {
            String retVal = "Variable(" + this.getName() + "," + this.getLongName() + "," + this.getUnits() + "," + (Object)((Object)this.getDataType()) + "," + this.getByteOffsetInRecord() + "," + this.getNumElementsInRecord() + ")";
            return retVal;
        }
    }
}

