/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.wizard;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JComponent;
import org.netbeans.spi.wizard.SimpleWizard;
import org.netbeans.spi.wizard.Wizard;
import org.netbeans.spi.wizard.WizardController;
import org.netbeans.spi.wizard.WizardException;
import org.netbeans.spi.wizard.WizardPage;

public abstract class WizardPanelProvider {
    final String title;
    final String[] descriptions;
    final String[] steps;
    final String[] knownProblems;
    private Wizard wizard;

    protected WizardPanelProvider(String[] steps, String[] descriptions) {
        this(null, steps, descriptions);
    }

    protected WizardPanelProvider(String title, String[] steps, String[] descriptions) {
        this.title = title;
        this.steps = steps;
        this.descriptions = descriptions;
        this.knownProblems = new String[steps.length];
        if (steps.length != descriptions.length) {
            throw new IllegalArgumentException("Length of steps and descriptions arrays do not match");
        }
        String v = this.validData(steps, descriptions);
        if (v != null) {
            throw new RuntimeException(v);
        }
    }

    private String validData(String[] steps, String[] descriptions) {
        if (steps.length != descriptions.length) {
            return steps.length + " steps but " + descriptions.length + " descriptions";
        }
        for (int i = 0; i < steps.length; ++i) {
            if (steps[i] == null) {
                throw new NullPointerException("Step id " + i + " is null");
            }
            if (descriptions[i] != null) continue;
            throw new NullPointerException("Description " + i + " is null");
        }
        if (new HashSet<String>(Arrays.asList(steps)).size() != steps.length) {
            return "Duplicate step ids: " + Arrays.asList(steps);
        }
        return null;
    }

    protected WizardPanelProvider(String title, String singleStep, String singleDescription) {
        this(title, new String[]{singleStep}, new String[]{singleDescription});
    }

    protected abstract JComponent createPanel(WizardController var1, String var2, Map var3);

    protected Object finish(Map settings) throws WizardException {
        return settings;
    }

    protected void recycleExistingPanel(String id, WizardController controller, Map wizardData, JComponent panel) {
    }

    void recycle(String id, WizardController controller, Map wizardData, JComponent panel) {
        if (panel instanceof WizardPage) {
            WizardPage page = (WizardPage)panel;
            page.setController(controller);
            page.setWizardDataMap(wizardData);
            page.recycle();
        }
        this.recycleExistingPanel(id, controller, wizardData, panel);
    }

    public final Wizard createWizard() {
        if (this.wizard == null) {
            this.wizard = new Wizard(new SimpleWizard(this));
        }
        return this.wizard;
    }

    public String getLongDescription(String stepId) {
        return null;
    }

    protected final int indexOfStep(String id) {
        return Arrays.asList(this.steps).indexOf(id);
    }

    void setKnownProblem(String problem, int idx) {
        if (idx >= 0) {
            this.knownProblems[idx] = problem;
        }
    }

    String getKnownProblem(int idx) {
        return this.knownProblems[idx];
    }

    public boolean cancel(Map settings) {
        return true;
    }

    public String toString() {
        return super.toString() + " with wizard " + this.wizard;
    }
}

