/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.io;

import java.io.Writer;
import org.codehaus.jackson.util.BufferRecycler;
import org.codehaus.jackson.util.TextBuffer;

public final class SegmentedStringWriter
extends Writer {
    final TextBuffer _buffer;

    public SegmentedStringWriter(BufferRecycler bufferRecycler) {
        this._buffer = new TextBuffer(bufferRecycler);
    }

    @Override
    public Writer append(char c) {
        this.write(c);
        return this;
    }

    @Override
    public Writer append(CharSequence charSequence) {
        String string = ((Object)charSequence).toString();
        this._buffer.append(string, 0, string.length());
        return this;
    }

    @Override
    public Writer append(CharSequence charSequence, int n, int n2) {
        String string = ((Object)charSequence.subSequence(n, n2)).toString();
        this._buffer.append(string, 0, string.length());
        return this;
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    @Override
    public void write(char[] cArray) {
        this._buffer.append(cArray, 0, cArray.length);
    }

    @Override
    public void write(char[] cArray, int n, int n2) {
        this._buffer.append(cArray, n, n2);
    }

    @Override
    public void write(int n) {
        this._buffer.append((char)n);
    }

    @Override
    public void write(String string) {
        this._buffer.append(string, 0, string.length());
    }

    @Override
    public void write(String string, int n, int n2) {
        this._buffer.append(string, 0, string.length());
    }

    public String getAndClear() {
        String string = this._buffer.contentsAsString();
        this._buffer.releaseBuffers();
        return string;
    }
}

