/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.view;

import gov.nasa.worldwind.animation.AnimationSupport;
import gov.nasa.worldwind.animation.DoubleAnimator;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.util.PropertyAccessor;

public class ViewElevationAnimator
extends DoubleAnimator {
    protected Globe globe;
    protected LatLon endLatLon;
    protected int altitudeMode;
    protected double midZoom;
    protected boolean useMidZoom = true;
    protected double trueEndZoom;

    public ViewElevationAnimator(Globe globe, double d, double d2, LatLon latLon, LatLon latLon2, int n, PropertyAccessor.DoubleAccessor doubleAccessor) {
        super(null, d, d2, doubleAccessor);
        this.endLatLon = latLon2;
        this.altitudeMode = n;
        if (globe == null) {
            this.useMidZoom = false;
        } else {
            this.globe = globe;
            this.midZoom = ViewElevationAnimator.computeMidZoom(globe, latLon, latLon2, d, d2);
            this.useMidZoom = this.useMidZoom(d, d2, this.midZoom);
        }
        if (this.useMidZoom) {
            this.trueEndZoom = d2;
            this.end = this.midZoom;
        }
    }

    public double getTrueEndZoom() {
        return this.trueEndZoom;
    }

    public boolean getUseMidZoom() {
        return this.useMidZoom;
    }

    @Override
    public void setEnd(Double d) {
        if (this.getUseMidZoom()) {
            this.trueEndZoom = d;
        } else {
            this.end = d;
        }
    }

    @Override
    public void set(double d) {
        if (d >= 1.0) {
            this.stop();
        }
        if (this.useMidZoom) {
            double d2 = this.zoomInterpolant(d, 0.0, 1.0, 1);
            double d3 = d <= 0.5 ? this.nextDouble(d2, this.begin, this.end) : this.nextDouble(d2, this.end, this.trueEndZoom);
            this.propertyAccessor.setDouble(d3);
        } else {
            double d4 = AnimationSupport.basicInterpolant(d, 0.0, 1.0, 1);
            super.set(d4);
        }
    }

    private double zoomInterpolant(double d, double d2, double d3, int n) {
        double d4 = AnimationSupport.interpolantNormalized(d, d2, d3);
        d4 = d4 <= 0.5 ? (d4 *= 2.0) : (d4 - 0.5) * 2.0;
        return AnimationSupport.interpolantSmoothed(d4, n);
    }

    @Override
    public Double nextDouble(double d) {
        return this.nextDouble(d, this.begin, this.end);
    }

    protected double nextDouble(double d, double d2, double d3) {
        double d4 = AnimationSupport.mixDouble(d, d2, d3);
        double d5 = 0.0;
        boolean bl = false;
        if (this.globe != null && this.altitudeMode == 1) {
            bl = true;
            d5 = this.globe.getElevation(this.endLatLon.getLatitude(), this.endLatLon.getLongitude());
        } else if (this.globe != null && this.altitudeMode == 2) {
            bl = true;
            d5 = this.globe.getElevation(this.endLatLon.getLatitude(), this.endLatLon.getLongitude()) + d3;
        }
        if (bl) {
            d4 = (1.0 - d) * d2 + d * d5;
        }
        return d4;
    }

    @Override
    protected void setImpl(double d) {
        Double d2 = this.nextDouble(d);
        if (d2 == null) {
            return;
        }
        boolean bl = this.propertyAccessor.setDouble(d2);
        if (!bl) {
            this.flagLastStateInvalid();
        }
        if (d >= 1.0) {
            this.stop();
        }
    }

    protected static double computeMidZoom(Globe globe, LatLon latLon, LatLon latLon2, double d, double d2) {
        Angle angle = LatLon.greatCircleDistance(latLon, latLon2);
        double d3 = AnimationSupport.angularRatio(angle, Angle.POS180);
        double d4 = Math.min(d, d2);
        double d5 = 3.0 * globe.getRadius();
        return AnimationSupport.mixDouble(d3, d4, d5);
    }

    protected boolean useMidZoom(double d, double d2, double d3) {
        double d4;
        double d5 = Math.abs(d2 - d);
        return d5 < (d4 = Math.abs(d3 - Math.max(d, d2)));
    }
}

