/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util.tree;

import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.render.BasicWWTexture;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.util.tree.TreeNode;
import gov.nasa.worldwind.util.tree.TreePath;
import java.beans.PropertyChangeEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class BasicTreeNode
extends WWObjectImpl
implements TreeNode {
    protected String text;
    protected Object imageSource;
    protected BasicWWTexture texture;
    protected String description;
    protected TreeNode parent;
    protected List<TreeNode> children;
    protected boolean enabled = true;
    protected boolean selected;
    protected boolean visible = true;
    protected String treeSelected;

    public BasicTreeNode(String string) {
        this(string, null);
    }

    public BasicTreeNode(String string, Object object) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.text = string.trim();
        this.setImageSource(object);
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public void setParent(TreeNode treeNode) {
        this.parent = treeNode;
    }

    @Override
    public Iterable<TreeNode> getChildren() {
        if (this.children != null) {
            return Collections.unmodifiableList(this.children);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean bl) {
        boolean bl2 = this.isSelected();
        this.selected = bl;
        this.treeSelected = null;
        if (bl2 != bl) {
            this.firePropertyChange("gov.nasa.worldwind.avkey.TreeNode", null, this);
        }
    }

    @Override
    public String isTreeSelected() {
        if (this.treeSelected == null) {
            this.treeSelected = this.computeTreeSelected();
        }
        return this.treeSelected;
    }

    protected String computeTreeSelected() {
        String string = this.isSelected() ? "util.tree.Selected" : "util.tree.NotSelected";
        for (TreeNode treeNode : this.getChildren()) {
            String string2 = treeNode.isTreeSelected();
            if (string.equals(string2)) continue;
            string = "util.tree.PartiallySelected";
            break;
        }
        return string;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public boolean isLeaf() {
        return WWUtil.isEmpty(this.children);
    }

    @Override
    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String string) {
        this.description = string != null ? string.trim() : null;
    }

    @Override
    public Object getImageSource() {
        return this.imageSource;
    }

    @Override
    public void setImageSource(Object object) {
        this.imageSource = object;
        this.texture = null;
    }

    @Override
    public boolean hasImage() {
        return this.getImageSource() != null;
    }

    @Override
    public BasicWWTexture getTexture() {
        if (this.texture == null) {
            this.initializeTexture();
        }
        return this.texture;
    }

    protected void initializeTexture() {
        Object object = this.getImageSource();
        if (object instanceof String || object instanceof URL) {
            URL uRL = WorldWind.getDataFileStore().requestFile(object.toString());
            if (uRL != null) {
                this.texture = new BasicWWTexture(uRL, true);
            }
        } else if (object != null) {
            this.texture = new BasicWWTexture(object, true);
        }
    }

    @Override
    public void addChild(TreeNode treeNode) {
        if (this.children == null) {
            this.children = new ArrayList<TreeNode>();
        }
        this.addChild(this.children.size(), treeNode);
    }

    @Override
    public void addChild(int n, TreeNode treeNode) {
        if (this.children == null) {
            this.children = new ArrayList<TreeNode>();
        }
        this.children.add(n, treeNode);
        this.treeSelected = null;
        treeNode.setParent(this);
        treeNode.addPropertyChangeListener(this);
        this.firePropertyChange("gov.nasa.worldwind.avkey.TreeNode", null, this);
    }

    @Override
    public void removeChild(TreeNode treeNode) {
        if (this.children != null) {
            this.children.remove(treeNode);
        }
        if (treeNode != null && treeNode.getParent() == this) {
            this.treeSelected = null;
            treeNode.setParent(null);
            treeNode.removePropertyChangeListener(this);
            this.firePropertyChange("gov.nasa.worldwind.avkey.TreeNode", null, this);
        }
    }

    @Override
    public void removeAllChildren() {
        if (this.children == null) {
            return;
        }
        Iterator<TreeNode> iterator = this.children.iterator();
        if (!iterator.hasNext()) {
            return;
        }
        while (iterator.hasNext()) {
            TreeNode treeNode = iterator.next();
            iterator.remove();
            treeNode.setParent(null);
            treeNode.removePropertyChangeListener(this);
        }
        this.treeSelected = null;
        this.firePropertyChange("gov.nasa.worldwind.avkey.TreeNode", null, this);
    }

    @Override
    public TreePath getPath() {
        TreePath treePath = new TreePath();
        for (TreeNode treeNode = this; treeNode != null; treeNode = treeNode.getParent()) {
            treePath.add(0, treeNode.getText());
        }
        return treePath;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.treeSelected = null;
        super.propertyChange(propertyChangeEvent);
    }
}

