/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.tracks;

import gov.nasa.worldwind.tracks.Track;
import gov.nasa.worldwind.tracks.TrackPoint;
import gov.nasa.worldwind.tracks.TrackPointIterator;
import gov.nasa.worldwind.tracks.TrackSegment;
import gov.nasa.worldwind.util.Logging;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class TrackPointIteratorImpl
implements TrackPointIterator {
    private Iterable<Track> trackIterable;
    private Iterator<Track> tracks;
    private Iterator<TrackSegment> segments;
    private Iterator<TrackPoint> positions;

    public TrackPointIteratorImpl(Iterable<Track> iterable) {
        this.trackIterable = iterable;
        this.reset();
    }

    @Override
    public TrackPointIteratorImpl reset() {
        if (this.trackIterable == null) {
            String string = Logging.getMessage("nullValue.TracksIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.tracks = this.trackIterable.iterator();
        this.segments = null;
        this.positions = null;
        this.loadNextPositions();
        return this;
    }

    @Override
    public boolean hasNext() {
        if (this.positions != null && this.positions.hasNext()) {
            return true;
        }
        this.loadNextPositions();
        return this.positions != null && this.positions.hasNext();
    }

    private void loadNextPositions() {
        if (this.segments != null && this.segments.hasNext()) {
            TrackSegment trackSegment = this.segments.next();
            this.positions = trackSegment.getPoints().iterator();
            return;
        }
        if (this.tracks.hasNext()) {
            Track track = this.tracks.next();
            this.segments = track.getSegments().iterator();
            this.loadNextPositions();
        }
    }

    @Override
    public TrackPoint next() {
        if (!this.hasNext()) {
            String string = Logging.getMessage("TrackPointIterator.NoMoreTrackPoints");
            Logging.logger().severe(string);
            throw new NoSuchElementException(string);
        }
        return this.positions.next();
    }

    @Override
    public void remove() {
        String string = Logging.getMessage("TrackPointIterator.RemoveNotSupported");
        Logging.logger().severe(string);
        throw new UnsupportedOperationException(string);
    }

    public int getNumPoints() {
        int n = 0;
        while (this.hasNext()) {
            ++n;
            this.next();
        }
        return n;
    }
}

