/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525.graphics.lines;

import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Path;
import gov.nasa.worldwind.symbology.TacticalGraphicLabel;
import gov.nasa.worldwind.symbology.TacticalGraphicUtil;
import gov.nasa.worldwind.symbology.milstd2525.AbstractMilStd2525TacticalGraphic;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class InfiltrationLane
extends AbstractMilStd2525TacticalGraphic {
    public static final int DEFAULT_NUM_INTERVALS = 32;
    public static final double DEFAULT_CURVATURE = 0.3;
    protected static final int NUM_CONTROL_POINTS = 9;
    protected int intervals = 32;
    protected double curvature = 0.3;
    protected Position position1;
    protected Position position2;
    protected Position position3;
    protected Path[] paths;

    public static List<String> getSupportedGraphics() {
        return Arrays.asList("G-G-OLI--------");
    }

    public InfiltrationLane(String string) {
        super(string);
    }

    public int getIntervals() {
        return this.intervals;
    }

    public void setIntervals(int n) {
        if (n < 1) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.intervals = n;
        this.onShapeChanged();
    }

    public double getCurvature() {
        return this.curvature;
    }

    public void setCurvature(double d) {
        if (d < 0.0 || d > 1.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.curvature = d;
    }

    @Override
    public void setPositions(Iterable<? extends Position> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.PositionsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        try {
            Iterator<? extends Position> iterator = iterable.iterator();
            this.position1 = iterator.next();
            this.position2 = iterator.next();
            this.position3 = iterator.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            String string = Logging.getMessage("generic.InsufficientPositions");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.paths = null;
    }

    @Override
    public Iterable<? extends Position> getPositions() {
        return Arrays.asList(this.position1, this.position2, this.position3);
    }

    @Override
    public Position getReferencePosition() {
        return this.position1;
    }

    protected int getNumControlPoints() {
        return 9;
    }

    protected void onShapeChanged() {
        this.paths = null;
    }

    @Override
    protected void doRenderGraphic(DrawContext drawContext) {
        if (this.paths == null) {
            this.createShapes(drawContext);
        }
        for (Path path : this.paths) {
            path.render(drawContext);
        }
    }

    @Override
    protected void applyDelegateOwner(Object object) {
        if (this.paths == null) {
            return;
        }
        for (Path path : this.paths) {
            path.setDelegateOwner(object);
        }
    }

    protected void createShapes(DrawContext drawContext) {
        this.paths = new Path[2];
        Globe globe = drawContext.getGlobe();
        Vec4 vec4 = globe.computePointFromLocation(this.position1);
        Vec4 vec42 = globe.computePointFromLocation(this.position2);
        Vec4 vec43 = globe.computePointFromLocation(this.position3);
        Vec4[] vec4Array = this.computeBezierControlPoints(drawContext, vec4, vec42, this.getNumControlPoints(), this.getCurvature());
        int n = this.getIntervals();
        ArrayList<Position> arrayList = new ArrayList<Position>(n);
        ArrayList<Position> arrayList2 = new ArrayList<Position>(n);
        int[] nArray = new int[vec4Array.length];
        Vec4 vec44 = Line.nearestPointOnSegment(vec4, vec42, vec43);
        Vec4 vec45 = this.bezierNearestPointToSegment(vec44, vec43, vec4Array, nArray, 0.01);
        Vec4 vec46 = vec43.subtract3(vec45);
        double d = 1.0 / (double)n;
        for (int i = 0; i <= n; ++i) {
            double d2 = (double)i * d;
            Vec4 vec47 = TacticalGraphicUtil.bezierCurve(vec4Array, d2, nArray);
            Vec4 vec48 = vec47.add3(vec46);
            Vec4 vec49 = vec47.subtract3(vec46);
            arrayList.add(globe.computePositionFromPoint(vec48));
            arrayList2.add(globe.computePositionFromPoint(vec49));
        }
        this.paths[0] = this.createPath(arrayList);
        this.paths[1] = this.createPath(arrayList2);
    }

    protected Vec4 bezierNearestPointToSegment(Vec4 vec4, Vec4 vec42, Vec4[] vec4Array, int[] nArray, double d) {
        double d2;
        double d3 = 0.0;
        double d4 = 1.0;
        Vec4 vec43 = TacticalGraphicUtil.bezierCurve(vec4Array, d3, nArray);
        Vec4 vec44 = Line.nearestPointOnSegment(vec4, vec42, vec43);
        double d5 = vec44.distanceTo3(vec43);
        do {
            vec43 = TacticalGraphicUtil.bezierCurve(vec4Array, d4, nArray);
            vec44 = Line.nearestPointOnSegment(vec4, vec42, vec43);
            double d6 = vec44.distanceTo3(vec43);
            double d7 = (d3 + d4) / 2.0;
            d2 = Math.abs(d5 - d6);
            if (d6 < d5) {
                d3 = d4;
                d5 = d6;
            }
            d4 = d7;
        } while (d2 > d);
        return vec43;
    }

    protected Vec4[] computeBezierControlPoints(DrawContext drawContext, Vec4 vec4, Vec4 vec42, int n, double d) {
        Globe globe = drawContext.getGlobe();
        Vec4 vec43 = vec42.subtract3(vec4);
        double d2 = vec43.getLength3();
        vec43 = vec43.normalize3();
        Vec4 vec44 = globe.computeSurfaceNormalAtPoint(vec4);
        Vec4 vec45 = vec43.cross3(vec44).normalize3().multiply3(d2 * d);
        Vec4[] vec4Array = new Vec4[n];
        vec4Array[0] = vec4;
        vec4Array[n - 1] = vec42;
        int[] nArray = new int[]{1, 0, -1, 0};
        double d3 = d2 / (double)n;
        for (int i = 1; i < n - 1; ++i) {
            int n2 = nArray[i % nArray.length];
            vec4Array[i] = vec4.add3(vec43.multiply3((double)i * d3)).add3(vec45.multiply3(n2));
        }
        return vec4Array;
    }

    @Override
    protected void createLabels() {
        String string = this.getText();
        if (!WWUtil.isEmpty(string)) {
            this.addLabel(string);
        }
    }

    @Override
    protected void determineLabelPositions(DrawContext drawContext) {
        if (WWUtil.isEmpty(this.labels)) {
            return;
        }
        LatLon latLon = LatLon.interpolate(0.5, this.position1, this.position2);
        ((TacticalGraphicLabel)this.labels.get(0)).setPosition(new Position(latLon, 0.0));
        ((TacticalGraphicLabel)this.labels.get(0)).setOrientationPosition(this.position2);
    }

    protected Path createPath(List<Position> list) {
        Path path = new Path(list);
        path.setFollowTerrain(true);
        path.setPathType("gov.nasa.worldwind.avkey.GreatCircle");
        path.setAltitudeMode(1);
        path.setDelegateOwner(this.getActiveDelegateOwner());
        path.setAttributes(this.getActiveShapeAttributes());
        return path;
    }
}

