/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525.graphics;

import gov.nasa.worldwind.render.Offset;
import gov.nasa.worldwind.symbology.milstd2525.graphics.TacticalGraphicSymbol;
import gov.nasa.worldwind.util.Logging;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultLabelLayouts {
    protected Map<String, List<TacticalGraphicSymbol.LabelLayout>> layouts = new HashMap<String, List<TacticalGraphicSymbol.LabelLayout>>();

    public DefaultLabelLayouts() {
        this.populateMap();
    }

    public List<TacticalGraphicSymbol.LabelLayout> get(String string) {
        List<TacticalGraphicSymbol.LabelLayout> list = this.layouts.get(string);
        return list != null ? list : Collections.emptyList();
    }

    protected void populateMap() {
        this.layouts.put("G-G-GPH--------", this.createLayout("H", Offset.CENTER, Offset.CENTER));
        this.layouts.put("G-G-GPPD-------", this.createLayout("T", Offset.CENTER, Offset.CENTER));
        List<TacticalGraphicSymbol.LabelLayout> list = new ArrayList<TacticalGraphicSymbol.LabelLayout>();
        this.addLayout(list, "T", Offset.fromFraction(1.1, 1.0), Offset.fromFraction(0.0, 1.0));
        this.addLayout(list, "H", Offset.TOP_CENTER, Offset.BOTTOM_CENTER);
        this.addLayout(list, "ENY", Offset.fromFraction(1.1, 0.35), Offset.fromFraction(0.0, 0.0));
        this.addLayout(list, "W", Offset.fromFraction(-0.1, 0.8), Offset.fromFraction(1.0, 0.0), Offset.fromFraction(-0.1, 0.8), Offset.fromFraction(1.0, 1.0));
        this.putAll(list, "G-G-GPPK-------", "G-G-GPPL-------", "G-G-GPPP-------", "G-G-GPPR-------", "G-G-GPPE-------", "G-G-GPPS-------", "G-G-GPPA-------", "G-G-OPP--------", "G-M-BCP--------", "G-M-NDP--------", "G-M-NDA--------", "G-M-NDT--------", "G-M-NDE--------", "G-M-NDB--------", "G-M-NDO--------", "G-M-NDD--------", "G-F-PCS--------", "G-F-PCB--------", "G-F-PCR--------", "G-F-PCH--------", "G-F-PCL--------", "G-S-PC---------", "G-S-PY---------", "G-S-PT---------", "G-S-PD---------", "G-S-PE---------", "G-S-PL---------", "G-S-PM---------", "G-S-PR---------", "G-S-PU---------", "G-S-PO---------", "G-S-PI---------", "G-S-PN---------", "G-S-PSZ--------", "G-S-PSA--------", "G-S-PSB--------", "G-S-PSC--------", "G-S-PSD--------", "G-S-PSE--------", "G-S-PSF--------", "G-S-PSG--------", "G-S-PSH--------", "G-S-PSI--------", "G-S-PSJ--------", "G-S-PAS--------", "G-S-PAT--------");
        list = new ArrayList<TacticalGraphicSymbol.LabelLayout>(list);
        this.addLayout(list, "H", Offset.TOP_CENTER, Offset.BOTTOM_CENTER, Offset.fromFraction(0.5, 0.9), Offset.TOP_CENTER);
        this.layouts.put("G-G-GPP--------", list);
        list = new ArrayList<TacticalGraphicSymbol.LabelLayout>(list);
        this.addLayout(list, "T", Offset.fromFraction(1.1, 1.0), Offset.fromFraction(0.0, 1.0), Offset.CENTER, Offset.CENTER);
        this.addLayout(list, "H", Offset.TOP_CENTER, Offset.BOTTOM_CENTER);
        this.layouts.put("G-S-PX---------", list);
        list = new ArrayList();
        this.addLayout(list, "Y", Offset.fromFraction(0.5, -0.1), Offset.TOP_CENTER);
        this.addLayout(list, "W", Offset.fromFraction(0.0, 1.0), Offset.fromFraction(1.0, 1.0));
        this.addLayout(list, "H", Offset.fromFraction(1.0, 1.0), Offset.fromFraction(0.0, 1.0));
        this.addLayout(list, "ENY", Offset.fromFraction(1.0, 0.0), Offset.fromFraction(0.0, 0.0));
        this.addLayout(list, "V", Offset.LEFT_CENTER, Offset.RIGHT_CENTER);
        this.addLayout(list, "T", Offset.fromFraction(0.0, 0.0), Offset.fromFraction(1.0, 0.0));
        this.layouts.put("G-M-NEB--------", list);
        this.layouts.put("G-M-NEC--------", list);
        list = new ArrayList<TacticalGraphicSymbol.LabelLayout>(list);
        this.addLayout(list, "C", Offset.TOP_CENTER, Offset.BOTTOM_CENTER);
        this.layouts.put("G-M-NZ---------", list);
        list = this.createLayout("T", Offset.fromFraction(0.5, 0.7), Offset.CENTER);
        this.layouts.put("G-G-GPRI-------", list);
        list = this.createLayout("T", Offset.fromFraction(0.5, 0.65), Offset.CENTER);
        this.layouts.put("G-G-GPPC-------", list);
        list = this.createLayout("T", Offset.fromFraction(0.75, 0.5), Offset.LEFT_CENTER);
        this.layouts.put("G-G-GPPW-------", list);
        this.layouts.put("G-F-PCF--------", list);
        list = this.createLayout("T", Offset.fromFraction(0.75, 0.75), Offset.fromFraction(0.0, 0.0));
        this.layouts.put("G-G-DPT--------", list);
        this.layouts.put("G-F-PTN--------", list);
        list = new ArrayList<TacticalGraphicSymbol.LabelLayout>(list);
        this.addLayout(list, "H", Offset.fromFraction(0.75, 0.25), Offset.fromFraction(0.0, 1.0), Offset.fromFraction(0.25, 0.25), Offset.fromFraction(1.0, 1.0));
        this.layouts.put("G-F-PTS--------", list);
        list = this.createLayout("X", Offset.fromFraction(0.75, 0.75), Offset.fromFraction(0.0, 0.0));
        this.layouts.put("G-M-OHTL-------", list);
        this.layouts.put("G-M-OHTH-------", list);
    }

    protected List<TacticalGraphicSymbol.LabelLayout> createLayout(String string, Offset offset, Offset offset2) {
        TacticalGraphicSymbol.LabelLayout labelLayout = new TacticalGraphicSymbol.LabelLayout(string);
        labelLayout.add(offset, offset2);
        return Arrays.asList(labelLayout);
    }

    protected void addLayout(List<TacticalGraphicSymbol.LabelLayout> list, String string, Offset ... offsetArray) {
        if (offsetArray.length % 2 != 0) {
            String string2 = Logging.getMessage("generic.ArrayInvalidLength", offsetArray.length);
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        TacticalGraphicSymbol.LabelLayout labelLayout = new TacticalGraphicSymbol.LabelLayout(string);
        for (int i = 0; i < offsetArray.length; i += 2) {
            Offset offset = offsetArray[i];
            Offset offset2 = offsetArray[i + 1];
            labelLayout.add(offset, offset2);
        }
        list.add(labelLayout);
    }

    protected void putAll(List<TacticalGraphicSymbol.LabelLayout> list, String ... stringArray) {
        for (String string : stringArray) {
            this.layouts.put(string, list);
        }
    }
}

