/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525;

import gov.nasa.worldwind.View;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Offset;
import gov.nasa.worldwind.render.Size;
import gov.nasa.worldwind.symbology.milstd2525.MilStd2525Constants;
import gov.nasa.worldwind.symbology.milstd2525.SymbolCode;
import gov.nasa.worldwind.util.Logging;
import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.List;

public class MilStd2525Util {
    protected static final Offset CLOVER_OFFSET = Offset.fromFraction(0.0625, 0.0625);
    protected static final Size CLOVER_SIZE = Size.fromFraction(0.890625, 0.890625);
    protected static final Offset CLOVER_C2_HQ_OFFSET = Offset.fromFraction(0.0, -0.0546875);
    protected static final Offset CLOVER_UP_OFFSET = Offset.fromFraction(0.03125, 0.1875);
    protected static final Size CLOVER_UP_SIZE = Size.fromFraction(0.9375, 0.8046875);
    protected static final Offset CLOVER_DOWN_OFFSET = Offset.fromFraction(0.03125, 0.0078125);
    protected static final Size CLOVER_DOWN_SIZE = Size.fromFraction(0.9375, 0.8046875);
    protected static final Offset ARCH_UP_OFFSET = Offset.fromFraction(0.15625, 0.1953125);
    protected static final Size ARCH_UP_SIZE = Size.fromFraction(0.6875, 0.734375);
    protected static final Offset ARCH_DOWN_OFFSET = Offset.fromFraction(0.15625, 0.0703125);
    protected static final Size ARCH_DOWN_SIZE = Size.fromFraction(0.6875, 0.734375);
    protected static final Offset CIRCLE_OFFSET = Offset.fromFraction(0.125, 0.125);
    protected static final Size CIRCLE_SIZE = Size.fromFraction(0.75, 0.75);
    protected static final Offset RECTANGLE_OFFSET = Offset.fromFraction(0.0390625, 0.1875);
    protected static final Size RECTANGLE_SIZE = Size.fromFraction(0.921875, 0.625);
    protected static final Offset RECTANGLE_C2_HQ_OFFSET = Offset.fromFraction(0.0, -0.3);
    protected static final Offset HAT_UP_OFFSET = Offset.fromFraction(0.15625, 0.1953125);
    protected static final Size HAT_UP_SIZE = Size.fromFraction(0.6875, 0.734375);
    protected static final Offset HAT_DOWN_OFFSET = Offset.fromFraction(0.15625, 0.0703125);
    protected static final Size HAT_DOWN_SIZE = Size.fromFraction(0.6875, 0.734375);
    protected static final Offset SQUARE_OFFSET = Offset.fromFraction(0.15625, 0.15625);
    protected static final Size SQUARE_SIZE = Size.fromFraction(0.6875, 0.6875);
    protected static final Offset SQUARE_C2_HQ_OFFSET = Offset.fromFraction(0.0, -0.22728);
    protected static final Offset TENT_UP_OFFSET = Offset.fromFraction(0.15625, 0.1875);
    protected static final Size TENT_UP_SIZE = Size.fromFraction(0.6875, 0.8046875);
    protected static final Offset TENT_DOWN_OFFSET = Offset.fromFraction(0.15625, 0.0);
    protected static final Size TENT_DOWN_SIZE = Size.fromFraction(0.6875, 0.8046875);
    protected static final Offset DIAMOND_OFFSET = Offset.fromFraction(0.046875, 0.046875);
    protected static final Size DIAMOND_SIZE = Size.fromFraction(0.90625, 0.90625);
    protected static final Offset DIAMOND_C2_HQ_OFFSET = Offset.fromFraction(0.0, -0.05172);

    public static SymbolInfo computeTacticalSymbolInfo(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.SymbolCodeIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        SymbolCode symbolCode = new SymbolCode(string);
        SymbolInfo symbolInfo = new SymbolInfo();
        String string3 = symbolCode.getScheme();
        String string4 = symbolCode.getStandardIdentity();
        String string5 = symbolCode.getBattleDimension();
        String string6 = symbolCode.getFunctionId();
        if (string4 != null && (string4.equalsIgnoreCase("P") || string4.equalsIgnoreCase("U") || string4.equalsIgnoreCase("G") || string4.equalsIgnoreCase("W"))) {
            if (string5 != null && (string5.equalsIgnoreCase("Z") || string5.equalsIgnoreCase("S") || string5.equalsIgnoreCase("F"))) {
                symbolInfo.iconOffset = CLOVER_OFFSET;
                symbolInfo.iconSize = CLOVER_SIZE;
            } else if (string3 != null && string3.equalsIgnoreCase("S") && string4.equalsIgnoreCase("U") && string5 != null && string5.equalsIgnoreCase("G") && string6 != null && string6.toUpperCase().equalsIgnoreCase("UH----")) {
                symbolInfo.iconOffset = CLOVER_OFFSET;
                symbolInfo.iconSize = CLOVER_SIZE;
                symbolInfo.offset = CLOVER_C2_HQ_OFFSET;
                symbolInfo.isGroundSymbol = true;
            } else if (string5 != null && string5.equalsIgnoreCase("G") || string3 != null && (string3.equalsIgnoreCase("O") || string3.equalsIgnoreCase("E"))) {
                symbolInfo.iconOffset = CLOVER_OFFSET;
                symbolInfo.iconSize = CLOVER_SIZE;
                symbolInfo.isGroundSymbol = true;
            } else if (string5 != null && (string5.equalsIgnoreCase("P") || string5.equalsIgnoreCase("A"))) {
                symbolInfo.iconOffset = CLOVER_UP_OFFSET;
                symbolInfo.iconSize = CLOVER_UP_SIZE;
            } else if (string5 != null && string5.equalsIgnoreCase("U")) {
                symbolInfo.iconOffset = CLOVER_DOWN_OFFSET;
                symbolInfo.iconSize = CLOVER_DOWN_SIZE;
            }
        } else if (string4 != null && (string4.equalsIgnoreCase("F") || string4.equalsIgnoreCase("A") || string4.equalsIgnoreCase("D") || string4.equalsIgnoreCase("M") || string4.equalsIgnoreCase("J") || string4.equalsIgnoreCase("K"))) {
            if (string5 != null && (string5.equalsIgnoreCase("P") || string5.equalsIgnoreCase("A"))) {
                symbolInfo.iconOffset = ARCH_UP_OFFSET;
                symbolInfo.iconSize = ARCH_UP_SIZE;
            } else if (string5 != null && string5.equalsIgnoreCase("U")) {
                symbolInfo.iconOffset = ARCH_DOWN_OFFSET;
                symbolInfo.iconSize = ARCH_DOWN_SIZE;
            } else if (string5 != null && (string5.equalsIgnoreCase("Z") || string5.equalsIgnoreCase("S"))) {
                symbolInfo.iconOffset = CIRCLE_OFFSET;
                symbolInfo.iconSize = CIRCLE_SIZE;
            } else if (string3 != null && string3.equalsIgnoreCase("S") && string5 != null && string5.equalsIgnoreCase("G") && string6 != null && string6.matches("E.....") || string3 != null && string3.equalsIgnoreCase("I") && string5 != null && string5.equalsIgnoreCase("G")) {
                symbolInfo.iconOffset = CIRCLE_OFFSET;
                symbolInfo.iconSize = CIRCLE_SIZE;
                symbolInfo.isGroundSymbol = true;
            } else if (string5 != null && string5.equalsIgnoreCase("F")) {
                symbolInfo.iconOffset = RECTANGLE_OFFSET;
                symbolInfo.iconSize = RECTANGLE_SIZE;
            } else if (string3 != null && string3.equalsIgnoreCase("S") && string4.equalsIgnoreCase("F") && string5 != null && string5.equalsIgnoreCase("G") && string6 != null && string6.equalsIgnoreCase("UH----")) {
                symbolInfo.iconOffset = RECTANGLE_OFFSET;
                symbolInfo.iconSize = RECTANGLE_SIZE;
                symbolInfo.offset = RECTANGLE_C2_HQ_OFFSET;
                symbolInfo.isGroundSymbol = true;
            } else if (string3 != null && string3.equalsIgnoreCase("S") && string5 != null && string5.equalsIgnoreCase("G") && (string6 == null || string6.equalsIgnoreCase("-----") || string6.toUpperCase().matches("U.....") || string6.toUpperCase().matches("I.....")) || string3 != null && (string3.equalsIgnoreCase("O") || string3.equalsIgnoreCase("E"))) {
                symbolInfo.iconOffset = RECTANGLE_OFFSET;
                symbolInfo.iconSize = RECTANGLE_SIZE;
                symbolInfo.isGroundSymbol = true;
            }
        } else if (string4 != null && (string4.equalsIgnoreCase("N") || string4.equalsIgnoreCase("L"))) {
            if (string5 != null && (string5.equalsIgnoreCase("P") || string5.equalsIgnoreCase("A"))) {
                symbolInfo.iconOffset = HAT_UP_OFFSET;
                symbolInfo.iconSize = HAT_UP_SIZE;
            } else if (string5 != null && string5.equalsIgnoreCase("U")) {
                symbolInfo.iconOffset = HAT_DOWN_OFFSET;
                symbolInfo.iconSize = HAT_DOWN_SIZE;
            } else if (string5 != null && (string5.equalsIgnoreCase("Z") || string5.equalsIgnoreCase("S") || string5.equalsIgnoreCase("F"))) {
                symbolInfo.iconOffset = SQUARE_OFFSET;
                symbolInfo.iconSize = SQUARE_SIZE;
            } else if (string3 != null && string3.equalsIgnoreCase("S") && string4.equalsIgnoreCase("N") && string5 != null && string5.equalsIgnoreCase("G") && string6 != null && string6.equalsIgnoreCase("UH----")) {
                symbolInfo.iconOffset = SQUARE_OFFSET;
                symbolInfo.iconSize = SQUARE_SIZE;
                symbolInfo.offset = SQUARE_C2_HQ_OFFSET;
                symbolInfo.isGroundSymbol = true;
            } else if (string5 != null && string5.equalsIgnoreCase("G") || string3 != null && (string3.equalsIgnoreCase("O") || string3.equalsIgnoreCase("E"))) {
                symbolInfo.iconOffset = SQUARE_OFFSET;
                symbolInfo.iconSize = SQUARE_SIZE;
                symbolInfo.isGroundSymbol = true;
            }
        } else if (string4 != null && (string4.equalsIgnoreCase("H") || string4.equalsIgnoreCase("S"))) {
            if (string5 != null && (string5.equalsIgnoreCase("P") || string5.equalsIgnoreCase("A"))) {
                symbolInfo.iconOffset = TENT_UP_OFFSET;
                symbolInfo.iconSize = TENT_UP_SIZE;
            } else if (string5 != null && string5.equalsIgnoreCase("U")) {
                symbolInfo.iconOffset = TENT_DOWN_OFFSET;
                symbolInfo.iconSize = TENT_DOWN_SIZE;
            } else if (string5 != null && (string5.equalsIgnoreCase("Z") || string5.equalsIgnoreCase("S") || string5.equalsIgnoreCase("F"))) {
                symbolInfo.iconOffset = DIAMOND_OFFSET;
                symbolInfo.iconSize = DIAMOND_SIZE;
            } else if (string3 != null && string3.equalsIgnoreCase("S") && string4.equalsIgnoreCase("H") && string5 != null && string5.equalsIgnoreCase("G") && string6 != null && string6.equalsIgnoreCase("UH----")) {
                symbolInfo.iconOffset = DIAMOND_OFFSET;
                symbolInfo.iconSize = DIAMOND_SIZE;
                symbolInfo.offset = DIAMOND_C2_HQ_OFFSET;
                symbolInfo.isGroundSymbol = true;
            } else if (string5 != null && string5.equalsIgnoreCase("G") || string3 != null && (string3.equalsIgnoreCase("O") || string3.equalsIgnoreCase("E"))) {
                symbolInfo.iconOffset = DIAMOND_OFFSET;
                symbolInfo.iconSize = DIAMOND_SIZE;
                symbolInfo.isGroundSymbol = true;
            }
        }
        return symbolInfo;
    }

    public static List<? extends Point2D> computeCenterHeadingIndicatorPoints(DrawContext drawContext, Vec4 vec4, Angle angle, double d) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle == null) {
            String string = Logging.getMessage("nullValue.HeadingIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        View view = drawContext.getView();
        Vec4 vec42 = MilStd2525Util.computeDirectionOfMovement(drawContext, vec4, angle, d);
        Vec4 vec43 = view.project(vec4);
        Vec4 vec44 = view.project(vec4.add3(vec42));
        return Arrays.asList(new Point2D.Double(0.0, 0.0), new Point2D.Double(vec44.x - vec43.x, vec44.y - vec43.y));
    }

    public static List<? extends Point2D> computeGroundHeadingIndicatorPoints(DrawContext drawContext, Vec4 vec4, Angle angle, double d, double d2) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle == null) {
            String string = Logging.getMessage("nullValue.HeadingIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        View view = drawContext.getView();
        Vec4 vec42 = MilStd2525Util.computeDirectionOfMovement(drawContext, vec4, angle, d);
        Vec4 vec43 = view.project(vec4);
        Vec4 vec44 = view.project(vec4.add3(vec42));
        return Arrays.asList(new Point2D.Double(0.0, 0.0), new Point2D.Double(0.0, -d2 / 2.0), new Point2D.Double(vec44.x - vec43.x, -d2 / 2.0 + (vec44.y - vec43.y)));
    }

    protected static Vec4 computeDirectionOfMovement(DrawContext drawContext, Vec4 vec4, Angle angle, double d) {
        View view = drawContext.getView();
        Globe globe = drawContext.getGlobe();
        double d2 = view.computePixelSizeAtDistance(view.getEyePoint().distanceTo3(vec4));
        Position position = globe.computePositionFromPoint(vec4);
        Matrix matrix = globe.computeSurfaceOrientationAtPosition(position);
        Vec4 vec42 = new Vec4(angle.sin(), angle.cos());
        return vec42.transformBy3(matrix).normalize3().multiply3(d * d2);
    }

    public static Material getDefaultGraphicMaterial(SymbolCode symbolCode) {
        if (symbolCode == null) {
            String string = Logging.getMessage("nullValue.SymbolCodeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (MilStd2525Util.isObstacle(symbolCode)) {
            return MilStd2525Constants.MATERIAL_OBSTACLE;
        }
        String string = symbolCode.getStandardIdentity();
        if ("F".equalsIgnoreCase(string) || "A".equalsIgnoreCase(string) || "M".equalsIgnoreCase(string)) {
            return MilStd2525Constants.MATERIAL_FRIEND;
        }
        if ("H".equalsIgnoreCase(string) || "S".equalsIgnoreCase(string) || "J".equalsIgnoreCase(string) || "K".equalsIgnoreCase(string)) {
            return MilStd2525Constants.MATERIAL_HOSTILE;
        }
        if ("N".equalsIgnoreCase(string) || "L".equalsIgnoreCase(string)) {
            return MilStd2525Constants.MATERIAL_NEUTRAL;
        }
        return MilStd2525Constants.MATERIAL_UNKNOWN;
    }

    protected static boolean isObstacle(SymbolCode symbolCode) {
        if (symbolCode == null) {
            return false;
        }
        String string = symbolCode.getScheme();
        String string2 = symbolCode.getCategory();
        String string3 = symbolCode.getFunctionId();
        return "G".equalsIgnoreCase(string) && "M".equalsIgnoreCase(string2) && (string3.charAt(0) == 'o' || string3.charAt(0) == 'O');
    }

    public static class SymbolInfo {
        public Offset iconOffset;
        public Size iconSize;
        public Offset offset;
        public boolean isGroundSymbol;
    }
}

