/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.AbstractSurfaceShape;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import gov.nasa.worldwind.util.SurfaceTileDrawContext;
import gov.nasa.worldwind.util.WWMath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SurfaceEllipse
extends AbstractSurfaceShape {
    protected static final int MIN_NUM_INTERVALS = 8;
    protected static final int DEFAULT_NUM_INTERVALS = 32;
    protected LatLon center = LatLon.ZERO;
    protected double majorRadius;
    protected double minorRadius;
    protected Angle heading = Angle.ZERO;
    private int intervals = 32;

    public SurfaceEllipse() {
    }

    public SurfaceEllipse(ShapeAttributes shapeAttributes) {
        super(shapeAttributes);
    }

    public SurfaceEllipse(LatLon latLon, double d, double d2) {
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.CenterIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d < 0.0) {
            String string = Logging.getMessage("Geom.RadiusIsNegative", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d2 < 0.0) {
            String string = Logging.getMessage("Geom.RadiusIsNegative", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.center = latLon;
        this.majorRadius = d;
        this.minorRadius = d2;
    }

    public SurfaceEllipse(LatLon latLon, double d, double d2, Angle angle) {
        this(latLon, d, d2);
        if (angle == null) {
            String string = Logging.getMessage("nullValue.HeadingIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.heading = angle;
    }

    public SurfaceEllipse(LatLon latLon, double d, double d2, Angle angle, int n) {
        this(latLon, d, d2, angle);
        if (n < 8) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.intervals = n;
    }

    public SurfaceEllipse(ShapeAttributes shapeAttributes, LatLon latLon, double d, double d2) {
        super(shapeAttributes);
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.CenterIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d < 0.0) {
            String string = Logging.getMessage("Geom.RadiusIsNegative", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d2 < 0.0) {
            String string = Logging.getMessage("Geom.RadiusIsNegative", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.center = latLon;
        this.majorRadius = d;
        this.minorRadius = d2;
    }

    public SurfaceEllipse(ShapeAttributes shapeAttributes, LatLon latLon, double d, double d2, Angle angle) {
        this(shapeAttributes, latLon, d, d2);
        if (angle == null) {
            String string = Logging.getMessage("nullValue.HeadingIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.heading = angle;
    }

    public SurfaceEllipse(ShapeAttributes shapeAttributes, LatLon latLon, double d, double d2, Angle angle, int n) {
        this(shapeAttributes, latLon, d, d2, angle);
        if (n < 8) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.intervals = n;
    }

    public LatLon getCenter() {
        return this.center;
    }

    public void setCenter(LatLon latLon) {
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.CenterIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.center = latLon;
        this.onShapeChanged();
    }

    public double getMajorRadius() {
        return this.majorRadius;
    }

    public double getMinorRadius() {
        return this.minorRadius;
    }

    public void setMajorRadius(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("Geom.RadiusIsNegative", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.majorRadius = d;
        this.onShapeChanged();
    }

    public void setMinorRadius(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("Geom.RadiusIsNegative", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.minorRadius = d;
        this.onShapeChanged();
    }

    public void setRadii(double d, double d2) {
        this.setMajorRadius(d);
        this.setMinorRadius(d2);
    }

    public Angle getHeading() {
        return this.heading;
    }

    public void setHeading(Angle angle) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.HeadingIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.heading = angle;
        this.onShapeChanged();
    }

    public int getIntervals() {
        return this.intervals;
    }

    public void setIntervals(int n) {
        if (n < 8) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.intervals = n;
        this.onShapeChanged();
    }

    @Override
    public Object getStateKey(DrawContext drawContext) {
        return new AbstractSurfaceShape.SurfaceShapeStateKey(this.getUniqueId(), this.lastModifiedTime, this.getActiveAttributes().copy(), drawContext.getGlobe().getStateKey(drawContext));
    }

    @Override
    public Iterable<? extends LatLon> getLocations(Globe globe) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.computeLocations(globe, this.intervals);
    }

    @Override
    public Position getReferencePosition() {
        return new Position(this.center, 0.0);
    }

    @Override
    protected void doMoveTo(Position position, Position position2) {
        Angle angle = LatLon.greatCircleAzimuth(position, this.center);
        Angle angle2 = LatLon.greatCircleDistance(position, this.center);
        this.setCenter(LatLon.greatCircleEndPosition((LatLon)position2, angle, angle2));
    }

    protected List<LatLon> computeLocations(Globe globe, int n) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.majorRadius == 0.0 && this.minorRadius == 0.0) {
            return null;
        }
        int n2 = 1 + Math.max(8, n);
        double d = Math.PI * 2 / (double)(n2 - 1);
        double d2 = globe.getRadiusAt(this.center.getLatitude(), this.center.getLongitude());
        LatLon[] latLonArray = new LatLon[n2];
        for (int i = 0; i < n2; ++i) {
            double d3 = i != n2 - 1 ? (double)i * d : 0.0;
            double d4 = this.majorRadius * Math.cos(d3);
            double d5 = this.minorRadius * Math.sin(d3);
            double d6 = Math.sqrt(d4 * d4 + d5 * d5);
            double d7 = 1.5707963267948966 - (Math.acos(d4 / d6) * Math.signum(d5) - this.heading.radians);
            latLonArray[i] = LatLon.greatCircleEndPosition(this.center, d7, d6 / d2);
        }
        return Arrays.asList(latLonArray);
    }

    @Override
    protected List<List<LatLon>> createGeometry(Globe globe, SurfaceTileDrawContext surfaceTileDrawContext) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = this.computeEdgeIntervalsPerDegree(surfaceTileDrawContext);
        int n = this.computeNumIntervals(globe, d);
        List<LatLon> list = this.computeLocations(globe, n);
        if (list == null) {
            return null;
        }
        ArrayList<List<LatLon>> arrayList = new ArrayList<List<LatLon>>();
        arrayList.add(list);
        return arrayList;
    }

    protected int computeNumIntervals(Globe globe, double d) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n = this.computeNumEdgeIntervals(globe, d);
        return n * this.intervals;
    }

    protected int computeNumEdgeIntervals(Globe globe, double d) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n = 1 + Math.max(8, this.intervals);
        double d2 = Math.max(this.majorRadius, this.minorRadius);
        double d3 = Math.PI * 2 / (double)(n - 1);
        Angle angle = Angle.fromRadians(d3 * d2 / globe.getRadiusAt(this.center));
        double d4 = WWMath.clamp(d * angle.degrees, (double)this.minEdgeIntervals, (double)this.maxEdgeIntervals);
        return (int)Math.ceil(d4);
    }

    @Override
    protected void doGetRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        super.doGetRestorableState(restorableSupport, stateObject);
        restorableSupport.addStateValueAsLatLon(stateObject, "center", this.getCenter());
        restorableSupport.addStateValueAsDouble(stateObject, "majorRadius", this.getMajorRadius());
        restorableSupport.addStateValueAsDouble(stateObject, "minorRadius", this.getMinorRadius());
        restorableSupport.addStateValueAsDouble(stateObject, "headingDegrees", this.getHeading().degrees);
        restorableSupport.addStateValueAsInteger(stateObject, "intervals", this.getIntervals());
    }

    @Override
    protected void doRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        Double d;
        super.doRestoreState(restorableSupport, stateObject);
        LatLon latLon = restorableSupport.getStateValueAsLatLon(stateObject, "center");
        if (latLon != null) {
            this.setCenter(latLon);
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "majorRadius")) != null) {
            this.setMajorRadius(d);
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "minorRadius")) != null) {
            this.setMinorRadius(d);
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "headingDegrees")) != null) {
            this.setHeading(Angle.fromDegrees(d));
        }
        Integer n = restorableSupport.getStateValueAsInteger(stateObject, "intervals");
        if (d != null) {
            this.setIntervals(n);
        }
    }

    @Override
    protected void legacyRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        super.legacyRestoreState(restorableSupport, stateObject);
        Double d = restorableSupport.getStateValueAsDouble(stateObject, "orientationDegrees");
        if (d != null) {
            this.setHeading(Angle.fromDegrees(d));
        }
    }
}

