/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.render.AbstractAnnotationBalloon;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.GlobeAnnotation;
import gov.nasa.worldwind.render.GlobeBalloon;
import gov.nasa.worldwind.util.Logging;

public class GlobeAnnotationBalloon
extends AbstractAnnotationBalloon
implements GlobeBalloon {
    protected Position position;
    protected int altitudeMode;
    protected GlobeAnnotation annotation;

    public GlobeAnnotationBalloon(String string, Position position) {
        super(string);
        if (position == null) {
            String string2 = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.position = position;
        this.annotation = this.createAnnotation();
    }

    @Override
    protected GlobeAnnotation createAnnotation() {
        GlobeAnnotation globeAnnotation = new GlobeAnnotation(this.getDecodedText(), this.position);
        globeAnnotation.getAttributes().setHighlightScale(1.0);
        return globeAnnotation;
    }

    @Override
    protected GlobeAnnotation getAnnotation() {
        return this.annotation;
    }

    @Override
    protected void computePosition(DrawContext drawContext) {
        GlobeAnnotation globeAnnotation = this.getAnnotation();
        globeAnnotation.setPosition(this.getPosition());
        globeAnnotation.setAltitudeMode(this.getAltitudeMode());
    }

    @Override
    public void setPosition(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.position = position;
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    @Override
    public int getAltitudeMode() {
        return this.altitudeMode;
    }

    @Override
    public void setAltitudeMode(int n) {
        this.altitudeMode = n;
    }
}

